/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.math.BigDecimal;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MForecastLine;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRMALine;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_Forecast;
import org.compiere.process.DocAction;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;
import org.eevolution.model.MPPCostCollector;
import org.eevolution.model.MPPMRP;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPOrderBOMLine;

public class LiberoValidator
implements ModelValidator {
    public static final String CTX_IsLiberoEnabled = "#IsLiberoEnabled";
    private CLogger log = CLogger.getCLogger(this.getClass());
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("M_Product", this);
        for (String mrpTableName : MPPMRP.getSourceTableNames()) {
            engine.addModelChange(mrpTableName, this);
        }
        engine.addDocValidate("M_InOut", this);
        engine.addDocValidate("M_Movement", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        PO fl;
        PO ol;
        PO order;
        this.log.info(po.get_TableName() + " Type: " + type);
        boolean isChange = 4 == type || 5 == type && MPPMRP.isChanged(po);
        boolean isDelete = 3 == type;
        boolean isReleased = false;
        boolean isVoided = false;
        DocAction doc = null;
        if (po instanceof DocAction) {
            doc = (DocAction)((Object)po);
        } else if (po instanceof MOrderLine) {
            doc = ((MOrderLine)po).getParent();
        }
        if (doc != null) {
            String docStatus = doc.getDocStatus();
            isReleased = "IP".equals(docStatus) || "CO".equals(docStatus);
            isVoided = "VO".equals(docStatus);
        }
        if (po instanceof MProduct && 2 == type && po.is_ValueChanged("C_UOM_ID") && MPPMRP.hasProductRecords((MProduct)po)) {
            throw new AdempiereException("@SaveUomError@");
        }
        if (isDelete || isVoided || !po.isActive()) {
            MPPMRP.deleteMRP(po);
        } else if (po instanceof MOrder) {
            order = (MOrder)po;
            if (isChange && !order.isSOTrx()) {
                MPPMRP.C_Order(order);
            } else if (type == 5 && order.isSOTrx() && (isReleased || MPPMRP.isChanged(order))) {
                MPPMRP.C_Order(order);
            }
        } else if (po instanceof MOrderLine && isChange) {
            ol = (MOrderLine)po;
            MOrder order2 = ol.getParent();
            if (!order2.isSOTrx()) {
                MPPMRP.C_OrderLine(ol);
            } else if (order2.isSOTrx() && isReleased) {
                MPPMRP.C_OrderLine(ol);
            }
        } else if (po instanceof MRequisition && isChange) {
            MRequisition r = (MRequisition)po;
            MPPMRP.M_Requisition(r);
        } else if (po instanceof MRequisitionLine && isChange) {
            MRequisitionLine rl = (MRequisitionLine)po;
            MPPMRP.M_RequisitionLine(rl);
        } else if (po instanceof X_M_Forecast && isChange) {
            fl = (X_M_Forecast)po;
            MPPMRP.M_Forecast(fl);
        } else if (po instanceof MForecastLine && isChange) {
            fl = (MForecastLine)po;
            MPPMRP.M_ForecastLine((MForecastLine)fl);
        } else if (po instanceof MDDOrder && isChange) {
            order = (MDDOrder)po;
            MPPMRP.DD_Order((MDDOrder)order);
        } else if (po instanceof MDDOrderLine && isChange) {
            ol = (MDDOrderLine)po;
            MPPMRP.DD_OrderLine((MDDOrderLine)ol);
        } else if (po instanceof MPPOrder && isChange) {
            order = (MPPOrder)po;
            MPPMRP.PP_Order((MPPOrder)order);
        } else if (po instanceof MPPOrderBOMLine && isChange) {
            MPPOrderBOMLine obl = (MPPOrderBOMLine)po;
            MPPMRP.PP_Order_BOMLine(obl);
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        this.log.info(po.get_TableName() + " Timing: " + timing);
        if (po instanceof MInOut && timing == 9) {
            MInOut inout = (MInOut)po;
            if (inout.isSOTrx()) {
                for (MInOutLine outline : inout.getLines()) {
                    this.updateMPPOrder(outline);
                }
            } else {
                for (MInOutLine line : inout.getLines()) {
                    String whereClause = "C_OrderLine_ID=? AND PP_Cost_Collector_ID IS NOT NULL";
                    List olines = new Query(po.getCtx(), "C_OrderLine", "C_OrderLine_ID=? AND PP_Cost_Collector_ID IS NOT NULL", po.get_TrxName()).setParameters(line.getC_OrderLine_ID()).list();
                    for (MOrderLine oline : olines) {
                        if (oline.getQtyOrdered().compareTo(oline.getQtyDelivered()) < 0) continue;
                        MPPCostCollector cc = new MPPCostCollector(po.getCtx(), oline.getPP_Cost_Collector_ID(), po.get_TrxName());
                        String docStatus = cc.completeIt();
                        cc.setDocStatus(docStatus);
                        cc.setDocAction("CL");
                        cc.saveEx();
                        return null;
                    }
                }
            }
        } else if (po instanceof MMovement && timing == 9) {
            MMovement move = (MMovement)po;
            for (MMovementLine line : move.getLines(false)) {
                if (line.getDD_OrderLine_ID() <= 0) continue;
                MDDOrderLine oline = new MDDOrderLine(line.getCtx(), line.getDD_OrderLine_ID(), po.get_TrxName());
                MLocator locator_to = MLocator.get(line.getCtx(), line.getM_LocatorTo_ID());
                MWarehouse warehouse = MWarehouse.get(line.getCtx(), locator_to.getM_Warehouse_ID());
                if (warehouse.isInTransit()) {
                    oline.setQtyInTransit(oline.getQtyInTransit().add(line.getMovementQty()));
                    oline.setConfirmedQty(Env.ZERO);
                } else {
                    oline.setQtyInTransit(oline.getQtyInTransit().subtract(line.getMovementQty()));
                    oline.setQtyDelivered(oline.getQtyDelivered().add(line.getMovementQty()));
                }
                oline.saveEx();
            }
            if (move.getDD_Order_ID() > 0) {
                MDDOrder order = new MDDOrder(move.getCtx(), move.getDD_Order_ID(), move.get_TrxName());
                order.setIsInTransit(this.isInTransting(order));
                order.reserveStock(order.getLines(true, null));
                order.saveEx();
            }
        }
        return null;
    }

    private boolean isInTransting(MDDOrder order) {
        for (MDDOrderLine line : order.getLines(true, null)) {
            if (line.getQtyInTransit().signum() == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        Env.setContext(Env.getCtx(), CTX_IsLiberoEnabled, true);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    private void updateMPPOrder(MInOutLine outline) {
        MPPOrder order = null;
        BigDecimal qtyShipment = Env.ZERO;
        MInOut inout = outline.getParent();
        String movementType = inout.getMovementType();
        int C_OrderLine_ID = 0;
        if ("C-".equals(movementType)) {
            C_OrderLine_ID = outline.getC_OrderLine_ID();
            qtyShipment = outline.getMovementQty();
        } else if ("C+".equals(movementType)) {
            MRMALine rmaline = new MRMALine(outline.getCtx(), outline.getM_RMALine_ID(), null);
            MInOutLine line = (MInOutLine)rmaline.getM_InOutLine();
            C_OrderLine_ID = line.getC_OrderLine_ID();
            qtyShipment = outline.getMovementQty().negate();
        }
        String whereClause = " C_OrderLine_ID = ?  AND DocStatus IN  (?,?) AND EXISTS (SELECT 1 FROM  PP_Order_BOM  WHERE PP_Order_BOM.PP_Order_ID=PP_Order.PP_Order_ID AND PP_Order_BOM.BOMType =? )";
        order = (MPPOrder)new Query(outline.getCtx(), "PP_Order", " C_OrderLine_ID = ?  AND DocStatus IN  (?,?) AND EXISTS (SELECT 1 FROM  PP_Order_BOM  WHERE PP_Order_BOM.PP_Order_ID=PP_Order.PP_Order_ID AND PP_Order_BOM.BOMType =? )", outline.get_TrxName()).setParameters(C_OrderLine_ID, "IP", "CO", "K").firstOnly();
        if (order == null) {
            return;
        }
        if ("IP".equals(order.getDocStatus())) {
            order.completeIt();
            order.setDocStatus("CO");
            order.setDocAction("CL");
            order.saveEx();
        }
        if ("CO".equals(order.getDocStatus())) {
            String description = order.getDescription() != null ? order.getDescription() : "" + Msg.translate(inout.getCtx(), "M_InOut_ID") + " : " + Msg.translate(inout.getCtx(), "DocumentNo");
            order.setDescription(description);
            order.updateMakeToKit(qtyShipment);
            order.saveEx();
        }
        if (order.getQtyToDeliver().compareTo(Env.ZERO) == 0) {
            order.closeIt();
            order.setDocStatus("CL");
            order.setDocAction("--");
            order.saveEx();
        }
    }
}

