/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.JFrame;
import org.compiere.apps.ADialog;
import org.compiere.apps.ProcessParameter;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.form.action.PopupAction;
import org.eevolution.process.ProcessInfoHandler;
import org.eevolution.tools.swing.SwingTool;

public abstract class ProcessPopupAction
extends PopupAction {
    protected JFrame window;
    protected ProcessInfoHandler pih;

    protected abstract void doProcess();

    protected abstract int getProcessID();

    public ProcessPopupAction(String property, JFrame window) {
        super(property);
        this.window = window;
    }

    @Override
    protected void beforeAction() {
        SwingTool.setCursorsFromParent(this.window.getContentPane(), true);
        super.beforeAction();
        this.pih = new ProcessInfoHandler(this.getProcessID());
        this.showDialog(this.pih);
    }

    @Override
    protected void doAction(ActionEvent e) {
        if (this.successful()) {
            this.doProcess();
        }
    }

    @Override
    protected void afterAction() {
        super.afterAction();
        if (this.isIgnoreChange()) {
            SwingTool.setCursorsFromParent(this.window, false);
            return;
        }
        if (this.successful()) {
            ADialog.info(Env.getWindowNo(this.getWindow()), this.getWindow(), Msg.translate(Env.getCtx(), "Success"), this.getSuccessMsg());
        } else {
            ADialog.error(Env.getWindowNo(this.getWindow()), this.getWindow(), Msg.translate(Env.getCtx(), "Error"), this.getErrorMsg());
        }
        SwingTool.setCursorsFromParent(this.window, false);
    }

    protected int getParameterValueAsInt(String name) {
        Object o = this.pih.getParameterValue(name);
        int value = -1;
        value = o instanceof Integer ? (Integer)o : (o instanceof BigDecimal ? ((BigDecimal)o).intValue() : Integer.parseInt(o.toString()));
        return value;
    }

    public JFrame getWindow() {
        return this.window;
    }

    protected Object getParameterValue(String name) {
        return this.pih.getParameterValue(name);
    }

    protected void showDialog(ProcessInfoHandler pib) {
        ProcessParameter para = new ProcessParameter((Frame)Env.getFrame(this.window), Env.getWindowNo(this.window), pib.getProcessInfo());
        if (para.initDialog()) {
            para.setVisible(true);
            if (!para.isOK()) {
                this.setError(Msg.translate(Env.getCtx(), "Cancel"));
                this.setIgnoreChange(true);
                pib.setProcessError();
                return;
            }
        }
    }
}

