/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MPaymentBatch;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.ValueNamePair;
import org.eevolution.model.MHRPaySelectionCheck;

public class HRPayPrint {
    public int m_WindowNo = 0;
    public int m_C_BankAccount_ID = -1;
    public Collection<MHRPaySelectionCheck> m_checks = null;
    public MPaymentBatch m_batch = null;
    public static CLogger log = CLogger.getCLogger(HRPayPrint.class);
    public String bank;
    public String currency;
    public BigDecimal balance;
    public String noPayments;
    public Integer documentNo;

    public ArrayList<KeyNamePair> getPaySelectionData() {
        ArrayList<KeyNamePair> arrayList = new ArrayList<KeyNamePair>();
        log.config("");
        int n = Env.getAD_Client_ID(Env.getCtx());
        String string = "SELECT HR_PaySelection_ID, Name || ' - ' || TotalAmt FROM HR_PaySelection WHERE AD_Client_ID=? AND Processed='Y' AND IsActive='Y'ORDER BY PayDate DESC";
        try {
            CPreparedStatement cPreparedStatement = DB.prepareStatement(string, null);
            cPreparedStatement.setInt(1, n);
            ResultSet resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                KeyNamePair keyNamePair = new KeyNamePair(resultSet.getInt(1), resultSet.getString(2));
                arrayList.add(keyNamePair);
            }
            resultSet.close();
            cPreparedStatement.close();
        }
        catch (SQLException sQLException) {
            log.log(Level.SEVERE, string, sQLException);
        }
        return arrayList;
    }

    public void loadPaySelectInfo(int n) {
        this.m_C_BankAccount_ID = -1;
        String string = "SELECT ps.C_BankAccount_ID, b.Name || ' ' || ba.AccountNo, c.ISO_Code, CurrentBalance FROM HR_PaySelection ps INNER JOIN C_BankAccount ba ON (ps.C_BankAccount_ID=ba.C_BankAccount_ID) INNER JOIN C_Bank b ON (ba.C_Bank_ID=b.C_Bank_ID) INNER JOIN C_Currency c ON (ba.C_Currency_ID=c.C_Currency_ID) WHERE ps.HR_PaySelection_ID=? AND ps.Processed='Y' AND ba.IsActive='Y'";
        try {
            CPreparedStatement cPreparedStatement = DB.prepareStatement(string, null);
            cPreparedStatement.setInt(1, n);
            ResultSet resultSet = cPreparedStatement.executeQuery();
            if (resultSet.next()) {
                this.m_C_BankAccount_ID = resultSet.getInt(1);
                this.bank = resultSet.getString(2);
                this.currency = resultSet.getString(3);
                this.balance = resultSet.getBigDecimal(4);
            } else {
                this.m_C_BankAccount_ID = -1;
                this.bank = "";
                this.currency = "";
                this.balance = Env.ZERO;
                log.log(Level.SEVERE, "No active BankAccount for HR_PaySelection_ID=" + n);
            }
            resultSet.close();
            cPreparedStatement.close();
        }
        catch (SQLException sQLException) {
            log.log(Level.SEVERE, string, sQLException);
        }
    }

    public ArrayList<ValueNamePair> loadPaymentRule(int n) {
        ArrayList<ValueNamePair> arrayList = new ArrayList<ValueNamePair>();
        int n2 = 195;
        Language language = Language.getLanguage(Env.getAD_Language(Env.getCtx()));
        MLookupInfo mLookupInfo = MLookupFactory.getLookup_List(language, n2);
        String string = mLookupInfo.Query.substring(0, mLookupInfo.Query.indexOf(" ORDER BY")) + " AND " + mLookupInfo.KeyColumn + " IN (SELECT PaymentRule FROM HR_PaySelectionCheck WHERE HR_PaySelection_ID=?) " + mLookupInfo.Query.substring(mLookupInfo.Query.indexOf(" ORDER BY"));
        try {
            CPreparedStatement cPreparedStatement = DB.prepareStatement(string, null);
            cPreparedStatement.setInt(1, n);
            ResultSet resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                ValueNamePair valueNamePair = new ValueNamePair(resultSet.getString(2), resultSet.getString(3));
                arrayList.add(valueNamePair);
            }
            resultSet.close();
            cPreparedStatement.close();
        }
        catch (SQLException sQLException) {
            log.log(Level.SEVERE, string, sQLException);
        }
        if (arrayList.size() == 0) {
            log.config("PaySel=" + n + ", BAcct=" + this.m_C_BankAccount_ID + " - " + string);
        }
        return arrayList;
    }

    public String loadPaymentRuleInfo(int n, String string) {
        ResultSet resultSet;
        CPreparedStatement cPreparedStatement;
        String string2 = null;
        String string3 = "SELECT COUNT(*) FROM HR_PaySelectionCheck WHERE HR_PaySelection_ID=?";
        try {
            cPreparedStatement = DB.prepareStatement(string3, null);
            cPreparedStatement.setInt(1, n);
            resultSet = cPreparedStatement.executeQuery();
            if (resultSet.next()) {
                this.noPayments = String.valueOf(resultSet.getInt(1));
            }
            resultSet.close();
            cPreparedStatement.close();
        }
        catch (SQLException sQLException) {
            log.log(Level.SEVERE, string3, sQLException);
        }
        string3 = "SELECT CurrentNext FROM C_BankAccountDoc WHERE C_BankAccount_ID=? AND PaymentRule=? AND IsActive='Y'";
        try {
            cPreparedStatement = DB.prepareStatement(string3, null);
            cPreparedStatement.setInt(1, this.m_C_BankAccount_ID);
            cPreparedStatement.setString(2, string);
            resultSet = cPreparedStatement.executeQuery();
            if (resultSet.next()) {
                this.documentNo = new Integer(resultSet.getInt(1));
            } else {
                log.log(Level.SEVERE, "VPayPrint.loadPaymentRuleInfo - No active BankAccountDoc for C_BankAccount_ID=" + this.m_C_BankAccount_ID + " AND PaymentRule=" + string);
                string2 = "VPayPrintNoDoc";
            }
            resultSet.close();
            cPreparedStatement.close();
        }
        catch (SQLException sQLException) {
            log.log(Level.SEVERE, string3, sQLException);
        }
        return string2;
    }
}

