/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;
import org.eevolution.model.I_HR_Concept;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHRProcess;

public class HRActionNotice {
    protected static CLogger log = CLogger.getCLogger(HRActionNotice.class);
    public int m_WindowNo = 0;
    public static MHRProcess m_process = null;
    public static int m_HR_Process_ID = 0;
    public static int m_HR_Payroll_ID = 0;
    public static int m_HR_Concept_ID = 0;
    public static int m_C_BPartner_ID = 0;
    public static int sHR_Movement_ID = 0;
    public Timestamp m_dateStart = null;
    public static Timestamp m_dateEnd = null;
    public int m_qty = 0;
    public BigDecimal m_amount = Env.ZERO;
    public String m_text = null;
    public Timestamp m_date = null;

    public void dynInit() throws Exception {
        log.info("HRActionNotice");
    }

    public void configureMiniTable(IMiniTable iMiniTable) {
        iMiniTable.addColumn("HR_Movement_ID");
        iMiniTable.addColumn("AD_Org_ID");
        iMiniTable.addColumn("HR_Concept_ID");
        iMiniTable.addColumn("ValidFrom");
        iMiniTable.addColumn("ColumnType");
        iMiniTable.addColumn("Qty");
        iMiniTable.addColumn("Amount");
        iMiniTable.addColumn("ServiceDate");
        iMiniTable.addColumn("Text");
        iMiniTable.addColumn("Description");
        iMiniTable.setColumnClass(0, IDColumn.class, false, " ");
        iMiniTable.setColumnClass(1, String.class, true, Msg.translate(Env.getCtx(), "AD_Org_ID"));
        iMiniTable.setColumnClass(2, String.class, true, Msg.translate(Env.getCtx(), "HR_Concept_ID"));
        iMiniTable.setColumnClass(3, Timestamp.class, true, Msg.translate(Env.getCtx(), "ValidFrom"));
        iMiniTable.setColumnClass(4, String.class, true, Msg.translate(Env.getCtx(), "ColumnType"));
        iMiniTable.setColumnClass(5, BigDecimal.class, true, Msg.translate(Env.getCtx(), "Qty"));
        iMiniTable.setColumnClass(6, BigDecimal.class, true, Msg.translate(Env.getCtx(), "Amount"));
        iMiniTable.setColumnClass(7, Timestamp.class, true, Msg.translate(Env.getCtx(), "ServiceDate"));
        iMiniTable.setColumnClass(8, String.class, true, Msg.translate(Env.getCtx(), "Text"));
        iMiniTable.setColumnClass(9, String.class, true, Msg.translate(Env.getCtx(), "Description"));
        iMiniTable.autoSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeQuery(Properties properties, IMiniTable iMiniTable) {
        StringBuffer stringBuffer = new StringBuffer("SELECT DISTINCT o.Name,hp.Name, bp.Name,hc.Name,hm.ValidFrom,(" + HRActionNotice.getSQL_ColumnType(properties, "hc.ColumnType") + ") AS ColumnType," + " hm.Qty,hm.Amount,hm.ServiceDate,hm.TextMsg,er.Name,hm.Description " + " , HR_Movement_id, hm.AD_Org_ID,hp.HR_Process_ID,hm.HR_Concept_ID " + " FROM HR_Movement hm " + " INNER JOIN AD_Org o ON (hm.AD_Org_ID=o.AD_Org_ID)" + " INNER JOIN HR_Process hp ON (hm.HR_Process_ID=hp.HR_Process_ID)" + " INNER JOIN C_BPartner bp ON (hm.C_BPartner_ID=bp.C_BPartner_ID)" + " INNER JOIN HR_Employee e ON (e.C_BPartner_ID=bp.C_BPartner_ID)" + " INNER JOIN HR_Concept hc ON (hm.HR_Concept_ID=hc.HR_Concept_ID)" + " LEFT OUTER JOIN AD_Rule er ON (hm.AD_Rule_ID=er.AD_Rule_ID)" + " WHERE hm.Processed='N' AND hp.HR_Process_ID = " + m_HR_Process_ID + " AND hm.C_BPartner_ID = " + m_C_BPartner_ID);
        stringBuffer.append(" ORDER BY hm.AD_Org_ID,hp.HR_Process_ID,bp.Name,hm.ValidFrom,hm.HR_Concept_ID");
        int n = 0;
        iMiniTable.setRowCount(n);
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            cPreparedStatement = DB.prepareStatement(stringBuffer.toString(), null);
            resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                iMiniTable.setRowCount(n + 1);
                iMiniTable.setColumnClass(0, IDColumn.class, false, " ");
                iMiniTable.setValueAt(resultSet.getString(1), n, 1);
                iMiniTable.setValueAt(resultSet.getString(4), n, 2);
                iMiniTable.setValueAt(resultSet.getTimestamp(5), n, 3);
                iMiniTable.setValueAt(resultSet.getString(6), n, 4);
                iMiniTable.setValueAt(resultSet.getObject(7) != null ? resultSet.getBigDecimal(7) : Env.ZERO, n, 5);
                iMiniTable.setValueAt(resultSet.getObject(8) != null ? resultSet.getBigDecimal(8) : Env.ZERO, n, 6);
                iMiniTable.setValueAt(resultSet.getTimestamp(9), n, 7);
                iMiniTable.setValueAt(resultSet.getString(10), n, 8);
                iMiniTable.setValueAt(resultSet.getString(12), n, 9);
                ++n;
            }
        }
        catch (SQLException sQLException) {
            try {
                log.log(Level.SEVERE, stringBuffer.toString(), sQLException);
            }
            catch (Throwable throwable) {
                DB.close(resultSet, cPreparedStatement);
                resultSet = null;
                cPreparedStatement = null;
                throw throwable;
            }
            DB.close(resultSet, cPreparedStatement);
            resultSet = null;
            cPreparedStatement = null;
        }
        DB.close(resultSet, cPreparedStatement);
        resultSet = null;
        cPreparedStatement = null;
        iMiniTable.autoSize();
    }

    public static KeyNamePair[] getProcess() {
        String string = MRole.getDefault().addAccessSQL("SELECT hrp.HR_Process_ID,hrp.DocumentNo ||'-'|| hrp.Name,hrp.DocumentNo,hrp.Name FROM HR_Process hrp", "hrp", true, false) + " AND hrp.IsActive = 'Y' ";
        string = string + " ORDER BY hrp.DocumentNo, hrp.Name";
        return DB.getKeyNamePairs(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<KeyNamePair> getEmployeeValid(MHRProcess mHRProcess) {
        ArrayList<KeyNamePair> arrayList;
        ArrayList<KeyNamePair> arrayList2 = new ArrayList<KeyNamePair>();
        if (mHRProcess == null) {
            return arrayList2;
        }
        KeyNamePair keyNamePair = new KeyNamePair(0, "");
        arrayList2.add(keyNamePair);
        String string = MRole.getDefault().addAccessSQL("SELECT DISTINCT bp.C_BPartner_ID,bp.Name FROM HR_Employee hrpe INNER JOIN C_BPartner bp ON(bp.C_BPartner_ID=hrpe.C_BPartner_ID)", "hrpe", true, false) + " AND hrpe.IsActive = 'Y' ";
        if (mHRProcess.getHR_Payroll_ID() != 0) {
            string = string + " AND (hrpe.HR_Payroll_ID =" + mHRProcess.getHR_Payroll_ID() + " OR hrpe.HR_Payroll_ID is NULL)";
            if (mHRProcess.getHR_Department_ID() > 0) {
                string = string + " AND (hrpe.HR_Department_ID =" + mHRProcess.getHR_Department_ID() + " OR hrpe.HR_Department_ID is NULL)";
            }
            if (mHRProcess.getHR_Employee_ID() > 0) {
                string = string + " AND (hrpe.HR_Employee_ID =" + mHRProcess.getHR_Employee_ID() + " OR hrpe.HR_Employee_ID is NULL)";
            }
        }
        string = string + " ORDER BY bp.Name ";
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            cPreparedStatement = DB.prepareStatement(string, null);
            resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                keyNamePair = new KeyNamePair(resultSet.getInt(1), resultSet.getString(2));
                arrayList2.add(keyNamePair);
            }
            arrayList = arrayList2;
        }
        catch (SQLException sQLException) {
            ArrayList<KeyNamePair> arrayList3;
            try {
                log.log(Level.SEVERE, string, sQLException);
                arrayList3 = arrayList2;
            }
            catch (Throwable throwable) {
                DB.close(resultSet, cPreparedStatement);
                resultSet = null;
                cPreparedStatement = null;
                throw throwable;
            }
            DB.close(resultSet, cPreparedStatement);
            resultSet = null;
            cPreparedStatement = null;
            return arrayList3;
        }
        DB.close(resultSet, cPreparedStatement);
        resultSet = null;
        cPreparedStatement = null;
        return arrayList;
    }

    public ArrayList<ValueNamePair> getConcept(MHRProcess mHRProcess, boolean bl) {
        if (mHRProcess == null) {
            return null;
        }
        ArrayList<ValueNamePair> arrayList = new ArrayList<ValueNamePair>();
        String string = "SELECT DISTINCT hrpc.HR_Concept_ID,hrpc.Name,hrpc.Value  FROM HR_Concept hrpc  INNER JOIN HR_Attribute hrpa ON (hrpa.HR_Concept_ID=hrpc.HR_Concept_ID) WHERE hrpc.AD_Client_ID = " + Env.getAD_Client_ID(Env.getCtx()) + " AND hrpc.IsActive = 'Y' AND hrpc.IsManual = 'Y' AND hrpc.Type != 'E'" + " AND (hrpa.HR_Payroll_ID = " + m_HR_Payroll_ID + " OR hrpa.HR_Payroll_ID IS NULL)";
        if (!bl) {
            if (mHRProcess.getHR_Payroll_ID() != 0) {
                string = string + " AND (hrpa.HR_Payroll_ID = " + mHRProcess.getHR_Payroll_ID() + " OR hrpa.HR_Payroll_ID is NULL)";
            }
            if (mHRProcess.getHR_Department_ID() != 0) {
                // empty if block
            }
            string = string + " AND (hrpa.HR_Department_ID = " + mHRProcess.getHR_Department_ID() + " OR hrpa.HR_Department_ID is NULL)";
            if (mHRProcess.getHR_Department_ID() != 0) {
                // empty if block
            }
            string = string + " AND (hrpa.HR_Employee_ID = " + mHRProcess.getHR_Employee_ID() + " OR hrpa.HR_Employee_ID is NULL)";
        }
        string = string + " ORDER BY hrpc.Name";
        try {
            CPreparedStatement cPreparedStatement = DB.prepareStatement(string, null);
            ResultSet resultSet = cPreparedStatement.executeQuery();
            ValueNamePair valueNamePair = null;
            arrayList.add(new ValueNamePair("", ""));
            while (resultSet.next()) {
                valueNamePair = new ValueNamePair(resultSet.getString(1), resultSet.getString(2));
                arrayList.add(valueNamePair);
            }
            resultSet.close();
            cPreparedStatement.close();
        }
        catch (SQLException sQLException) {
            log.log(Level.SEVERE, string, sQLException);
        }
        return arrayList;
    }

    public int seekMovement(Timestamp timestamp) {
        if (m_HR_Concept_ID <= 0) {
            return 0;
        }
        int n = 0;
        String string = DB.TO_DATE(timestamp);
        int n2 = m_HR_Process_ID;
        int n3 = m_C_BPartner_ID;
        int n4 = m_HR_Concept_ID;
        MHRConcept mHRConcept = MHRConcept.get(Env.getCtx(), n4);
        if (n2 + n3 + n4 > 0) {
            n = DB.getSQLValue(null, "SELECT HR_Movement_ID  FROM HR_Movement WHERE HR_Process_ID = " + n2 + " AND C_BPartner_ID =" + n3 + " AND HR_Concept_ID = " + n4 + " AND TRUNC(ValidFrom) = TRUNC(" + string + ")");
        }
        return n;
    }

    public static String getSQL_ColumnType(Properties properties, String string) {
        int n = MTable.get(properties, I_HR_Concept.Table_ID).getColumn("ColumnType").getAD_Reference_Value_ID();
        String string2 = Env.isBaseLanguage(Env.getCtx(), "AD_Ref_List") ? "SELECT zz.Name FROM AD_Ref_List zz WHERE zz.AD_Reference_ID=" + n : "SELECT zz.Name FROM AD_Ref_List zz, AD_Ref_List_Trl zzt WHERE zz.AD_Reference_ID=" + n + " AND zzt.AD_Ref_List_ID=zz.AD_Ref_List_ID" + " AND zzt.AD_Language=" + DB.TO_STRING(Env.getAD_Language(Env.getCtx()));
        string2 = string2 + " AND zz.Value = " + string;
        return string2;
    }
}

