/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wf;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttachment;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MConversionRate;
import org.compiere.model.MMailText;
import org.compiere.model.MNote;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MRefList;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.MUserRoles;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_WF_Activity;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.ProcessInfo;
import org.compiere.process.StateEngine;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trace;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.wf.MWFEventAudit;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodePara;
import org.compiere.wf.MWFProcess;
import org.compiere.wf.MWFResponsible;

public class MWFActivity
extends X_AD_WF_Activity
implements Runnable {
    private static final long serialVersionUID = -3282235931100223816L;
    private StateEngine m_state = null;
    private MWFNode m_node = null;
    private MWFEventAudit m_audit = null;
    private PO m_po = null;
    private String m_docStatus = null;
    private String m_newValue = null;
    private MWFProcess m_process = null;
    private ArrayList<String> m_emails = new ArrayList();

    public static MWFActivity[] get(Properties ctx, int AD_Table_ID, int Record_ID, boolean activeOnly) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer("AD_Table_ID=? AND Record_ID=?");
        params.add(AD_Table_ID);
        params.add(Record_ID);
        if (activeOnly) {
            whereClause.append(" AND Processed<>?");
            params.add(true);
        }
        List<MWFActivity> list = new Query(ctx, "AD_WF_Activity", whereClause.toString(), null).setParameters(params).setOrderBy("AD_WF_Activity_ID").list();
        MWFActivity[] retValue = new MWFActivity[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static String getActiveInfo(Properties ctx, int AD_Table_ID, int Record_ID) {
        MWFActivity[] acts = MWFActivity.get(ctx, AD_Table_ID, Record_ID, true);
        if (acts == null || acts.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < acts.length; ++i2) {
            if (i2 > 0) {
                sb.append("\n");
            }
            MWFActivity activity = acts[i2];
            sb.append(activity.toStringX());
        }
        return sb.toString();
    }

    public MWFActivity(Properties ctx, int AD_WF_Activity_ID, String trxName) {
        super(ctx, AD_WF_Activity_ID, trxName);
        if (AD_WF_Activity_ID == 0) {
            throw new IllegalArgumentException("Cannot create new WF Activity directly");
        }
        this.m_state = new StateEngine(this.getWFState());
    }

    public MWFActivity(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.m_state = new StateEngine(this.getWFState());
    }

    public MWFActivity(MWFProcess process, int AD_WF_Node_ID) {
        super(process.getCtx(), 0, process.get_TrxName());
        long limitMS;
        this.setAD_WF_Process_ID(process.getAD_WF_Process_ID());
        this.setPriority(process.getPriority());
        this.setAD_Table_ID(process.getAD_Table_ID());
        this.setRecord_ID(process.getRecord_ID());
        this.setAD_Client_ID(process.getAD_Client_ID());
        this.setAD_Org_ID(process.getAD_Org_ID());
        super.setWFState("ON");
        this.m_state = new StateEngine(this.getWFState());
        this.setProcessed(false);
        this.setAD_Workflow_ID(process.getAD_Workflow_ID());
        this.setAD_WF_Node_ID(AD_WF_Node_ID);
        MWFNode node = MWFNode.get(this.getCtx(), AD_WF_Node_ID);
        int priority = node.getPriority();
        if (priority != 0 && priority != this.getPriority()) {
            this.setPriority(priority);
        }
        if ((limitMS = node.getLimitMS()) != 0L) {
            this.setEndWaitTime(new Timestamp(limitMS + System.currentTimeMillis()));
        }
        this.setResponsible(process);
        this.save();
        this.m_audit = new MWFEventAudit(this);
        this.m_audit.save();
        this.m_process = process;
    }

    public MWFActivity(MWFProcess process, int next_ID, PO lastPO) {
        this(process, next_ID);
        if (lastPO != null && lastPO.get_Table_ID() == this.getAD_Table_ID() && lastPO.get_ID() == this.getRecord_ID()) {
            this.m_po = lastPO;
        }
    }

    public StateEngine getState() {
        return this.m_state;
    }

    @Override
    public void setWFState(String WFState) {
        if (this.m_state == null) {
            this.m_state = new StateEngine(this.getWFState());
        }
        if (this.m_state.isClosed()) {
            return;
        }
        if (this.getWFState().equals(WFState)) {
            return;
        }
        if (this.m_state.isValidNewState(WFState)) {
            String oldState = this.getWFState();
            this.log.fine(oldState + "->" + WFState + ", Msg=" + this.getTextMsg());
            super.setWFState(WFState);
            this.m_state = new StateEngine(this.getWFState());
            this.save();
            this.updateEventAudit();
            if (this.m_process == null) {
                this.m_process = new MWFProcess(this.getCtx(), this.getAD_WF_Process_ID(), this.get_TrxName());
            }
            this.m_process.checkActivities(this.get_TrxName(), this.m_po);
        } else {
            String msg = "Set WFState - Ignored Invalid Transformation - New=" + WFState + ", Current=" + this.getWFState();
            this.log.log(Level.SEVERE, msg);
            Trace.printStack();
            this.setTextMsg(msg);
            this.save();
        }
    }

    public boolean isClosed() {
        return this.m_state.isClosed();
    }

    private void updateEventAudit() {
        this.getEventAudit();
        this.m_audit.setTextMsg(this.getTextMsg());
        this.m_audit.setWFState(this.getWFState());
        if (this.m_newValue != null) {
            this.m_audit.setNewValue(this.m_newValue);
        }
        if (this.m_state.isClosed()) {
            this.m_audit.setEventType("PX");
            long ms = System.currentTimeMillis() - this.m_audit.getCreated().getTime();
            this.m_audit.setElapsedTimeMS(new BigDecimal(ms));
        } else {
            this.m_audit.setEventType("SC");
        }
        this.m_audit.save();
    }

    public MWFEventAudit getEventAudit() {
        if (this.m_audit != null) {
            return this.m_audit;
        }
        MWFEventAudit[] events = MWFEventAudit.get(this.getCtx(), this.getAD_WF_Process_ID(), this.getAD_WF_Node_ID(), this.get_TrxName());
        this.m_audit = events == null || events.length == 0 ? new MWFEventAudit(this) : events[events.length - 1];
        return this.m_audit;
    }

    public PO getPO(Trx trx) {
        if (this.m_po != null) {
            if (trx != null) {
                this.m_po.set_TrxName(trx.getTrxName());
            }
            return this.m_po;
        }
        MTable table2 = MTable.get(this.getCtx(), this.getAD_Table_ID());
        this.m_po = trx != null ? table2.getPO(this.getRecord_ID(), trx.getTrxName()) : table2.getPO(this.getRecord_ID(), null);
        return this.m_po;
    }

    public PO getPO() {
        return this.getPO(this.get_TrxName() != null ? Trx.get(this.get_TrxName(), false) : null);
    }

    public int getPO_AD_Client_ID() {
        if (this.m_po == null) {
            this.getPO(this.get_TrxName() != null ? Trx.get(this.get_TrxName(), false) : null);
        }
        if (this.m_po != null) {
            return this.m_po.getAD_Client_ID();
        }
        return 0;
    }

    public Object getAttributeValue() {
        MWFNode node = this.getNode();
        if (node == null) {
            return null;
        }
        int AD_Column_ID = node.getAD_Column_ID();
        if (AD_Column_ID == 0) {
            return null;
        }
        PO po = this.getPO();
        if (po.get_ID() == 0) {
            return null;
        }
        return po.get_ValueOfColumn(AD_Column_ID);
    }

    public boolean isSOTrx() {
        PO po = this.getPO();
        if (po.get_ID() == 0) {
            return true;
        }
        int index = po.get_ColumnIndex("IsSOTrx");
        if (index < 0) {
            return !po.get_TableName().startsWith("M_");
        }
        try {
            Boolean IsSOTrx = (Boolean)po.get_Value(index);
            return IsSOTrx;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
            return true;
        }
    }

    @Override
    public void setAD_WF_Node_ID(int AD_WF_Node_ID) {
        if (AD_WF_Node_ID == 0) {
            throw new IllegalArgumentException("Workflow Node is not defined");
        }
        super.setAD_WF_Node_ID(AD_WF_Node_ID);
        if (!"ON".equals(this.getWFState())) {
            super.setWFState("ON");
            this.m_state = new StateEngine(this.getWFState());
        }
        if (this.isProcessed()) {
            this.setProcessed(false);
        }
    }

    public MWFNode getNode() {
        if (this.m_node == null) {
            this.m_node = MWFNode.get(this.getCtx(), this.getAD_WF_Node_ID());
        }
        return this.m_node;
    }

    public String getNodeName() {
        return this.getNode().getName(true);
    }

    public String getNodeDescription() {
        return this.getNode().getDescription(true);
    }

    public String getNodeHelp() {
        return this.getNode().getHelp(true);
    }

    public boolean isUserApproval() {
        return this.getNode().isUserApproval();
    }

    public boolean isUserManual() {
        return this.getNode().isUserManual();
    }

    public boolean isUserChoice() {
        return this.getNode().isUserChoice();
    }

    @Override
    public void setTextMsg(String TextMsg) {
        if (TextMsg == null || TextMsg.length() == 0) {
            return;
        }
        String oldText = this.getTextMsg();
        if (oldText == null || oldText.length() == 0) {
            super.setTextMsg(Util.trimSize(TextMsg, 1000));
        } else if (TextMsg != null && TextMsg.length() > 0) {
            super.setTextMsg(Util.trimSize(oldText + "\n - " + TextMsg, 1000));
        }
    }

    public void addTextMsg(Object obj) {
        if (obj == null) {
            return;
        }
        StringBuffer TextMsg = new StringBuffer();
        if (obj instanceof Exception) {
            Exception ex = (Exception)obj;
            if (ex.getMessage() != null && ex.getMessage().trim().length() > 0) {
                TextMsg.append(ex.toString());
            } else if (ex instanceof NullPointerException) {
                TextMsg.append(ex.getClass().getName());
            }
            while (ex != null) {
                StackTraceElement[] st = ex.getStackTrace();
                for (int i2 = 0; i2 < st.length; ++i2) {
                    StackTraceElement ste = st[i2];
                    if (i2 != 0 && !ste.getClassName().startsWith("org.compiere") && !ste.getClassName().startsWith("org.adempiere")) continue;
                    TextMsg.append(" (").append(i2).append("): ").append(ste.toString()).append("\n");
                }
                if (ex.getCause() instanceof Exception) {
                    ex = (Exception)ex.getCause();
                    continue;
                }
                ex = null;
            }
        } else {
            TextMsg.append(obj.toString());
        }
        String oldText = this.getTextMsg();
        if (oldText == null || oldText.length() == 0) {
            super.setTextMsg(Util.trimSize(TextMsg.toString(), 1000));
        } else if (TextMsg != null && TextMsg.length() > 0) {
            super.setTextMsg(Util.trimSize(oldText + "\n - " + TextMsg.toString(), 1000));
        }
    }

    public String getWFStateText() {
        return MRefList.getListName(this.getCtx(), 305, this.getWFState());
    }

    private void setResponsible(MWFProcess process) {
        int AD_WF_Responsible_ID = this.getNode().getAD_WF_Responsible_ID();
        if (AD_WF_Responsible_ID == 0) {
            AD_WF_Responsible_ID = process.getAD_WF_Responsible_ID();
        }
        this.setAD_WF_Responsible_ID(AD_WF_Responsible_ID);
        MWFResponsible resp = this.getResponsible();
        int AD_User_ID = resp.getAD_User_ID();
        if (AD_User_ID == 0 && resp.isInvoker()) {
            AD_User_ID = process.getAD_User_ID();
        }
        this.setAD_User_ID(AD_User_ID);
    }

    public MWFResponsible getResponsible() {
        MWFResponsible resp = MWFResponsible.get(this.getCtx(), this.getAD_WF_Responsible_ID());
        return resp;
    }

    public boolean isInvoker() {
        return this.getResponsible().isInvoker();
    }

    public int getApprovalUser(int AD_User_ID, int C_Currency_ID, BigDecimal amount, int AD_Org_ID, boolean ownDocument) {
        if (amount == null || amount.signum() == 0) {
            return AD_User_ID;
        }
        MUser user = MUser.get(this.getCtx(), AD_User_ID);
        this.log.info("For User=" + user + ", Amt=" + amount + ", Own=" + ownDocument);
        MUser oldUser = null;
        while (user != null) {
            if (user.equals(oldUser)) {
                this.log.info("Loop - " + user.getName());
                return -1;
            }
            oldUser = user;
            this.log.fine("User=" + user.getName());
            MRole[] roles = user.getRoles(AD_Org_ID);
            for (int i2 = 0; i2 < roles.length; ++i2) {
                BigDecimal roleAmt;
                MRole role = roles[i2];
                if (ownDocument && !role.isCanApproveOwnDoc() || (roleAmt = role.getAmtApproval()) == null || roleAmt.signum() == 0 || C_Currency_ID != role.getC_Currency_ID() && role.getC_Currency_ID() != 0 && ((roleAmt = MConversionRate.convert(this.getCtx(), roleAmt, role.getC_Currency_ID(), C_Currency_ID, this.getAD_Client_ID(), AD_Org_ID)) == null || roleAmt.signum() == 0)) continue;
                boolean approved = amount.compareTo(roleAmt) <= 0;
                this.log.fine("Approved=" + approved + " - User=" + user.getName() + ", Role=" + role.getName() + ", ApprovalAmt=" + roleAmt);
                if (!approved) continue;
                return user.getAD_User_ID();
            }
            if (user.getSupervisor_ID() != 0) {
                user = MUser.get(this.getCtx(), user.getSupervisor_ID());
                this.log.fine("Supervisor: " + user.getName());
            } else {
                this.log.fine("No Supervisor");
                MOrg org = MOrg.get(this.getCtx(), AD_Org_ID);
                MOrgInfo orgInfo = org.getInfo();
                if (orgInfo.getSupervisor_ID() != 0) {
                    user = MUser.get(this.getCtx(), orgInfo.getSupervisor_ID());
                    this.log.fine("Org=" + org.getName() + ",Supervisor: " + user.getName());
                } else {
                    this.log.fine("No Org Supervisor");
                    if (orgInfo.getParent_Org_ID() != 0 && (orgInfo = (org = MOrg.get(this.getCtx(), orgInfo.getParent_Org_ID())).getInfo()).getSupervisor_ID() != 0) {
                        user = MUser.get(this.getCtx(), orgInfo.getSupervisor_ID());
                        this.log.fine("Parent Org Supervisor: " + user.getName());
                    }
                }
            }
            ownDocument = false;
        }
        this.log.fine("No user found");
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.info("Node=" + this.getNode());
        this.m_newValue = null;
        Trx trx = null;
        boolean localTrx = false;
        if (this.get_TrxName() == null) {
            this.set_TrxName(Trx.createTrxName("WFA"));
            localTrx = true;
        }
        trx = Trx.get(this.get_TrxName(), true);
        Savepoint savepoint = null;
        try {
            if (!localTrx) {
                savepoint = trx.setSavepoint(null);
            }
            if (!this.m_state.isValidAction("Start")) {
                this.setTextMsg("State=" + this.getWFState() + " - cannot start");
                this.addTextMsg(new Exception(""));
                this.setWFState("CT");
                return;
            }
            this.setWFState("OR");
            if (this.getNode().get_ID() == 0) {
                this.setTextMsg("Node not found - AD_WF_Node_ID=" + this.getAD_WF_Node_ID());
                this.setWFState("CA");
                return;
            }
            boolean done = this.performWork(Trx.get(this.get_TrxName(), false));
            if (localTrx) {
                try {
                    trx.commit(true);
                }
                catch (Exception e) {
                    if (this.m_docStatus != null) {
                        this.m_docStatus = "IN";
                    }
                    throw e;
                }
            }
            this.setWFState(done ? "CC" : "OS");
        }
        catch (Exception e) {
            String processMsg;
            this.log.log(Level.WARNING, "" + this.getNode(), e);
            if (localTrx) {
                trx.rollback();
            } else if (savepoint != null) {
                try {
                    trx.rollback(savepoint);
                }
                catch (SQLException e1) {
                    // empty catch block
                }
            }
            if (e.getCause() != null) {
                this.log.log(Level.WARNING, "Cause", e.getCause());
            }
            if ((processMsg = e.getLocalizedMessage()) == null || processMsg.length() == 0) {
                processMsg = e.getMessage();
            }
            this.setTextMsg(processMsg);
            this.addTextMsg(e);
            this.setWFState("CT");
            if (this.m_po != null && this.m_po instanceof DocAction && this.m_docStatus != null) {
                this.m_po.load(this.get_TrxName());
                DocAction doc = (DocAction)((Object)this.m_po);
                doc.setDocStatus(this.m_docStatus);
                this.m_po.save();
            }
        }
        finally {
            if (localTrx && trx != null) {
                trx.close();
            }
        }
    }

    private boolean performWork(Trx trx) throws Exception {
        String action;
        this.log.info(this.m_node + " [" + trx.getTrxName() + "]");
        this.m_docStatus = null;
        if (this.m_node.getPriority() != 0) {
            this.setPriority(this.m_node.getPriority());
        }
        if ("Z".equals(action = this.m_node.getAction())) {
            this.log.fine("Sleep:WaitTime=" + this.m_node.getWaitTime());
            if (this.m_node.getWaitingTime() == 0) {
                return true;
            }
            Calendar cal = Calendar.getInstance();
            cal.add(this.m_node.getDurationCalendarField(), this.m_node.getWaitTime());
            this.setEndWaitTime(new Timestamp(cal.getTimeInMillis()));
            return false;
        }
        if ("D".equals(action)) {
            this.log.fine("DocumentAction=" + this.m_node.getDocAction());
            this.getPO(trx);
            if (this.m_po == null) {
                throw new Exception("Persistent Object not found - AD_Table_ID=" + this.getAD_Table_ID() + ", Record_ID=" + this.getRecord_ID());
            }
            boolean success = false;
            String processMsg = null;
            DocAction doc = null;
            if (this.m_po instanceof DocAction) {
                doc = (DocAction)((Object)this.m_po);
                try {
                    success = doc.processIt(this.m_node.getDocAction());
                    this.setTextMsg(doc.getSummary());
                    processMsg = doc.getProcessMsg();
                    if ("PR".equals(this.m_node.getDocAction()) || "CO".equals(this.m_node.getDocAction()) || success) {
                        this.m_docStatus = doc.getDocStatus();
                    }
                }
                catch (Exception e) {
                    if (this.m_process != null) {
                        this.m_process.setProcessMsg(e.getLocalizedMessage());
                    }
                    throw e;
                }
                if (this.m_process != null) {
                    this.m_process.setProcessMsg(processMsg);
                }
            } else {
                throw new IllegalStateException("Persistent Object not DocAction - " + this.m_po.getClass().getName() + " - AD_Table_ID=" + this.getAD_Table_ID() + ", Record_ID=" + this.getRecord_ID());
            }
            if (!this.m_po.save()) {
                success = false;
                processMsg = "SaveError";
            }
            if (!success) {
                if (processMsg == null || processMsg.length() == 0) {
                    processMsg = "PerformWork Error - " + this.m_node.toStringX();
                    if (doc != null) {
                        processMsg = processMsg + " - DocStatus=" + doc.getDocStatus();
                    }
                }
                throw new Exception(processMsg);
            }
            return success;
        }
        if ("R".equals(action)) {
            this.log.fine("Report:AD_Process_ID=" + this.m_node.getAD_Process_ID());
            MProcess process = MProcess.get(this.getCtx(), this.m_node.getAD_Process_ID());
            process.set_TrxName(trx != null ? trx.getTrxName() : null);
            if (!process.isReport() || process.getAD_ReportView_ID() == 0) {
                throw new IllegalStateException("Not a Report AD_Process_ID=" + this.m_node.getAD_Process_ID());
            }
            ProcessInfo pi = new ProcessInfo(this.m_node.getName(true), this.m_node.getAD_Process_ID(), this.getAD_Table_ID(), this.getRecord_ID());
            pi.setAD_User_ID(this.getAD_User_ID());
            pi.setAD_Client_ID(this.getAD_Client_ID());
            MPInstance pInstance = new MPInstance(process, this.getRecord_ID());
            pInstance.set_TrxName(trx != null ? trx.getTrxName() : null);
            this.fillParameter(pInstance, trx);
            pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
            ReportEngine re = ReportEngine.get(this.getCtx(), pi);
            if (re == null) {
                throw new IllegalStateException("Cannot create Report AD_Process_ID=" + this.m_node.getAD_Process_ID());
            }
            File report = re.getPDF();
            int AD_Message_ID = 753;
            MNote note = new MNote(this.getCtx(), AD_Message_ID, this.getAD_User_ID(), trx.getTrxName());
            note.setTextMsg(this.m_node.getName(true));
            note.setDescription(this.m_node.getDescription(true));
            note.setRecord(this.getAD_Table_ID(), this.getRecord_ID());
            note.save();
            MAttachment attachment = new MAttachment(this.getCtx(), MNote.Table_ID, note.getAD_Note_ID(), this.get_TrxName());
            attachment.addEntry(report);
            attachment.setTextMsg(this.m_node.getName(true));
            attachment.save();
            return true;
        }
        if ("P".equals(action)) {
            this.log.fine("Process:AD_Process_ID=" + this.m_node.getAD_Process_ID());
            MProcess process = MProcess.get(this.getCtx(), this.m_node.getAD_Process_ID());
            MPInstance pInstance = new MPInstance(process, this.getRecord_ID());
            this.fillParameter(pInstance, trx);
            ProcessInfo pi = new ProcessInfo(this.m_node.getName(true), this.m_node.getAD_Process_ID(), this.getAD_Table_ID(), this.getRecord_ID());
            pi.setAD_User_ID(this.getAD_User_ID());
            pi.setAD_Client_ID(this.getAD_Client_ID());
            pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
            return process.processItWithoutTrxClose(pi, trx);
        }
        if ("M".equals(action)) {
            this.log.fine("EMail:EMailRecipient=" + this.m_node.getEMailRecipient());
            this.getPO(trx);
            if (this.m_po == null) {
                throw new Exception("Persistent Object not found - AD_Table_ID=" + this.getAD_Table_ID() + ", Record_ID=" + this.getRecord_ID());
            }
            if (this.m_po instanceof DocAction) {
                this.m_emails = new ArrayList();
                this.sendEMail();
                this.setTextMsg(this.m_emails.toString());
            } else {
                MClient client = MClient.get(this.getCtx(), this.getAD_Client_ID());
                MMailText mailtext = new MMailText(this.getCtx(), this.getNode().getR_MailText_ID(), null);
                String subject = this.getNode().getDescription() + ": " + mailtext.getMailHeader();
                String message = mailtext.getMailText(true) + "\n-----\n" + this.getNodeHelp();
                String to = this.getNode().getEMail();
                client.sendEMail(to, subject, message, null);
            }
            return true;
        }
        if ("V".equals(action)) {
            String value = this.m_node.getAttributeValue();
            this.log.fine("SetVariable:AD_Column_ID=" + this.m_node.getAD_Column_ID() + " to " + value);
            MColumn column = this.m_node.getColumn();
            int dt = column.getAD_Reference_ID();
            return this.setVariable(value, dt, null, trx);
        }
        if ("F".equals(action)) {
            this.log.warning("Workflow:AD_Workflow_ID=" + this.m_node.getAD_Workflow_ID());
            this.log.warning("Start WF Instance is not implemented yet");
        } else {
            if ("C".equals(action)) {
                this.log.fine("UserChoice:AD_Column_ID=" + this.m_node.getAD_Column_ID());
                if (this.m_node.isUserApproval() && this.getPO(trx) instanceof DocAction) {
                    DocAction doc = (DocAction)((Object)this.m_po);
                    boolean autoApproval = false;
                    if (this.isInvoker()) {
                        int startAD_User_ID = Env.getAD_User_ID(this.getCtx());
                        if (startAD_User_ID == 0) {
                            startAD_User_ID = doc.getDoc_User_ID();
                        }
                        int nextAD_User_ID = this.getApprovalUser(startAD_User_ID, doc.getC_Currency_ID(), doc.getApprovalAmt(), doc.getAD_Org_ID(), startAD_User_ID == doc.getDoc_User_ID());
                        boolean bl = autoApproval = startAD_User_ID == nextAD_User_ID;
                        if (!autoApproval) {
                            this.setAD_User_ID(nextAD_User_ID);
                        }
                    } else {
                        MWFResponsible resp = this.getResponsible();
                        if (resp.isHuman()) {
                            boolean bl = autoApproval = resp.getAD_User_ID() == Env.getAD_User_ID(this.getCtx());
                            if (!autoApproval && resp.getAD_User_ID() != 0) {
                                this.setAD_User_ID(resp.getAD_User_ID());
                            }
                        } else if (resp.isRole()) {
                            MUserRoles[] urs = MUserRoles.getOfRole(this.getCtx(), resp.getAD_Role_ID());
                            for (int i2 = 0; i2 < urs.length; ++i2) {
                                if (urs[i2].getAD_User_ID() != Env.getAD_User_ID(this.getCtx())) continue;
                                autoApproval = true;
                                break;
                            }
                        } else {
                            if (resp.isOrganization()) {
                                throw new AdempiereException("Support not implemented for " + resp);
                            }
                            throw new AdempiereException("@NotSupported@ " + resp);
                        }
                    }
                    if (autoApproval && doc.processIt("AP") && doc.save()) {
                        return true;
                    }
                }
                return false;
            }
            if ("X".equals(action)) {
                this.log.fine("Form:AD_Form_ID=" + this.m_node.getAD_Form_ID());
                return false;
            }
            if ("W".equals(action)) {
                this.log.fine("Window:AD_Window_ID=" + this.m_node.getAD_Window_ID());
                return false;
            }
        }
        throw new IllegalArgumentException("Invalid Action (Not Implemented) =" + action);
    }

    private boolean setVariable(String value, int displayType, String textMsg, Trx trx) throws Exception {
        this.m_newValue = null;
        this.getPO(trx);
        if (this.m_po == null) {
            throw new Exception("Persistent Object not found - AD_Table_ID=" + this.getAD_Table_ID() + ", Record_ID=" + this.getRecord_ID());
        }
        Object dbValue = null;
        if (value != null) {
            dbValue = displayType == 20 ? new Boolean("Y".equals(value)) : (DisplayType.isNumeric(displayType) ? new BigDecimal(value) : value);
        }
        this.m_po.set_ValueOfColumn(this.getNode().getAD_Column_ID(), dbValue);
        this.m_po.save();
        if (dbValue != null && !dbValue.equals(this.m_po.get_ValueOfColumn(this.getNode().getAD_Column_ID()))) {
            throw new Exception("Persistent Object not updated - AD_Table_ID=" + this.getAD_Table_ID() + ", Record_ID=" + this.getRecord_ID() + " - Should=" + value + ", Is=" + this.m_po.get_ValueOfColumn(this.m_node.getAD_Column_ID()));
        }
        String msg = this.getNode().getAttributeName() + "=" + value;
        if (textMsg != null && textMsg.length() > 0) {
            msg = msg + " - " + textMsg;
        }
        this.setTextMsg(msg);
        this.m_newValue = value;
        return true;
    }

    public boolean setUserChoice(int AD_User_ID, String value, int displayType, String textMsg) throws Exception {
        this.setWFState("OR");
        this.setAD_User_ID(AD_User_ID);
        Trx trx = this.get_TrxName() != null ? Trx.get(this.get_TrxName(), false) : null;
        boolean ok = this.setVariable(value, displayType, textMsg, trx);
        if (!ok) {
            return false;
        }
        String newState = "CC";
        if (this.getNode().isUserApproval() && this.getPO(trx) instanceof DocAction) {
            DocAction doc = (DocAction)((Object)this.m_po);
            try {
                if (!"Y".equals(value)) {
                    newState = "CA";
                    if (!doc.processIt("RJ")) {
                        this.setTextMsg("Cannot Reject - Document Status: " + doc.getDocStatus());
                    }
                } else if (this.isInvoker()) {
                    int nextAD_User_ID;
                    int startAD_User_ID = Env.getAD_User_ID(this.getCtx());
                    if (startAD_User_ID == 0) {
                        startAD_User_ID = doc.getDoc_User_ID();
                    }
                    if ((nextAD_User_ID = this.getApprovalUser(startAD_User_ID, doc.getC_Currency_ID(), doc.getApprovalAmt(), doc.getAD_Org_ID(), startAD_User_ID == doc.getDoc_User_ID())) <= 0) {
                        newState = "CA";
                        this.setTextMsg("Cannot Approve - No Approver");
                        doc.processIt("RJ");
                    } else if (startAD_User_ID != nextAD_User_ID) {
                        this.forwardTo(nextAD_User_ID, "Next Approver");
                        newState = "OS";
                    } else if (!doc.processIt("AP")) {
                        newState = "CA";
                        this.setTextMsg("Cannot Approve - Document Status: " + doc.getDocStatus());
                    }
                } else if (!doc.processIt("AP")) {
                    newState = "CA";
                    this.setTextMsg("Cannot Approve - Document Status: " + doc.getDocStatus());
                }
                doc.save();
            }
            catch (Exception e) {
                newState = "CT";
                this.setTextMsg("User Choice: " + e.toString());
                this.addTextMsg(e);
                this.log.log(Level.WARNING, "", e);
            }
            if (newState.equals("CA")) {
                MUser to = new MUser(this.getCtx(), doc.getDoc_User_ID(), null);
                if (to.isNotificationEMail()) {
                    MClient client = MClient.get(this.getCtx(), doc.getAD_Client_ID());
                    client.sendEMail(doc.getDoc_User_ID(), Msg.getMsg(this.getCtx(), "NotApproved") + ": " + doc.getDocumentNo(), (doc.getSummary() != null ? doc.getSummary() + "\n" : "") + (doc.getProcessMsg() != null ? doc.getProcessMsg() + "\n" : "") + (this.getTextMsg() != null ? this.getTextMsg() : ""), null);
                }
                if (to.isNotificationNote()) {
                    MNote note = new MNote(this.getCtx(), "NotApproved", doc.getDoc_User_ID(), null);
                    note.setTextMsg((doc.getSummary() != null ? doc.getSummary() + "\n" : "") + (doc.getProcessMsg() != null ? doc.getProcessMsg() + "\n" : "") + (this.getTextMsg() != null ? this.getTextMsg() : ""));
                    note.setRecord(this.m_po.get_Table_ID(), this.m_po.get_ID());
                    note.save();
                }
            }
        }
        this.setWFState(newState);
        return ok;
    }

    public boolean forwardTo(int AD_User_ID, String textMsg) {
        if (AD_User_ID == this.getAD_User_ID()) {
            this.log.log(Level.WARNING, "Same User - AD_User_ID=" + AD_User_ID);
            return false;
        }
        MUser oldUser = MUser.get(this.getCtx(), this.getAD_User_ID());
        MUser user = MUser.get(this.getCtx(), AD_User_ID);
        if (user == null || user.get_ID() == 0) {
            this.log.log(Level.WARNING, "Does not exist - AD_User_ID=" + AD_User_ID);
            return false;
        }
        this.setAD_User_ID(user.getAD_User_ID());
        this.setTextMsg(textMsg);
        this.save();
        this.getEventAudit();
        this.m_audit.setAD_User_ID(oldUser.getAD_User_ID());
        this.m_audit.setTextMsg(this.getTextMsg());
        this.m_audit.setAttributeName("AD_User_ID");
        this.m_audit.setOldValue(oldUser.getName() + "(" + oldUser.getAD_User_ID() + ")");
        this.m_audit.setNewValue(user.getName() + "(" + user.getAD_User_ID() + ")");
        this.m_audit.setWFState(this.getWFState());
        this.m_audit.setEventType("SC");
        long ms = System.currentTimeMillis() - this.m_audit.getCreated().getTime();
        this.m_audit.setElapsedTimeMS(new BigDecimal(ms));
        this.m_audit.save();
        this.m_audit = new MWFEventAudit(this);
        this.m_audit.save();
        return true;
    }

    public void setUserConfirmation(int AD_User_ID, String textMsg) {
        this.log.fine(textMsg);
        this.setWFState("OR");
        this.setAD_User_ID(AD_User_ID);
        if (textMsg != null) {
            this.setTextMsg(textMsg);
        }
        this.setWFState("CC");
    }

    private void fillParameter(MPInstance pInstance, Trx trx) {
        this.getPO(trx);
        MWFNodePara[] nParams = this.m_node.getParameters();
        MPInstancePara[] iParams = pInstance.getParameters();
        block2: for (int pi = 0; pi < iParams.length; ++pi) {
            MPInstancePara iPara = iParams[pi];
            for (int np = 0; np < nParams.length; ++np) {
                MWFNodePara nPara = nParams[np];
                if (!iPara.getParameterName().equals(nPara.getAttributeName())) continue;
                String variableName = nPara.getAttributeValue();
                this.log.fine(nPara.getAttributeName() + " = " + variableName);
                Object value = variableName;
                if (variableName == null || variableName != null && variableName.length() == 0) {
                    value = null;
                } else if (variableName.indexOf(64) != -1 && this.m_po != null) {
                    int index = variableName.indexOf(64);
                    String columnName = variableName.substring(index + 1);
                    if ((index = columnName.indexOf(64)) == -1) {
                        this.log.warning(nPara.getAttributeName() + " - cannot evaluate=" + variableName);
                        continue block2;
                    }
                    if ((index = this.m_po.get_ColumnIndex(columnName = columnName.substring(0, index))) != -1) {
                        value = this.m_po.get_Value(index);
                    } else {
                        String env = Env.getContext(this.getCtx(), columnName);
                        if (env.length() == 0) {
                            this.log.warning(nPara.getAttributeName() + " - not column nor environment =" + columnName + "(" + variableName + ")");
                            continue block2;
                        }
                        value = env;
                    }
                }
                if (value == null) {
                    if (nPara.isMandatory()) {
                        this.log.warning(nPara.getAttributeName() + " - empty - mandatory!");
                        continue block2;
                    }
                    this.log.fine(nPara.getAttributeName() + " - empty");
                    continue block2;
                }
                try {
                    if (DisplayType.isNumeric(nPara.getDisplayType()) || DisplayType.isID(nPara.getDisplayType())) {
                        BigDecimal bd = null;
                        bd = value instanceof BigDecimal ? (BigDecimal)value : (value instanceof Integer ? new BigDecimal((Integer)value) : new BigDecimal(value.toString()));
                        iPara.setP_Number(bd);
                        this.log.fine(nPara.getAttributeName() + " = " + variableName + " (=" + bd + "=)");
                    } else if (DisplayType.isDate(nPara.getDisplayType())) {
                        Timestamp ts = null;
                        ts = value instanceof Timestamp ? (Timestamp)value : Timestamp.valueOf(value.toString());
                        iPara.setP_Date(ts);
                        this.log.fine(nPara.getAttributeName() + " = " + variableName + " (=" + ts + "=)");
                    } else {
                        iPara.setP_String(value.toString());
                        this.log.fine(nPara.getAttributeName() + " = " + variableName + " (=" + value + "=) " + value.getClass().getName());
                    }
                    if (iPara.save()) continue block2;
                    this.log.warning("Not Saved - " + nPara.getAttributeName());
                }
                catch (Exception e) {
                    this.log.warning(nPara.getAttributeName() + " = " + variableName + " (" + value + ") " + value.getClass().getName() + " - " + e.getLocalizedMessage());
                }
                continue block2;
            }
        }
    }

    private void sendEMail() {
        DocAction doc = (DocAction)((Object)this.m_po);
        MMailText text = new MMailText(this.getCtx(), this.m_node.getR_MailText_ID(), null);
        text.setPO(this.m_po, true);
        String subject = doc.getDocumentInfo() + ": " + text.getMailHeader();
        String message = text.getMailText(true) + "\n-----\n" + doc.getDocumentInfo() + "\n" + doc.getSummary();
        File pdf = doc.createPDF();
        MClient client = MClient.get(doc.getCtx(), doc.getAD_Client_ID());
        this.sendEMail(client, 0, this.m_node.getEMail(), subject, message, pdf, text.isHtml());
        String recipient = this.m_node.getEMailRecipient();
        if (recipient == null || recipient.length() == 0) {
            this.sendEMail(client, doc.getDoc_User_ID(), null, subject, message, pdf, text.isHtml());
        } else if (recipient.equals("B")) {
            int index = this.m_po.get_ColumnIndex("AD_User_ID");
            if (index > 0) {
                Object oo = this.m_po.get_Value(index);
                if (oo instanceof Integer) {
                    int AD_User_ID = (Integer)oo;
                    if (AD_User_ID != 0) {
                        this.sendEMail(client, AD_User_ID, null, subject, message, pdf, text.isHtml());
                    } else {
                        this.log.fine("No User in Document");
                    }
                } else {
                    this.log.fine("Empty User in Document");
                }
            } else {
                this.log.fine("No User Field in Document");
            }
        } else if (recipient.equals("D")) {
            this.sendEMail(client, doc.getDoc_User_ID(), null, subject, message, pdf, text.isHtml());
        } else if (recipient.equals("R")) {
            MWFResponsible resp = this.getResponsible();
            if (resp.isInvoker()) {
                this.sendEMail(client, doc.getDoc_User_ID(), null, subject, message, pdf, text.isHtml());
            } else if (resp.isHuman()) {
                this.sendEMail(client, resp.getAD_User_ID(), null, subject, message, pdf, text.isHtml());
            } else if (resp.isRole()) {
                MRole role = resp.getRole();
                if (role != null) {
                    MUser[] users = MUser.getWithRole(role);
                    for (int i2 = 0; i2 < users.length; ++i2) {
                        this.sendEMail(client, users[i2].getAD_User_ID(), null, subject, message, pdf, text.isHtml());
                    }
                }
            } else if (resp.isOrganization()) {
                MOrgInfo org = MOrgInfo.get(this.getCtx(), this.m_po.getAD_Org_ID(), this.get_TrxName());
                if (org.getSupervisor_ID() == 0) {
                    this.log.fine("No Supervisor for AD_Org_ID=" + this.m_po.getAD_Org_ID());
                } else {
                    this.sendEMail(client, org.getSupervisor_ID(), null, subject, message, pdf, text.isHtml());
                }
            }
        }
    }

    private void sendEMail(MClient client, int AD_User_ID, String email, String subject, String message, File pdf, boolean isHtml) {
        if (AD_User_ID != 0) {
            MUser user = MUser.get(this.getCtx(), AD_User_ID);
            email = user.getEMail();
            if (email != null && email.length() > 0) {
                if (!this.m_emails.contains(email = email.trim())) {
                    client.sendEMail(null, user, subject, message, pdf, isHtml);
                    this.m_emails.add(email);
                }
            } else {
                this.log.info("No EMail for User " + user.getName());
            }
        } else if (email != null && email.length() > 0) {
            if (email.indexOf(59) == -1) {
                if (!this.m_emails.contains(email = email.trim())) {
                    client.sendEMail(email, subject, message, pdf, isHtml);
                    this.m_emails.add(email);
                }
                return;
            }
            StringTokenizer st = new StringTokenizer(email, ";");
            while (st.hasMoreTokens()) {
                String email1 = st.nextToken().trim();
                if (email1.length() == 0 || this.m_emails.contains(email1)) continue;
                client.sendEMail(email1, subject, message, pdf, isHtml);
                this.m_emails.add(email1);
            }
        }
    }

    public String getHistoryHTML() {
        SimpleDateFormat format = DisplayType.getDateFormat(16);
        StringBuffer sb = new StringBuffer();
        MWFEventAudit[] events = MWFEventAudit.get(this.getCtx(), this.getAD_WF_Process_ID(), this.get_TrxName());
        for (int i2 = 0; i2 < events.length; ++i2) {
            MWFEventAudit audit = events[i2];
            sb.append("<p>");
            sb.append(format.format(audit.getCreated())).append(" ").append(this.getHTMLpart("b", audit.getNodeName())).append(": ").append(this.getHTMLpart(null, audit.getDescription())).append(this.getHTMLpart("i", audit.getTextMsg()));
            sb.append("</p>");
        }
        return sb.toString();
    }

    private StringBuffer getHTMLpart(String tag, String content) {
        StringBuffer sb = new StringBuffer();
        if (content == null || content.length() == 0) {
            return sb;
        }
        if (tag != null && tag.length() > 0) {
            sb.append("<").append(tag).append(">");
        }
        sb.append(content);
        if (tag != null && tag.length() > 0) {
            sb.append("</").append(tag).append(">");
        }
        return sb;
    }

    @Override
    public boolean isPdfAttachment() {
        if (this.getPO() == null) {
            return false;
        }
        return this.m_po.isPdfAttachment();
    }

    @Override
    public byte[] getPdfAttachment() {
        if (this.getPO() == null) {
            return null;
        }
        return this.m_po.getPdfAttachment();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MWFActivity[");
        sb.append(this.get_ID()).append(",Node=");
        if (this.m_node == null) {
            sb.append(this.getAD_WF_Node_ID());
        } else {
            sb.append(this.m_node.getName());
        }
        sb.append(",State=").append(this.getWFState()).append(",AD_User_ID=").append(this.getAD_User_ID()).append(",").append(this.getCreated()).append("]");
        return sb.toString();
    }

    public String toStringX() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getWFStateText()).append(": ").append(this.getNode().getName());
        if (this.getAD_User_ID() > 0) {
            MUser user = MUser.get(this.getCtx(), this.getAD_User_ID());
            sb.append(" (").append(user.getName()).append(")");
        }
        return sb.toString();
    }

    public String getSummary() {
        MBPartner partner;
        Integer bp;
        MUser user;
        int index;
        PO po = this.getPO();
        if (po == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        String[] keyColumns = po.get_KeyColumns();
        if (keyColumns != null && keyColumns.length > 0) {
            sb.append(Msg.getElement(this.getCtx(), keyColumns[0])).append(" ");
        }
        if ((index = po.get_ColumnIndex("DocumentNo")) != -1) {
            sb.append(po.get_Value(index)).append(": ");
        }
        index = po.get_ColumnIndex("SalesRep_ID");
        Integer sr = null;
        if (index != -1) {
            sr = (Integer)po.get_Value(index);
        } else {
            index = po.get_ColumnIndex("AD_User_ID");
            if (index != -1) {
                sr = (Integer)po.get_Value(index);
            }
        }
        if (sr != null && (user = MUser.get(this.getCtx(), sr)) != null) {
            sb.append(user.getName()).append(" ");
        }
        if ((index = po.get_ColumnIndex("C_BPartner_ID")) != -1 && (bp = (Integer)po.get_Value(index)) != null && (partner = MBPartner.get(this.getCtx(), bp)) != null) {
            sb.append(partner.getName()).append(" ");
        }
        return sb.toString();
    }
}

