/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.InvalidClassException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.adempiere.util.ProcessUtil;
import org.compiere.db.CConnection;
import org.compiere.interfaces.Server;
import org.compiere.model.MPInstance;
import org.compiere.print.ServerReportCtl;
import org.compiere.process.ClientProcess;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.wf.MWFProcess;

public class ServerProcessCtl
implements Runnable {
    private static CLogger log = CLogger.getCLogger(ServerProcessCtl.class);
    ASyncProcess m_parent;
    ProcessInfo m_pi;
    private Trx m_trx;
    private boolean m_IsServerProcess = false;

    public ServerProcessCtl(ASyncProcess parent, ProcessInfo pi, Trx trx) {
        this.m_parent = parent;
        this.m_pi = pi;
        this.m_trx = trx;
    }

    public static ServerProcessCtl process(ASyncProcess parent, ProcessInfo pi, Trx trx) {
        log.fine("ServerProcess - " + pi);
        MPInstance instance = null;
        try {
            instance = new MPInstance(Env.getCtx(), pi.getAD_Process_ID(), pi.getRecord_ID());
        }
        catch (Exception e) {
            pi.setSummary(e.getLocalizedMessage());
            pi.setError(true);
            log.warning(pi.toString());
            return null;
        }
        catch (Error e) {
            pi.setSummary(e.getLocalizedMessage());
            pi.setError(true);
            log.warning(pi.toString());
            return null;
        }
        if (!instance.save()) {
            pi.setSummary(Msg.getMsg(Env.getCtx(), "ProcessNoInstance"));
            pi.setError(true);
            return null;
        }
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        ServerProcessCtl worker = new ServerProcessCtl(parent, pi, trx);
        if (parent != null) {
            worker.start();
        } else {
            worker.run();
        }
        return worker;
    }

    public void start() {
        Thread thread = new Thread(this);
        if (this.m_pi != null) {
            thread.setName(this.m_pi.getTitle() + "-" + this.m_pi.getAD_PInstance_ID());
        }
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ResultSet rs;
        CPreparedStatement pstmt;
        boolean IsReport;
        int AD_Workflow_ID;
        int AD_ReportView_ID;
        String JasperReport;
        String ProcedureName;
        block23: {
            log.fine("AD_PInstance_ID=" + this.m_pi.getAD_PInstance_ID() + ", Record_ID=" + this.m_pi.getRecord_ID());
            ProcedureName = "";
            JasperReport = "";
            AD_ReportView_ID = 0;
            AD_Workflow_ID = 0;
            IsReport = false;
            boolean isPrintPreview = this.m_pi.isPrintPreview();
            String sql = "SELECT p.Name, p.ProcedureName,p.ClassName, p.AD_Process_ID, p.isReport,p.IsDirectPrint,p.AD_ReportView_ID,p.AD_Workflow_ID, CASE WHEN COALESCE(p.Statistic_Count,0)=0 THEN 0 ELSE p.Statistic_Seconds/p.Statistic_Count END CASE, p.IsServerProcess, p.JasperReport FROM AD_Process p INNER JOIN AD_PInstance i ON (p.AD_Process_ID=i.AD_Process_ID) WHERE p.IsActive='Y' AND i.AD_PInstance_ID=?";
            if (!Env.isBaseLanguage(Env.getCtx(), "AD_Process")) {
                sql = "SELECT t.Name, p.ProcedureName,p.ClassName, p.AD_Process_ID, p.isReport, p.IsDirectPrint,p.AD_ReportView_ID,p.AD_Workflow_ID, CASE WHEN COALESCE(p.Statistic_Count,0)=0 THEN 0 ELSE p.Statistic_Seconds/p.Statistic_Count END CASE, p.IsServerProcess, p.JasperReport FROM AD_Process p INNER JOIN AD_PInstance i ON (p.AD_Process_ID=i.AD_Process_ID)  INNER JOIN AD_Process_Trl t ON (p.AD_Process_ID=t.AD_Process_ID AND t.AD_Language='" + Env.getAD_Language(Env.getCtx()) + "') " + "WHERE p.IsActive='Y'" + " AND i.AD_PInstance_ID=?";
            }
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, 1003, 1007, null);
                pstmt.setInt(1, this.m_pi.getAD_PInstance_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.m_pi.setTitle(rs.getString(1));
                    ProcedureName = rs.getString(2);
                    this.m_pi.setClassName(rs.getString(3));
                    this.m_pi.setAD_Process_ID(rs.getInt(4));
                    if ("Y".equals(rs.getString(5))) {
                        IsReport = true;
                    }
                    AD_ReportView_ID = rs.getInt(7);
                    AD_Workflow_ID = rs.getInt(8);
                    int estimate = rs.getInt(9);
                    if (estimate != 0) {
                        this.m_pi.setEstSeconds(estimate + 1);
                    }
                    this.m_IsServerProcess = "Y".equals(rs.getString(10));
                    JasperReport = rs.getString(11);
                    break block23;
                }
                log.log(Level.SEVERE, "No AD_PInstance_ID=" + this.m_pi.getAD_PInstance_ID());
            }
            catch (Throwable e) {
                try {
                    this.m_pi.setSummary(Msg.getMsg(Env.getCtx(), "ProcessNoProcedure") + " " + e.getLocalizedMessage(), true);
                    log.log(Level.SEVERE, "run", e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (ProcedureName == null) {
            ProcedureName = "";
        }
        if (AD_Workflow_ID > 0) {
            this.startWorkflow(AD_Workflow_ID);
            return;
        }
        boolean isJasper = false;
        if (JasperReport != null && JasperReport.trim().length() > 0) {
            isJasper = true;
            if ("org.compiere.report.ReportStarter".equals(this.m_pi.getClassName())) {
                this.m_pi.setClassName(null);
            }
        }
        if (this.m_pi.getClassName() != null) {
            if (isJasper) {
                this.m_pi.setReportingProcess(true);
            }
            if (!this.startProcess()) {
                return;
            }
            if (!IsReport && ProcedureName.length() == 0) {
                return;
            }
            if (IsReport && AD_ReportView_ID == 0 && !isJasper) {
                return;
            }
        }
        if (IsReport && ProcedureName.length() > 0) {
            this.m_pi.setReportingProcess(true);
            if (!this.startDBProcess(ProcedureName)) {
                return;
            }
        }
        if (isJasper) {
            this.m_pi.setReportingProcess(true);
            this.m_pi.setClassName("org.compiere.report.ReportStarter");
            this.startProcess();
            return;
        }
        if (IsReport) {
            this.m_pi.setReportingProcess(true);
            boolean ok = ServerReportCtl.start(this.m_parent, this.m_pi);
            this.m_pi.setSummary("Report", !ok);
        } else {
            if (!this.startDBProcess(ProcedureName)) {
                return;
            }
            ProcessInfoUtil.setSummaryFromDB(this.m_pi);
        }
    }

    protected boolean startWorkflow(int AD_Workflow_ID) {
        log.fine(AD_Workflow_ID + " - " + this.m_pi);
        boolean started = false;
        if (this.m_IsServerProcess) {
            Server server = CConnection.get().getServer();
            try {
                if (server != null) {
                    this.m_pi = server.workflow(Env.getRemoteCallCtx(Env.getCtx()), this.m_pi, AD_Workflow_ID);
                    log.finest("server => " + this.m_pi);
                    started = true;
                }
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "AppsServer error", ex);
                started = false;
            }
        }
        if (!started && !this.m_IsServerProcess) {
            MWFProcess wfProcess;
            if (this.m_trx != null) {
                this.m_pi.setTransactionName(this.m_trx.getTrxName());
            }
            started = (wfProcess = ProcessUtil.startWorkFlow(Env.getCtx(), this.m_pi, AD_Workflow_ID)) != null;
        }
        return started;
    }

    protected boolean startProcess() {
        log.fine(this.m_pi.toString());
        boolean started = false;
        boolean clientOnly = false;
        if (!this.m_pi.getClassName().toLowerCase().startsWith("@script:")) {
            try {
                Class<?> processClass = Class.forName(this.m_pi.getClassName());
                if (ClientProcess.class.isAssignableFrom(processClass)) {
                    clientOnly = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.m_IsServerProcess && !clientOnly) {
            Server server = CConnection.get().getServer();
            try {
                if (server != null) {
                    this.m_pi = server.process(Env.getRemoteCallCtx(Env.getCtx()), this.m_pi);
                    log.finest("server => " + this.m_pi);
                    started = true;
                }
            }
            catch (UndeclaredThrowableException ex) {
                Throwable cause = ex.getCause();
                if (cause != null) {
                    if (cause instanceof InvalidClassException) {
                        log.log(Level.SEVERE, "Version Server <> Client: " + cause.toString() + " - " + this.m_pi, ex);
                    } else {
                        log.log(Level.SEVERE, "AppsServer error(1b): " + cause.toString() + " - " + this.m_pi, ex);
                    }
                } else {
                    log.log(Level.SEVERE, " AppsServer error(1) - " + this.m_pi, ex);
                }
                started = false;
            }
            catch (Exception ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                log.log(Level.SEVERE, "AppsServer error - " + this.m_pi, cause);
                started = false;
            }
        }
        if (!(started || this.m_IsServerProcess && !clientOnly)) {
            if (this.m_pi.getClassName().toLowerCase().startsWith("@script:")) {
                return ProcessUtil.startScriptProcess(Env.getCtx(), this.m_pi, this.m_trx);
            }
            return ProcessUtil.startJavaProcess(Env.getCtx(), this.m_pi, this.m_trx);
        }
        return !this.m_pi.isError();
    }

    protected boolean startDBProcess(String ProcedureName) {
        String trxName;
        log.fine(ProcedureName + "(" + this.m_pi.getAD_PInstance_ID() + ")");
        boolean started = false;
        String string = trxName = this.m_trx != null ? this.m_trx.getTrxName() : null;
        if (this.m_IsServerProcess) {
            Server server = CConnection.get().getServer();
            try {
                if (server != null) {
                    this.m_pi = server.dbProcess(this.m_pi, ProcedureName);
                    log.finest("server => " + this.m_pi);
                    started = true;
                }
            }
            catch (UndeclaredThrowableException ex) {
                Throwable cause = ex.getCause();
                if (cause != null) {
                    if (cause instanceof InvalidClassException) {
                        log.log(Level.SEVERE, "Version Server <> Client: " + cause.toString() + " - " + this.m_pi, ex);
                    } else {
                        log.log(Level.SEVERE, "AppsServer error(1b): " + cause.toString() + " - " + this.m_pi, ex);
                    }
                } else {
                    log.log(Level.SEVERE, " AppsServer error(1) - " + this.m_pi, ex);
                    cause = ex;
                }
                this.m_pi.setSummary(Msg.getMsg(Env.getCtx(), "ProcessRunError") + " " + cause.getLocalizedMessage());
                this.m_pi.setError(true);
                return false;
            }
            catch (Exception ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                log.log(Level.SEVERE, "AppsServer error - " + this.m_pi, cause);
                this.m_pi.setSummary(Msg.getMsg(Env.getCtx(), "ProcessRunError") + " " + cause.getLocalizedMessage());
                this.m_pi.setError(true);
                return false;
            }
        }
        if (!started) {
            return ProcessUtil.startDatabaseProcedure(this.m_pi, ProcedureName, this.m_trx);
        }
        return true;
    }
}

