/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.compiere.apps.ADialog;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MWarehousePrice;
import org.compiere.model.PO;
import org.compiere.model.X_C_OrderLine;
import org.compiere.pos.PosBasePanel;
import org.compiere.pos.PosOrderModel;
import org.compiere.pos.PosSubPanel;
import org.compiere.pos.PosTable;
import org.compiere.pos.PosTextField;
import org.compiere.pos.QueryProduct;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CScrollPane;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class SubCurrentLine
extends PosSubPanel
implements ActionListener,
FocusListener,
ListSelectionListener {
    private static final long serialVersionUID = -4023538043556457231L;
    private CButton f_up;
    private CButton f_delete;
    private CButton f_down;
    private CButton f_plus;
    private CButton f_minus;
    private PosTextField f_price;
    private PosTextField f_quantity;
    protected PosTextField f_name;
    private CButton f_bSearch;
    private int orderLineId = 0;
    private MProduct m_product = null;
    private int m_M_Warehouse_ID;
    private int m_M_PriceList_Version_ID;
    private static CLogger log = CLogger.getCLogger(SubCurrentLine.class);
    PosTable m_table;
    private String m_sql;
    private static ColumnInfo[] s_layout = new ColumnInfo[]{new ColumnInfo(" ", "C_OrderLine_ID", IDColumn.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Name"), "Name", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Qty"), "QtyOrdered", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "C_UOM_ID"), "UOMSymbol", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "PriceActual"), "PriceActual", BigDecimal.class), new ColumnInfo(Msg.translate(Env.getCtx(), "LineNetAmt"), "LineNetAmt", BigDecimal.class), new ColumnInfo(Msg.translate(Env.getCtx(), "C_Tax_ID"), "TaxIndicator", String.class)};
    private static String s_sqlFrom = "C_Order_LineTax_v";
    private static String s_sqlWhere = "C_Order_ID=? AND LineNetAmt <> 0";

    public SubCurrentLine(PosBasePanel posPanel) {
        super(posPanel);
    }

    @Override
    public void init() {
        this.setLayout((LayoutManager)new MigLayout("fill, ins 0 0"));
        String buttonSize = "w 50!, h 50!,";
        this.f_bSearch = this.createButtonAction("Product", KeyStroke.getKeyStroke(73, 2));
        this.add((Component)this.f_bSearch, buttonSize);
        CLabel productLabel = new CLabel(Msg.translate(Env.getCtx(), "M_Product_ID"));
        this.add((Component)productLabel, "split 2, spanx 4, flowy, h 15");
        this.f_name = new PosTextField(Msg.translate(Env.getCtx(), "M_Product_ID"), this.p_posPanel, this.p_pos.getOSK_KeyLayout_ID());
        this.f_name.setName("Name");
        this.f_name.addActionListener(this);
        this.f_name.addFocusListener(this);
        this.f_name.requestFocusInWindow();
        this.add((Component)this.f_name, " growx, h 30:30:, wrap");
        this.m_table = new PosTable();
        CScrollPane scroll = new CScrollPane(this.m_table);
        this.m_sql = this.m_table.prepareTable(s_layout, s_sqlFrom, s_sqlWhere, false, "C_Order_LineTax_v") + " ORDER BY Line";
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.m_table.setColumnVisibility(this.m_table.getColumn(0), false);
        this.m_table.getColumn(1).setPreferredWidth(175);
        this.m_table.getColumn(2).setPreferredWidth(75);
        this.m_table.getColumn(3).setPreferredWidth(30);
        this.m_table.getColumn(4).setPreferredWidth(75);
        this.m_table.getColumn(5).setPreferredWidth(75);
        this.m_table.getColumn(6).setPreferredWidth(30);
        this.m_table.setFocusable(false);
        this.m_table.setFillsViewportHeight(true);
        this.m_table.growScrollbars();
        this.add((Component)scroll, "growx, spanx, growy, pushy, h 200:300:");
        this.f_up = this.createButtonAction("Previous", KeyStroke.getKeyStroke(38, 0));
        this.add((Component)this.f_up, buttonSize);
        this.f_down = this.createButtonAction("Next", KeyStroke.getKeyStroke(40, 0));
        this.add((Component)this.f_down, buttonSize);
        this.f_delete = this.createButtonAction("Cancel", KeyStroke.getKeyStroke(127, 1));
        this.add((Component)this.f_delete, buttonSize);
        this.f_minus = this.createButtonAction("Minus", null);
        this.add((Component)this.f_minus, buttonSize);
        CLabel qtyLabel = new CLabel(Msg.translate(Env.getCtx(), "QtyOrdered"));
        this.add((Component)qtyLabel, "split 2, flowy, h 15");
        this.f_quantity = new PosTextField(Msg.translate(Env.getCtx(), "QtyOrdered"), this.p_posPanel, this.p_pos.getOSNP_KeyLayout_ID(), DisplayType.getNumberFormat(29));
        this.f_quantity.setHorizontalAlignment(11);
        this.f_quantity.addActionListener(this);
        this.add((Component)this.f_quantity, "h 30:30:, w 100");
        this.setQty(Env.ONE);
        this.f_plus = this.createButtonAction("Plus", null);
        this.add((Component)this.f_plus, buttonSize);
        CLabel priceLabel = new CLabel(Msg.translate(Env.getCtx(), "PriceActual"));
        this.add((Component)priceLabel, "split 2, flowy, h 15");
        this.f_price = new PosTextField(Msg.translate(Env.getCtx(), "PriceActual"), this.p_posPanel, this.p_pos.getOSNP_KeyLayout_ID(), DisplayType.getNumberFormat(12));
        this.f_price.addActionListener(this);
        this.f_price.setHorizontalAlignment(11);
        this.add((Component)this.f_price, "h 30, w 100, wrap");
        this.setPrice(Env.ZERO);
        this.enableButtons();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int rows;
        int row;
        MOrderLine line;
        String action = e.getActionCommand();
        if (action == null || action.length() == 0) {
            return;
        }
        log.info("SubCurrentLine - actionPerformed: " + action);
        if (action.equals("Plus")) {
            if (this.orderLineId > 0 && (line = new MOrderLine(this.p_ctx, this.orderLineId, null)) != null) {
                line.setQty(line.getQtyOrdered().add(Env.ONE));
                line.saveEx();
                this.p_posPanel.updateInfo();
            }
        } else if (action.equals("Minus")) {
            if (this.orderLineId > 0 && (line = new MOrderLine(this.p_ctx, this.orderLineId, null)) != null) {
                line.setQty(line.getQtyOrdered().subtract(Env.ONE));
                line.saveEx();
                this.p_posPanel.updateInfo();
            }
        } else if (e.getSource() == this.f_price) {
            line = new MOrderLine(this.p_ctx, this.orderLineId, null);
            if (line != null) {
                line.setQty(new BigDecimal(this.f_price.getValue().toString()));
                line.saveEx();
                this.p_posPanel.updateInfo();
            }
        } else if (e.getSource() == this.f_quantity && this.orderLineId > 0 && (line = new MOrderLine(this.p_ctx, this.orderLineId, null)) != null) {
            line.setQty(new BigDecimal(this.f_quantity.getValue().toString()));
            line.saveEx();
            this.p_posPanel.updateInfo();
        }
        if (action.equals("Product")) {
            this.setParameter();
            QueryProduct qt = new QueryProduct(this.p_posPanel);
            qt.setQueryData(this.m_M_PriceList_Version_ID, this.m_M_Warehouse_ID);
            qt.setVisible(true);
            this.findProduct();
            row = this.m_table.getSelectedRow();
            if (row < 0) {
                row = 0;
            }
            this.m_table.getSelectionModel().setSelectionInterval(row, row);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(row, 1, true));
        } else if (e.getSource() == this.f_name) {
            this.findProduct();
        }
        if ("Previous".equalsIgnoreCase(e.getActionCommand())) {
            int rows2 = this.m_table.getRowCount();
            if (rows2 == 0) {
                return;
            }
            row = this.m_table.getSelectedRow();
            if (--row < 0) {
                row = 0;
            }
            this.m_table.getSelectionModel().setSelectionInterval(row, row);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(row, 1, true));
            return;
        }
        if ("Next".equalsIgnoreCase(e.getActionCommand())) {
            int rows3 = this.m_table.getRowCount();
            if (rows3 == 0) {
                return;
            }
            row = this.m_table.getSelectedRow();
            if (++row >= rows3) {
                row = rows3 - 1;
            }
            this.m_table.getSelectionModel().setSelectionInterval(row, row);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(row, 1, true));
            return;
        }
        if (action.equals("Cancel") && (rows = this.m_table.getRowCount()) != 0 && (row = this.m_table.getSelectedRow()) != -1) {
            if (this.p_posPanel.m_order != null) {
                this.p_posPanel.m_order.deleteLine(this.m_table.getSelectedRowKey());
            }
            this.setQty(null);
            this.setPrice(null);
            this.orderLineId = 0;
        }
        this.p_posPanel.updateInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTable(PosOrderModel order) {
        int C_Order_ID = 0;
        if (order != null) {
            C_Order_ID = order.getC_Order_ID();
        }
        if (C_Order_ID == 0) {
            this.p_posPanel.f_curLine.m_table.loadTable(new PO[0]);
            this.p_posPanel.f_order.setSums(null);
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(this.m_sql, null);
            pstmt.setInt(1, C_Order_ID);
            rs = pstmt.executeQuery();
            this.m_table.loadTable(rs);
        }
        catch (Exception e) {
            try {
                log.log(Level.SEVERE, this.m_sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        for (int i2 = 0; i2 < this.m_table.getRowCount(); ++i2) {
            IDColumn key = (IDColumn)this.m_table.getModel().getValueAt(i2, 0);
            if (key == null || this.orderLineId <= 0 || key.getRecord_ID() != this.orderLineId) continue;
            this.m_table.getSelectionModel().setSelectionInterval(i2, i2);
            break;
        }
        this.enableButtons();
        this.p_posPanel.f_order.setSums(order);
    }

    private void enableButtons() {
        boolean enabled = true;
        if (this.m_table == null || this.m_table.getRowCount() == 0 || this.m_table.getSelectedRowKey() == null) {
            enabled = false;
        }
        this.f_down.setEnabled(enabled);
        this.f_up.setEnabled(enabled);
        this.f_delete.setEnabled(enabled);
        this.f_minus.setEnabled(enabled);
        this.f_plus.setEnabled(enabled);
        this.f_quantity.setEnabled(enabled);
        this.f_price.setEnabled(enabled);
    }

    private void setParameter() {
        this.m_M_Warehouse_ID = this.p_pos.getM_Warehouse_ID();
        this.m_M_PriceList_Version_ID = this.p_posPanel.f_order.getM_PriceList_Version_ID();
    }

    public void setPrice(BigDecimal price) {
        if (price == null) {
            price = Env.ZERO;
        }
        this.f_price.setValue(price);
        boolean rw = Env.ZERO.compareTo(price) == 0 || this.p_pos.isModifyPrice();
        this.f_price.setEditable(rw);
    }

    public BigDecimal getPrice() {
        return (BigDecimal)this.f_price.getValue();
    }

    public void setQty(BigDecimal qty) {
        this.f_quantity.setValue(qty);
    }

    public BigDecimal getQty() {
        return (BigDecimal)this.f_quantity.getValue();
    }

    public void newLine() {
        this.setM_Product_ID(0);
        this.setQty(Env.ONE);
        this.setPrice(Env.ZERO);
        this.orderLineId = 0;
        this.f_name.requestFocusInWindow();
    }

    public boolean saveLine() {
        MProduct product = this.getProduct();
        if (product == null) {
            return false;
        }
        BigDecimal QtyOrdered = (BigDecimal)this.f_quantity.getValue();
        BigDecimal PriceActual = (BigDecimal)this.f_price.getValue();
        if (this.p_posPanel.m_order == null) {
            this.p_posPanel.m_order = PosOrderModel.createOrder(this.p_posPanel.p_pos, this.p_posPanel.f_order.getBPartner());
        }
        X_C_OrderLine line = null;
        if (this.p_posPanel.m_order != null) {
            line = this.p_posPanel.m_order.createLine(product, QtyOrdered, PriceActual);
            if (line == null) {
                return false;
            }
            if (!line.save()) {
                return false;
            }
        }
        this.orderLineId = line.getC_OrderLine_ID();
        this.setM_Product_ID(0);
        return true;
    }

    public MProduct getProduct() {
        return this.m_product;
    }

    public void setPrice() {
        if (this.m_product == null) {
            return;
        }
        this.setParameter();
        MWarehousePrice result = MWarehousePrice.get(this.m_product, this.m_M_PriceList_Version_ID, this.m_M_Warehouse_ID, null);
        if (result != null) {
            this.p_posPanel.f_curLine.setPrice(result.getPriceStd());
        } else {
            this.p_posPanel.f_curLine.setPrice(Env.ZERO);
        }
    }

    private void findProduct() {
        String query = this.f_name.getText();
        if (query == null || query.length() == 0) {
            return;
        }
        query = query.toUpperCase();
        boolean allNumber = true;
        try {
            Integer.getInteger(query);
        }
        catch (Exception e) {
            allNumber = false;
        }
        String Value = query;
        String Name2 = query;
        String UPC = allNumber ? query : null;
        String SKU = allNumber ? query : null;
        MWarehousePrice[] results = null;
        this.setParameter();
        results = MWarehousePrice.find(this.p_ctx, this.m_M_PriceList_Version_ID, this.m_M_Warehouse_ID, Value, Name2, UPC, SKU, null);
        if (results.length == 0) {
            String message = Msg.translate(this.p_ctx, "search.product.notfound");
            ADialog.warn(0, this.p_posPanel, message + query);
            this.setM_Product_ID(0);
            this.p_posPanel.f_curLine.setPrice(Env.ZERO);
        } else if (results.length == 1) {
            this.setM_Product_ID(results[0].getM_Product_ID());
            this.setQty(Env.ONE);
            this.f_name.setText(results[0].getName());
            this.p_posPanel.f_curLine.setPrice(results[0].getPriceStd());
            this.saveLine();
        } else {
            QueryProduct qt = new QueryProduct(this.p_posPanel);
            qt.setResults(results);
            qt.setQueryData(this.m_M_PriceList_Version_ID, this.m_M_Warehouse_ID);
            qt.setVisible(true);
        }
    }

    public void setM_Product_ID(int M_Product_ID) {
        log.fine("PosSubProduct.setM_Product_ID=" + M_Product_ID);
        if (M_Product_ID <= 0) {
            this.m_product = null;
        } else {
            this.m_product = MProduct.get(this.p_ctx, M_Product_ID);
            if (this.m_product.get_ID() == 0) {
                this.m_product = null;
            }
        }
        if (this.m_product != null) {
            this.f_name.setText(this.m_product.getName());
            this.f_name.setToolTipText(this.m_product.getDescription());
        } else {
            this.f_name.setText(null);
            this.f_name.setToolTipText(null);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.isTemporary()) {
            return;
        }
        log.info("PosSubProduct - focusLost");
        this.findProduct();
        this.p_posPanel.updateInfo();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object data;
        if (e.getValueIsAdjusting()) {
            return;
        }
        int row = this.m_table.getSelectedRow();
        if (row != -1 && (data = this.m_table.getModel().getValueAt(row, 0)) != null) {
            Integer id = ((IDColumn)data).getRecord_ID();
            this.orderLineId = id;
            this.loadLine(id);
        }
        this.enableButtons();
    }

    private void loadLine(int lineId) {
        if (lineId <= 0) {
            return;
        }
        log.fine("SubCurrentLine - loading line " + lineId);
        MOrderLine ol = new MOrderLine(this.p_ctx, lineId, null);
        if (ol != null) {
            this.setPrice(ol.getPriceActual());
            this.setQty(ol.getQtyOrdered());
        }
    }
}

