/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Properties;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.compiere.apps.AppsAction;
import org.compiere.apps.ConfirmPanel;
import org.compiere.model.MPOS;
import org.compiere.pos.PosBasePanel;
import org.compiere.pos.PosTable;
import org.compiere.pos.QueryProduct;
import org.compiere.swing.CButton;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public abstract class PosQuery
extends CDialog
implements MouseListener,
ListSelectionListener,
ActionListener {
    protected Properties p_ctx;
    protected PosBasePanel p_posPanel = null;
    protected MPOS p_pos = null;
    protected PosTable m_table;
    protected CPanel northPanel;
    protected CScrollPane centerScroll;
    protected ConfirmPanel confirm;
    protected CButton f_up;
    protected CButton f_down;
    protected static CLogger log = CLogger.getCLogger(QueryProduct.class);

    public PosQuery() throws HeadlessException {
    }

    protected abstract void close();

    public abstract void reset();

    @Override
    public abstract void actionPerformed(ActionEvent var1);

    @Override
    public void dispose() {
        this.removeAll();
        this.northPanel = null;
        this.centerScroll = null;
        this.confirm = null;
        this.m_table = null;
        super.dispose();
    }

    protected abstract void init();

    protected abstract void enableButtons();

    public PosQuery(PosBasePanel posPanel) {
        super((Frame)Env.getFrame(posPanel), true);
        this.p_posPanel = posPanel;
        this.p_pos = posPanel.p_pos;
        this.p_ctx = this.p_pos.getCtx();
        this.init();
        this.pack();
        this.setLocationByPlatform(true);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 0 && this.m_table.getSelectedRow() != -1) {
            this.enableButtons();
            this.close();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.enableButtons();
    }

    protected CButton createButtonAction(String action, KeyStroke accelerator) {
        AppsAction act = new AppsAction(action, accelerator, false);
        act.setDelegate(this);
        CButton button = (CButton)act.getButton();
        button.setPreferredSize(new Dimension(1, 2));
        button.setMinimumSize(this.getPreferredSize());
        button.setMaximumSize(this.getPreferredSize());
        button.setFocusable(false);
        return button;
    }
}

