/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Icon;
import net.miginfocom.swing.MigLayout;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.model.MImage;
import org.compiere.model.MPOSKey;
import org.compiere.model.MPOSKeyLayout;
import org.compiere.pos.PosKeyListener;
import org.compiere.print.MPrintColor;
import org.compiere.print.MPrintFont;
import org.compiere.swing.CButton;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class PosKeyPanel
extends CPanel
implements ActionListener {
    private static final long serialVersionUID = -1773720355288801510L;
    private CardLayout cardLayout = new CardLayout();
    private HashMap<Integer, HashMap<Integer, MPOSKey>> keymap = new HashMap();
    int currentLayout;
    private static CLogger log = CLogger.getCLogger(PosKeyPanel.class);
    private PosKeyListener caller;

    public PosKeyPanel(int C_POSKeyLayout_ID, PosKeyListener caller) {
        if (C_POSKeyLayout_ID == 0) {
            return;
        }
        this.setLayout(this.cardLayout);
        this.add((Component)this.createCard(C_POSKeyLayout_ID), Integer.toString(C_POSKeyLayout_ID));
        this.currentLayout = C_POSKeyLayout_ID;
        this.cardLayout.show(this, Integer.toString(C_POSKeyLayout_ID));
        this.caller = caller;
    }

    private CPanel createCard(int C_POSKeyLayout_ID) {
        if (this.keymap.containsKey(C_POSKeyLayout_ID)) {
            return null;
        }
        CPanel card = new CPanel();
        card.setLayout((LayoutManager)new MigLayout("fill, ins 0"));
        MPOSKeyLayout keyLayout = MPOSKeyLayout.get(Env.getCtx(), C_POSKeyLayout_ID);
        Color stdColor = Color.lightGray;
        if (keyLayout.getAD_PrintColor_ID() != 0) {
            MPrintColor color = MPrintColor.get(Env.getCtx(), keyLayout.getAD_PrintColor_ID());
            stdColor = color.getColor();
        }
        Font stdFont = AdempierePLAF.getFont_Field();
        if (keyLayout.getAD_PrintFont_ID() != 0) {
            MPrintFont font = MPrintFont.get(keyLayout.getAD_PrintFont_ID());
            stdFont = font.getFont();
        }
        if (keyLayout.get_ID() == 0) {
            return null;
        }
        MPOSKey[] keys = keyLayout.getKeys(false);
        HashMap<Integer, MPOSKey> map = new HashMap<Integer, MPOSKey>(keys.length);
        this.keymap.put(C_POSKeyLayout_ID, map);
        int COLUMNS = 3;
        int ROWS = 3;
        int noKeys = keys.length;
        int cols = keyLayout.getColumns();
        if (cols == 0) {
            cols = COLUMNS;
        }
        int buttons = 0;
        log.fine("PosSubFunctionKeys.init - NoKeys=" + noKeys + ", Cols=" + cols);
        CPanel content = new CPanel((LayoutManager)new MigLayout("fill, wrap " + Math.max(cols, 3)));
        String buttonSize = "h 50, w 50, growx, growy, sg button,";
        for (MPOSKey key : keys) {
            CPanel subCard;
            if (key.getSubKeyLayout_ID() > 0 && (subCard = this.createCard(key.getSubKeyLayout_ID())) != null) {
                this.add((Component)subCard, Integer.toString(key.getSubKeyLayout_ID()));
            }
            map.put(key.getC_POSKey_ID(), key);
            Color keyColor = stdColor;
            Font keyFont = stdFont;
            StringBuffer buttonHTML = new StringBuffer("<html><p>");
            if (key.getAD_PrintColor_ID() != 0) {
                MPrintColor color = MPrintColor.get(Env.getCtx(), key.getAD_PrintColor_ID());
                keyColor = color.getColor();
            }
            if (key.getAD_PrintFont_ID() != 0) {
                MPrintFont font = MPrintFont.get(key.getAD_PrintFont_ID());
                keyFont = font.getFont();
            }
            buttonHTML.append(key.getName());
            buttonHTML.append("</p></html>");
            log.fine("#" + map.size() + " - " + keyColor);
            CButton button = new CButton(buttonHTML.toString());
            button.setBackground(keyColor);
            button.setFont(keyFont);
            if (key.getAD_Image_ID() != 0) {
                MImage image = MImage.get(Env.getCtx(), key.getAD_Image_ID());
                Icon icon = image.getIcon();
                button.setIcon(icon);
                button.setVerticalTextPosition(3);
                button.setHorizontalTextPosition(0);
            }
            button.setFocusable(false);
            if (!key.isActive()) {
                button.setEnabled(false);
            }
            button.setActionCommand(String.valueOf(key.getC_POSKey_ID()));
            button.addActionListener(this);
            String constraints = buttonSize;
            int size = 1;
            if (key.getSpanX() > 1) {
                constraints = constraints + "spanx " + key.getSpanX() + ",";
                size = key.getSpanX();
            }
            if (key.getSpanY() > 1) {
                constraints = constraints + "spany " + key.getSpanY() + ",";
                size *= key.getSpanY();
            }
            buttons += size;
            content.add((Component)button, constraints);
        }
        int rows = Math.max(buttons / cols, ROWS);
        if (buttons % cols > 0) {
            ++rows;
        }
        for (int i2 = buttons; i2 < rows * cols; ++i2) {
            CButton button = new CButton("");
            button.setFocusable(false);
            button.setReadWrite(false);
            content.add((Component)button, buttonSize);
        }
        CScrollPane scroll = new CScrollPane(content);
        card.add((Component)scroll, "growx, growy");
        scroll.getVerticalScrollBar().setPreferredSize(new Dimension(30, 0));
        scroll.getHorizontalScrollBar().setPreferredSize(new Dimension(0, 30));
        return card;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == null || action.length() == 0 || this.keymap == null) {
            return;
        }
        log.info("PosSubFunctionKeys - actionPerformed: " + action);
        HashMap<Integer, MPOSKey> currentKeymap = this.keymap.get(this.currentLayout);
        try {
            int C_POSKey_ID = Integer.parseInt(action);
            MPOSKey key = currentKeymap.get(C_POSKey_ID);
            if (key.getSubKeyLayout_ID() > 0) {
                this.currentLayout = key.getSubKeyLayout_ID();
                this.cardLayout.show(this, Integer.toString(key.getSubKeyLayout_ID()));
            } else {
                this.caller.keyReturned(key);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }
}

