/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import javax.swing.border.TitledBorder;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.MCash;
import org.compiere.model.MCashBook;
import org.compiere.model.MCashLine;
import org.compiere.model.MQuery;
import org.compiere.pos.PosBasePanel;
import org.compiere.pos.PosQuery;
import org.compiere.pos.SubCheckout;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class CashSubFunctions
extends PosQuery
implements ActionListener,
InputMethodListener {
    private static final long serialVersionUID = -7496311215470523905L;
    private CButton f_displayInitialChange = null;
    private CButton f_inputsOutputs = null;
    private CButton f_tickets = null;
    private CButton f_closingCash = null;
    private CButton f_displayCashScrutiny = null;
    private CButton f_pos = null;
    private CPanel c;
    private CPanel cInitial;
    private CLabel l_PreviousChange = null;
    private VNumber v_PreviousChange;
    private CLabel l_change = null;
    private VNumber v_change;
    private CButton f_change = null;
    private CPanel cScrutiny;
    private CLabel l_previousBalance = null;
    private VNumber v_previousBalance;
    private CLabel l_ActualBalance = null;
    private VNumber v_ActualBalance;
    private CLabel l_difference = null;
    private VNumber v_difference;
    private CButton f_calculateDifference = null;
    private CPanel panel;
    private CScrollPane centerScroll;
    private ConfirmPanel confirm;
    private Properties p_ctx;
    private static CLogger log = CLogger.getCLogger(SubCheckout.class);

    public CashSubFunctions(PosBasePanel posPanel) {
        super(posPanel);
    }

    @Override
    protected void init() {
        CPanel main = new CPanel();
        main.setLayout(new BorderLayout(2, 6));
        main.setPreferredSize(new Dimension(400, 600));
        this.getContentPane().add(main);
        this.panel = new CPanel(new GridBagLayout());
        main.add((Component)this.panel, "Center");
        this.panel.setBorder(new TitledBorder(Msg.getMsg(this.p_ctx, "Cash Functions")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        gbc.weightx = 0.3;
        gbc.weighty = 0.05;
        this.f_displayInitialChange = this.createButtonAction("InitialChange", null);
        this.f_displayInitialChange.setText("Initial Change");
        this.f_displayInitialChange.setActionCommand("displayInitialChange");
        this.f_displayInitialChange.setMaximumSize(new Dimension(160, 35));
        this.f_displayInitialChange.setMinimumSize(new Dimension(160, 35));
        this.f_displayInitialChange.setPreferredSize(new Dimension(160, 35));
        this.panel.add((Component)this.f_displayInitialChange, gbc);
        this.f_closingCash = this.createButtonAction("InitialChange", null);
        this.f_closingCash.setText("Cash Closing");
        this.f_closingCash.setActionCommand("CashClosing");
        this.f_closingCash.setPreferredSize(new Dimension(160, 35));
        this.f_closingCash.setMaximumSize(new Dimension(160, 35));
        this.f_closingCash.setMinimumSize(new Dimension(160, 35));
        gbc.gridy = 1;
        this.panel.add((Component)this.f_closingCash, gbc);
        this.f_displayCashScrutiny = this.createButtonAction("Scrutiny", null);
        this.f_displayCashScrutiny.setText("Cash Scrutiny");
        this.f_displayCashScrutiny.setActionCommand("displayCashScrutiny");
        this.f_displayCashScrutiny.setPreferredSize(new Dimension(160, 35));
        this.f_displayCashScrutiny.setMaximumSize(new Dimension(160, 35));
        this.f_displayCashScrutiny.setMinimumSize(new Dimension(160, 35));
        gbc.gridy = 2;
        this.panel.add((Component)this.f_displayCashScrutiny, gbc);
        this.f_inputsOutputs = this.createButtonAction("Inputs", null);
        this.f_inputsOutputs.setText("Inputs and Outputs");
        this.f_inputsOutputs.setActionCommand("InputsOutputs");
        this.f_inputsOutputs.setPreferredSize(new Dimension(160, 35));
        this.f_inputsOutputs.setMaximumSize(new Dimension(160, 35));
        this.f_inputsOutputs.setMinimumSize(new Dimension(160, 35));
        gbc.gridy = 3;
        this.panel.add((Component)this.f_inputsOutputs, gbc);
        this.f_tickets = this.createButtonAction("Tickets", null);
        this.f_tickets.setText("Tickets");
        this.f_tickets.setPreferredSize(new Dimension(160, 35));
        this.f_tickets.setMaximumSize(new Dimension(160, 35));
        this.f_tickets.setMinimumSize(new Dimension(160, 35));
        gbc.gridy = 4;
        this.panel.add((Component)this.f_tickets, gbc);
        this.f_pos = this.createButtonAction("End", null);
        this.f_pos.setText("POS");
        this.f_pos.setPreferredSize(new Dimension(160, 35));
        this.f_pos.setMaximumSize(new Dimension(160, 35));
        this.f_pos.setMinimumSize(new Dimension(160, 35));
        gbc.gridy = 5;
        this.panel.add((Component)this.f_pos, gbc);
        gbc.gridx = 1;
        gbc.anchor = 17;
        gbc.gridy = 0;
        gbc.gridheight = 5;
        this.c = new CPanel(new GridBagLayout());
        this.c.setBorder(new TitledBorder(""));
        this.c.setMaximumSize(new Dimension(400, 400));
        this.c.setMinimumSize(new Dimension(400, 400));
        this.c.setPreferredSize(new Dimension(400, 400));
        this.panel.add((Component)this.c, gbc);
        gbc.gridx = 1;
        gbc.anchor = 17;
        gbc.gridy = 0;
        gbc.gridheight = 5;
        this.cInitial = new CPanel(new GridBagLayout());
        this.cInitial.setBorder(new TitledBorder("Initial Change"));
        this.cInitial.setVisible(false);
        this.panel.add((Component)this.cInitial, gbc);
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.anchor = 10;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        this.l_PreviousChange = new CLabel("Previous Change");
        this.cInitial.add((Component)this.l_PreviousChange, gbc0);
        gbc0.gridx = 1;
        this.v_PreviousChange = new VNumber("PreviousChange", false, true, false, 12, "PreviousChange");
        this.v_PreviousChange.setColumns(10, 25);
        this.cInitial.add((Component)this.v_PreviousChange, gbc0);
        this.v_PreviousChange.setValue(Env.ZERO);
        gbc0.gridx = 0;
        gbc0.gridy = 1;
        this.l_change = new CLabel("Initial Change");
        this.cInitial.add((Component)this.l_change, gbc0);
        gbc0.gridx = 1;
        this.v_change = new VNumber("Change", false, false, true, 12, "Change");
        this.v_change.setColumns(10, 25);
        this.cInitial.add((Component)this.v_change, gbc0);
        this.v_change.setValue(Env.ZERO);
        gbc0.gridy = 2;
        gbc0.gridx = 0;
        gbc0.gridwidth = 2;
        this.f_change = this.createButtonAction("InitialChange", null);
        this.f_change.setText("Save Change");
        this.f_change.setActionCommand("saveChange");
        this.cInitial.add((Component)this.f_change, gbc0);
        this.f_change.setPreferredSize(new Dimension(160, 35));
        this.f_change.setMaximumSize(new Dimension(160, 35));
        this.f_change.setMinimumSize(new Dimension(160, 35));
        this.cInitial.setMaximumSize(new Dimension(400, 400));
        this.cInitial.setMinimumSize(new Dimension(400, 400));
        this.cInitial.setPreferredSize(new Dimension(400, 400));
        gbc.gridx = 1;
        gbc.anchor = 17;
        gbc.gridy = 0;
        gbc.gridheight = 5;
        this.cScrutiny = new CPanel(new GridBagLayout());
        this.cScrutiny.setBorder(new TitledBorder("Cash Scrutiny"));
        this.cScrutiny.setVisible(false);
        this.panel.add((Component)this.cScrutiny, gbc);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.anchor = 10;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        this.l_previousBalance = new CLabel("Previous Balance");
        this.cScrutiny.add((Component)this.l_previousBalance, gbc1);
        gbc1.gridx = 1;
        this.v_previousBalance = new VNumber("PreviousBalance", false, true, false, 12, "PreviousBalance");
        this.v_previousBalance.setColumns(10, 25);
        this.cScrutiny.add((Component)this.v_previousBalance, gbc1);
        this.v_previousBalance.setValue(Env.ZERO);
        gbc1.gridx = 0;
        gbc1.gridy = 1;
        this.l_ActualBalance = new CLabel("Actual Balance");
        this.cScrutiny.add((Component)this.l_ActualBalance, gbc1);
        gbc1.gridx = 1;
        this.v_ActualBalance = new VNumber("ActualBalance", false, false, true, 12, "ActualBalance");
        this.v_ActualBalance.setColumns(10, 25);
        this.v_ActualBalance.addActionListener(this);
        this.v_ActualBalance.addInputMethodListener(this);
        this.cScrutiny.add((Component)this.v_ActualBalance, gbc1);
        this.v_ActualBalance.setValue(Env.ZERO);
        gbc1.gridx = 0;
        gbc1.gridy = 2;
        this.l_difference = new CLabel("Difference");
        this.cScrutiny.add((Component)this.l_difference, gbc1);
        gbc1.gridx = 1;
        this.v_difference = new VNumber("Difference", false, true, false, 12, "Difference");
        this.v_difference.setColumns(10, 25);
        this.cScrutiny.add((Component)this.v_difference, gbc1);
        this.v_difference.setValue(Env.ZERO);
        gbc1.gridx = 0;
        gbc1.gridy = 4;
        gbc1.gridwidth = 2;
        gbc1.fill = 2;
        this.f_calculateDifference = this.createButtonAction("InitialChange", null);
        this.f_calculateDifference.setText("Annotate Difference");
        this.f_calculateDifference.setActionCommand("AnnotateDiference");
        this.cScrutiny.add((Component)this.f_calculateDifference, gbc1);
        this.cScrutiny.setMaximumSize(new Dimension(400, 400));
        this.cScrutiny.setMinimumSize(new Dimension(400, 400));
        this.cScrutiny.setPreferredSize(new Dimension(400, 400));
    }

    @Override
    public void dispose() {
        this.removeAll();
        this.panel = null;
        this.centerScroll = null;
        this.confirm = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == null || action.length() == 0) {
            return;
        }
        log.info("PosCashSubFunctions - actionPerformed: " + action);
        if (action.equals("displayInitialChange")) {
            this.cmd_displayInitialChange();
        } else if (action.equals("CashClosing")) {
            Timestamp today = TimeUtil.getDay(System.currentTimeMillis());
            MCash cash = MCash.get(this.p_pos.getCtx(), this.p_pos.getC_CashBook_ID(), today, null);
            MQuery query = new MQuery("C_Cash");
            query.addRestriction("C_Cash_ID", "=", cash.getC_Cash_ID());
            AEnv.zoom(query);
        } else if (action.equals("InputsOutputs")) {
            Timestamp today = TimeUtil.getDay(System.currentTimeMillis());
            MCash cash = MCash.get(this.p_pos.getCtx(), this.p_pos.getC_CashBook_ID(), today, null);
            AEnv.zoom(MCash.Table_ID, cash.getC_Cash_ID());
        } else if (action.equals("Tickets")) {
            MQuery query = new MQuery("C_Order");
            query.addRestriction("C_DocTypeTarget_ID", "=", this.p_pos.getC_DocType_ID());
            AEnv.zoom(query);
        } else if (action.equals("displayCashScrutiny")) {
            this.cmd_displayCashScrutiny();
        } else if (action.equals("End")) {
            super.dispose();
        } else if (action.equals("saveChange")) {
            this.cmd_saveChange();
        } else if (action.equals("AnnotateDifference")) {
            this.cmd_calculateDifference();
            this.cmd_annotateDifference();
        } else if (e.getSource() == this.v_ActualBalance) {
            this.cmd_calculateDifference();
        }
    }

    private void cmd_displayInitialChange() {
        this.cScrutiny.setVisible(false);
        this.c.setVisible(false);
        this.cInitial.setVisible(true);
        Timestamp today = TimeUtil.getDay(System.currentTimeMillis());
        MCash cash = MCash.get(this.p_pos.getCtx(), this.p_pos.getC_CashBook_ID(), today, null);
        if (cash != null) {
            this.v_PreviousChange.setValue(cash.getEndingBalance());
            this.v_change.setValue(cash.getEndingBalance());
        } else {
            log.severe("No Cash");
        }
    }

    private void cmd_displayCashScrutiny() {
        this.cInitial.setVisible(false);
        this.c.setVisible(false);
        this.cScrutiny.setVisible(true);
        Timestamp today = TimeUtil.getDay(System.currentTimeMillis());
        MCash cash = MCash.get(this.p_pos.getCtx(), this.p_pos.getC_CashBook_ID(), today, null);
        this.v_previousBalance.setValue(cash.getEndingBalance());
    }

    private void cmd_saveChange() {
        MCashBook cashBook = new MCashBook(this.p_ctx, this.p_pos.getC_CashBook_ID(), null);
        Timestamp today = TimeUtil.getDay(System.currentTimeMillis());
        MCash cash = MCash.get(this.p_ctx, this.p_pos.getC_CashBook_ID(), today, null);
        BigDecimal initialChange = (BigDecimal)this.v_change.getValue();
        if (cash != null && cash.get_ID() != 0 && initialChange.compareTo(cash.getEndingBalance()) != 0) {
            MCashLine cl = new MCashLine(cash);
            cl.setCashType("D");
            cl.setAmount(initialChange.subtract(cash.getEndingBalance()));
            cl.setDescription("Initial Change Before: " + cash.getEndingBalance() + " Now: " + initialChange);
            cl.save();
        }
        this.v_PreviousChange.setValue(initialChange);
    }

    private void cmd_calculateDifference() {
        Timestamp today = TimeUtil.getDay(System.currentTimeMillis());
        MCash cash = MCash.get(this.p_pos.getCtx(), this.p_pos.getC_CashBook_ID(), today, null);
        this.v_previousBalance.setValue(cash.getEndingBalance());
        BigDecimal previousValue = cash.getEndingBalance();
        BigDecimal actualValue = (BigDecimal)this.v_ActualBalance.getValue();
        this.v_difference.setValue(actualValue.subtract(previousValue));
    }

    private void cmd_annotateDifference() {
        BigDecimal previousValue = (BigDecimal)this.v_previousBalance.getValue();
        BigDecimal actualValue = (BigDecimal)this.v_ActualBalance.getValue();
        BigDecimal difference = actualValue.subtract(previousValue);
        MCashBook cashBook = new MCashBook(this.p_ctx, this.p_pos.getC_CashBook_ID(), null);
        Timestamp today = TimeUtil.getDay(System.currentTimeMillis());
        MCash cash = MCash.get(this.p_ctx, cashBook.getC_CashBook_ID(), today, null);
        if (cash != null && cash.get_ID() != 0 && difference.compareTo(cash.getStatementDifference()) != 0) {
            MCashLine cl = new MCashLine(cash);
            cl.setCashType("D");
            cl.setAmount(difference);
            cl.setDescription(Msg.translate(this.p_pos.getCtx(), "Cash Scrutiny -> Before: ") + previousValue + " Now: " + actualValue);
            cl.save();
        }
        cash = MCash.get(this.p_pos.getCtx(), this.p_pos.getC_CashBook_ID(), today, null);
        this.v_previousBalance.setValue(cash.getEndingBalance());
        this.v_ActualBalance.setValue(Env.ZERO);
        this.v_difference.setValue(Env.ZERO);
    }

    @Override
    public void caretPositionChanged(InputMethodEvent event) {
        this.cmd_calculateDifference();
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent event) {
        this.cmd_calculateDifference();
    }

    @Override
    protected void close() {
    }

    @Override
    protected void enableButtons() {
    }

    @Override
    public void reset() {
    }
}

