/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.Adempiere;
import org.compiere.acct.Doc;
import org.compiere.model.DocWorkflowMgr;
import org.compiere.model.Lookup;
import org.compiere.model.MAttachment;
import org.compiere.model.MChangeLog;
import org.compiere.model.MClient;
import org.compiere.model.MClientShare;
import org.compiere.model.MRefList;
import org.compiere.model.MSession;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTree_Base;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Null;
import org.compiere.model.POInfo;
import org.compiere.model.PO_LOB;
import org.compiere.model.PO_Record;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Msg;
import org.compiere.util.SecureEngine;
import org.compiere.util.Trace;
import org.compiere.util.Trx;
import org.compiere.util.ValueNamePair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class PO
implements Serializable,
Comparator,
Evaluatee,
Cloneable {
    private static final long serialVersionUID = -4708137979682082002L;
    private static final String USE_TIMEOUT_FOR_UPDATE = "org.adempiere.po.useTimeoutForUpdate";
    private static final int QUERY_TIME_OUT = 10;
    private static DocWorkflowMgr s_docWFMgr = null;
    protected static final String ENTITYTYPE_UserMaintained = "U";
    protected static final String ENTITYTYPE_Dictionary = "D";
    protected transient CLogger log = CLogger.getCLogger(this.getClass());
    private static CLogger s_log = CLogger.getCLogger(PO.class);
    protected Properties p_ctx;
    protected volatile POInfo p_info = null;
    private Object[] m_oldValues = null;
    private Object[] m_newValues = null;
    private Object[] m_IDs = new Object[]{I_ZERO};
    private String[] m_KeyColumns = null;
    private boolean m_createNew = false;
    private MAttachment m_attachment = null;
    private int m_idOld = 0;
    private HashMap<String, String> m_custom = null;
    protected static final Integer I_ZERO = new Integer(0);
    private ArrayList<String> s_acctColumns = null;
    private boolean m_isReplication = false;
    public static final int ACCESSLEVEL_SYSTEM = 4;
    public static final int ACCESSLEVEL_CLIENT = 2;
    public static final int ACCESSLEVEL_ORG = 1;
    public static final int ACCESSLEVEL_ALL = 7;
    public static final int ACCESSLEVEL_SYSTEMCLIENT = 6;
    public static final int ACCESSLEVEL_CLIENTORG = 3;
    private String m_trxName = null;
    private ArrayList<PO_LOB> m_lobInfo = null;
    protected static final String XML_ATTRIBUTE_AD_Table_ID = "AD_Table_ID";
    protected static final String XML_ATTRIBUTE_Record_ID = "Record_ID";
    private Doc m_doc;

    public static void setDocWorkflowMgr(DocWorkflowMgr docWFMgr) {
        s_docWFMgr = docWFMgr;
        s_log.config(s_docWFMgr.toString());
    }

    public PO(Properties ctx) {
        this(ctx, 0, null, null);
    }

    public PO(Properties ctx, int ID, String trxName) {
        this(ctx, ID, trxName, null);
    }

    public PO(Properties ctx, ResultSet rs, String trxName) {
        this(ctx, 0, trxName, rs);
    }

    public PO(Properties ctx, int ID, String trxName, ResultSet rs) {
        if (ctx == null) {
            throw new IllegalArgumentException("No Context");
        }
        this.p_ctx = ctx;
        this.m_trxName = trxName;
        this.p_info = this.initPO(ctx);
        if (this.p_info == null || this.p_info.getTableName() == null) {
            throw new IllegalArgumentException("Invalid PO Info - " + this.p_info);
        }
        int size = this.p_info.getColumnCount();
        this.m_oldValues = new Object[size];
        this.m_newValues = new Object[size];
        if (rs != null) {
            this.load(rs);
        } else {
            this.load(ID, trxName);
        }
    }

    public PO(Properties ctx, PO source, int AD_Client_ID, int AD_Org_ID) {
        this(ctx, 0, null, null);
        if (source != null) {
            PO.copyValues(source, this);
        }
        this.setAD_Client_ID(AD_Client_ID);
        this.setAD_Org_ID(AD_Org_ID);
    }

    protected abstract POInfo initPO(Properties var1);

    protected abstract int get_AccessLevel();

    public String toString() {
        StringBuffer sb = new StringBuffer("PO[").append(this.get_WhereClause(true)).append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object cmp) {
        if (cmp == null) {
            return false;
        }
        if (!(cmp instanceof PO)) {
            return false;
        }
        if (cmp.getClass().equals(this.getClass())) {
            if (((PO)cmp).get_ID() == 0 && this.get_ID() == 0) {
                return super.equals(cmp);
            }
            return ((PO)cmp).get_ID() == this.get_ID();
        }
        return super.equals(cmp);
    }

    public int compare(Object o1, Object o2) {
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (!(o1 instanceof PO)) {
            throw new ClassCastException("Not PO -1- " + o1);
        }
        if (!(o2 instanceof PO)) {
            throw new ClassCastException("Not PO -2- " + o2);
        }
        if (o1.getClass().equals(o2.getClass())) {
            int index = this.get_ColumnIndex("DocumentNo");
            if (index == -1) {
                index = this.get_ColumnIndex("Value");
            }
            if (index == -1) {
                index = this.get_ColumnIndex("Name");
            }
            if (index == -1) {
                index = this.get_ColumnIndex("Description");
            }
            if (index != -1) {
                PO po1 = (PO)o1;
                Object comp1 = po1.get_Value(index);
                PO po2 = (PO)o2;
                Object comp2 = po2.get_Value(index);
                if (comp1 == null) {
                    return -1;
                }
                if (comp2 == null) {
                    return 1;
                }
                return comp1.toString().compareTo(comp2.toString());
            }
        }
        return o1.toString().compareTo(o2.toString());
    }

    public String get_TableName() {
        return this.p_info.getTableName();
    }

    public String[] get_KeyColumns() {
        return this.m_KeyColumns;
    }

    public int get_Table_ID() {
        return this.p_info.getAD_Table_ID();
    }

    public int get_ID() {
        Object oo = this.m_IDs[0];
        if (oo != null && oo instanceof Integer) {
            return (Integer)oo;
        }
        return 0;
    }

    public int get_IDOld() {
        return this.m_idOld;
    }

    public Properties getCtx() {
        return this.p_ctx;
    }

    public CLogger get_Logger() {
        return this.log;
    }

    public final Object get_Value(int index) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return null;
        }
        if (this.m_newValues[index] != null) {
            if (this.m_newValues[index].equals(Null.NULL)) {
                return null;
            }
            return this.m_newValues[index];
        }
        return this.m_oldValues[index];
    }

    public int get_ValueAsInt(int index) {
        Object value = this.get_Value(index);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException ex) {
            this.log.warning(this.p_info.getColumnName(index) + " - " + ex.getMessage());
            return 0;
        }
    }

    public final Object get_Value(String columnName) {
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            this.log.log(Level.WARNING, "Column not found - " + columnName);
            Trace.printStack();
            return null;
        }
        return this.get_Value(index);
    }

    protected final Object get_ValueE(String columnName) {
        return this.get_Value(columnName);
    }

    @Override
    public String get_ValueAsString(String variableName) {
        Object value = this.get_Value(variableName);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public final Object get_ValueOfColumn(int AD_Column_ID) {
        int index = this.p_info.getColumnIndex(AD_Column_ID);
        if (index < 0) {
            this.log.log(Level.WARNING, "Not found - AD_Column_ID=" + AD_Column_ID);
            return null;
        }
        return this.get_Value(index);
    }

    public final Object get_ValueOld(int index) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return null;
        }
        return this.m_oldValues[index];
    }

    public final Object get_ValueOld(String columnName) {
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            this.log.log(Level.WARNING, "Column not found - " + columnName);
            return null;
        }
        return this.get_ValueOld(index);
    }

    public int get_ValueOldAsInt(String columnName) {
        Object value = this.get_ValueOld(columnName);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException ex) {
            this.log.warning(columnName + " - " + ex.getMessage());
            return 0;
        }
    }

    public final boolean is_ValueChanged(int index) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return false;
        }
        if (this.m_newValues[index] == null) {
            return false;
        }
        return !this.m_newValues[index].equals(this.m_oldValues[index]);
    }

    public final boolean is_ValueChanged(String columnName) {
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            this.log.log(Level.WARNING, "Column not found - " + columnName);
            return false;
        }
        return this.is_ValueChanged(index);
    }

    public final Object get_ValueDifference(int index) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return null;
        }
        Object nValue = this.m_newValues[index];
        if (nValue == null || nValue == Null.NULL) {
            return null;
        }
        Object oValue = this.m_oldValues[index];
        if (oValue == null || oValue == Null.NULL) {
            return nValue;
        }
        if (nValue instanceof BigDecimal) {
            BigDecimal obd = (BigDecimal)oValue;
            return ((BigDecimal)nValue).subtract(obd);
        }
        if (nValue instanceof Integer) {
            int result = (Integer)nValue;
            return new Integer(result -= ((Integer)oValue).intValue());
        }
        this.log.warning("Invalid type - New=" + nValue);
        return null;
    }

    public final Object get_ValueDifference(String columnName) {
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            this.log.log(Level.WARNING, "Column not found - " + columnName);
            return null;
        }
        return this.get_ValueDifference(index);
    }

    protected final boolean set_Value(String ColumnName, Object value) {
        Class<?> clazz;
        int index;
        if (value instanceof String && ColumnName.equals("WhereClause") && value.toString().toUpperCase().indexOf("=NULL") != -1) {
            this.log.warning("Invalid Null Value - " + ColumnName + "=" + value);
        }
        if ((index = this.get_ColumnIndex(ColumnName)) < 0) {
            this.log.log(Level.SEVERE, "Column not found - " + ColumnName);
            return false;
        }
        if (ColumnName.endsWith("_ID") && value instanceof String && Integer.class == (clazz = this.p_info.getColumnClass(this.p_info.getColumnIndex(ColumnName)))) {
            this.log.severe("Invalid Data Type for " + ColumnName + "=" + value);
            value = Integer.parseInt((String)value);
        }
        return this.set_Value(index, value);
    }

    protected final boolean set_ValueE(String ColumnName, Object value) {
        return this.set_Value(ColumnName, value);
    }

    protected final boolean set_Value(int index, Object value) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return false;
        }
        String ColumnName = this.p_info.getColumnName(index);
        String colInfo = " - " + ColumnName;
        if (this.p_info.isVirtualColumn(index)) {
            this.log.log(Level.WARNING, "Virtual Column" + colInfo);
            return false;
        }
        if (!this.p_info.isColumnUpdateable(index) && !this.is_new()) {
            colInfo = colInfo + " - NewValue=" + value + " - OldValue=" + this.get_Value(index);
            this.log.log(Level.WARNING, "Column not updateable" + colInfo);
            return false;
        }
        if (value == null) {
            if (this.p_info.isColumnMandatory(index)) {
                throw new IllegalArgumentException(ColumnName + " is mandatory.");
            }
            this.m_newValues[index] = Null.NULL;
            this.log.finer(ColumnName + " = null");
        } else {
            if (value.getClass().equals(this.p_info.getColumnClass(index)) || this.p_info.getColumnClass(index) == Object.class) {
                this.m_newValues[index] = value;
            } else if (value.getClass() == BigDecimal.class && this.p_info.getColumnClass(index) == Integer.class) {
                this.m_newValues[index] = new Integer(((BigDecimal)value).intValue());
            } else if (this.p_info.getColumnClass(index) == Boolean.class && ("Y".equals(value) || "N".equals(value))) {
                this.m_newValues[index] = new Boolean("Y".equals(value));
            } else if (value.getClass() == Integer.class && this.p_info.getColumnClass(index) == String.class) {
                this.m_newValues[index] = value;
            } else if (value.getClass() == String.class && this.p_info.getColumnClass(index) == Integer.class) {
                try {
                    this.m_newValues[index] = new Integer((String)value);
                }
                catch (NumberFormatException e) {
                    this.log.log(Level.SEVERE, ColumnName + " - Class invalid: " + value.getClass().toString() + ", Should be " + this.p_info.getColumnClass(index).toString() + ": " + value);
                    return false;
                }
            } else {
                this.log.log(Level.SEVERE, ColumnName + " - Class invalid: " + value.getClass().toString() + ", Should be " + this.p_info.getColumnClass(index).toString() + ": " + value);
                return false;
            }
            String error = this.p_info.validate(index, value);
            if (error != null) {
                this.log.log(Level.WARNING, ColumnName + "=" + value + " - " + error);
                return false;
            }
            if (this.p_info.getColumnClass(index) == String.class) {
                String stringValue = value.toString();
                int length = this.p_info.getFieldLength(index);
                if (stringValue.length() > length && length > 0) {
                    this.log.warning(ColumnName + " - Value too long - truncated to length=" + length);
                    this.m_newValues[index] = stringValue.substring(0, length);
                }
            }
            if (this.p_info.getColumn((int)index).DisplayType == 17 && this.p_info.getColumn((int)index).AD_Reference_Value_ID > 0 && value instanceof String && MRefList.get(this.getCtx(), this.p_info.getColumn((int)index).AD_Reference_Value_ID, (String)value, this.get_TrxName()) == null) {
                StringBuffer validValues = new StringBuffer();
                for (ValueNamePair vp : MRefList.getList(this.getCtx(), this.p_info.getColumn((int)index).AD_Reference_Value_ID, false)) {
                    validValues.append(" - ").append(vp.getValue());
                }
                throw new IllegalArgumentException(ColumnName + " Invalid value - " + value + " - Reference_ID=" + this.p_info.getColumn((int)index).AD_Reference_Value_ID + validValues.toString());
            }
            if (CLogMgt.isLevelFinest()) {
                this.log.finest(ColumnName + " = " + this.m_newValues[index] + " (OldValue=" + this.m_oldValues[index] + ")");
            }
        }
        this.set_Keys(ColumnName, this.m_newValues[index]);
        this.setProcessedOn(ColumnName, value, this.m_oldValues[index]);
        return true;
    }

    public void setProcessedOn(String ColumnName, Object value, Object oldValue) {
        if ("Processed".equals(ColumnName) && value instanceof Boolean && ((Boolean)value).booleanValue() && (oldValue == null || oldValue instanceof Boolean && !((Boolean)oldValue).booleanValue()) && this.get_ColumnIndex("ProcessedOn") > 0) {
            Timestamp ts = DB.getSQLValueTS(null, "SELECT CURRENT_TIMESTAMP FROM DUAL", new Object[0]);
            long mili = ts.getTime();
            int nano = ts.getNanos();
            double doublets = Double.parseDouble(Long.toString(mili) + "." + Integer.toString(nano));
            BigDecimal bdtimestamp = new BigDecimal(doublets);
            this.set_Value("ProcessedOn", (Object)bdtimestamp);
        }
    }

    protected final boolean set_ValueNoCheck(String ColumnName, Object value) {
        int index = this.get_ColumnIndex(ColumnName);
        if (index < 0) {
            this.log.log(Level.SEVERE, "Column not found - " + ColumnName);
            return false;
        }
        if (value == null) {
            this.m_newValues[index] = Null.NULL;
        } else {
            if (value.getClass().equals(this.p_info.getColumnClass(index)) || this.p_info.getColumnClass(index) == Object.class) {
                this.m_newValues[index] = value;
            } else if (value.getClass() == BigDecimal.class && this.p_info.getColumnClass(index) == Integer.class) {
                this.m_newValues[index] = new Integer(((BigDecimal)value).intValue());
            } else if (this.p_info.getColumnClass(index) == Boolean.class && ("Y".equals(value) || "N".equals(value))) {
                this.m_newValues[index] = new Boolean("Y".equals(value));
            } else if (this.p_info.getColumnClass(index) == Integer.class && value.getClass() == String.class) {
                try {
                    int intValue = Integer.parseInt((String)value);
                    this.m_newValues[index] = intValue;
                }
                catch (Exception e) {
                    this.log.warning(ColumnName + " - Class invalid: " + value.getClass().toString() + ", Should be " + this.p_info.getColumnClass(index).toString() + ": " + value);
                    this.m_newValues[index] = null;
                }
            } else {
                this.log.warning(ColumnName + " - Class invalid: " + value.getClass().toString() + ", Should be " + this.p_info.getColumnClass(index).toString() + ": " + value);
                this.m_newValues[index] = value;
            }
            String error = this.p_info.validate(index, value);
            if (error != null) {
                this.log.warning(ColumnName + "=" + value + " - " + error);
            }
            if (this.p_info.getColumnClass(index) == String.class) {
                String stringValue = value.toString();
                int length = this.p_info.getFieldLength(index);
                if (stringValue.length() > length && length > 0) {
                    this.log.warning(ColumnName + " - Value too long - truncated to length=" + length);
                    this.m_newValues[index] = stringValue.substring(0, length);
                }
            }
        }
        this.log.finest(ColumnName + " = " + this.m_newValues[index] + " (" + (this.m_newValues[index] == null ? "-" : this.m_newValues[index].getClass().getName()) + ")");
        this.set_Keys(ColumnName, this.m_newValues[index]);
        this.setProcessedOn(ColumnName, value, this.m_oldValues[index]);
        return true;
    }

    protected final boolean set_ValueNoCheckE(String ColumnName, Object value) {
        return this.set_ValueNoCheck(ColumnName, value);
    }

    public final void set_ValueOfColumn(String columnName, Object value) {
        this.set_ValueOfColumnReturningBoolean(columnName, value);
    }

    public final boolean set_ValueOfColumnReturningBoolean(String columnName, Object value) {
        int AD_Column_ID = this.p_info.getAD_Column_ID(columnName);
        if (AD_Column_ID > 0) {
            return this.set_ValueOfColumnReturningBoolean(AD_Column_ID, value);
        }
        return false;
    }

    public final void set_ValueOfColumn(int AD_Column_ID, Object value) {
        this.set_ValueOfColumnReturningBoolean(AD_Column_ID, value);
    }

    public final boolean set_ValueOfColumnReturningBoolean(int AD_Column_ID, Object value) {
        String ColumnName;
        int index = this.p_info.getColumnIndex(AD_Column_ID);
        if (index < 0) {
            this.log.log(Level.SEVERE, "Not found - AD_Column_ID=" + AD_Column_ID);
        }
        if ((ColumnName = this.p_info.getColumnName(index)).equals("IsApproved")) {
            return this.set_ValueNoCheck(ColumnName, value);
        }
        return this.set_Value(index, value);
    }

    public final void set_CustomColumn(String columnName, Object value) {
        this.set_CustomColumnReturningBoolean(columnName, value);
    }

    public final boolean set_CustomColumnReturningBoolean(String columnName, Object value) {
        int poIndex = this.get_ColumnIndex(columnName);
        if (poIndex > 0) {
            return this.set_Value(columnName, value);
        }
        if (this.m_custom == null) {
            this.m_custom = new HashMap();
        }
        String valueString = "NULL";
        if (value != null) {
            valueString = value instanceof Number ? value.toString() : (value instanceof Boolean ? ((Boolean)value != false ? "'Y'" : "'N'") : (value instanceof Timestamp ? DB.TO_DATE((Timestamp)value, false) : DB.TO_STRING(value.toString())));
        }
        this.log.log(Level.INFO, columnName + "=" + valueString);
        this.m_custom.put(columnName, valueString);
        return true;
    }

    private void set_Keys(String ColumnName, Object value) {
        for (int i2 = 0; i2 < this.m_IDs.length; ++i2) {
            if (!ColumnName.equals(this.m_KeyColumns[i2])) continue;
            this.m_IDs[i2] = value;
        }
    }

    public int get_ColumnCount() {
        return this.p_info.getColumnCount();
    }

    public String get_ColumnName(int index) {
        return this.p_info.getColumnName(index);
    }

    protected String get_ColumnLabel(int index) {
        return this.p_info.getColumnLabel(index);
    }

    protected String get_ColumnDescription(int index) {
        return this.p_info.getColumnDescription(index);
    }

    protected boolean isColumnMandatory(int index) {
        return this.p_info.isColumnMandatory(index);
    }

    protected boolean isColumnUpdateable(int index) {
        return this.p_info.isColumnUpdateable(index);
    }

    protected void set_ColumnUpdateable(int index, boolean updateable) {
        this.p_info.setColumnUpdateable(index, updateable);
    }

    protected void setUpdateable(boolean updateable) {
        this.p_info.setUpdateable(updateable);
    }

    protected int get_ColumnDisplayType(int index) {
        return this.p_info.getColumnDisplayType(index);
    }

    protected Lookup get_ColumnLookup(int index) {
        return this.p_info.getColumnLookup(index);
    }

    public final int get_ColumnIndex(String columnName) {
        return this.p_info.getColumnIndex(columnName);
    }

    protected String get_DisplayValue(String columnName, boolean currentValue) {
        Object value;
        Object object = value = currentValue ? this.get_Value(columnName) : this.get_ValueOld(columnName);
        if (value == null) {
            return "./.";
        }
        String retValue = value.toString();
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            return retValue;
        }
        int dt = this.get_ColumnDisplayType(index);
        if (DisplayType.isText(dt) || 20 == dt) {
            return retValue;
        }
        Lookup lookup = this.get_ColumnLookup(index);
        if (lookup != null) {
            return lookup.getDisplay(value);
        }
        return retValue;
    }

    protected static void copyValues(PO from, PO to, int AD_Client_ID, int AD_Org_ID) {
        PO.copyValues(from, to);
        to.setAD_Client_ID(AD_Client_ID);
        to.setAD_Org_ID(AD_Org_ID);
    }

    public static void copyValues(PO from, PO to) {
        s_log.fine("From ID=" + from.get_ID() + " - To ID=" + to.get_ID());
        if (from.getClass() != to.getClass()) {
            block0: for (int i1 = 0; i1 < from.m_oldValues.length; ++i1) {
                String colName;
                if (from.p_info.isVirtualColumn(i1) || from.p_info.isKey(i1) || (colName = from.p_info.getColumnName(i1)).startsWith("Created") || colName.startsWith("Updated") || colName.equals("IsActive") || colName.equals("AD_Client_ID") || colName.equals("AD_Org_ID") || colName.equals("Processing")) continue;
                for (int i2 = 0; i2 < to.m_oldValues.length; ++i2) {
                    if (!to.p_info.getColumnName(i2).equals(colName)) continue;
                    to.m_newValues[i2] = from.m_oldValues[i1];
                    continue block0;
                }
            }
        } else {
            for (int i2 = 0; i2 < from.m_oldValues.length; ++i2) {
                String colName;
                if (from.p_info.isVirtualColumn(i2) || from.p_info.isKey(i2) || (colName = from.p_info.getColumnName(i2)).startsWith("Created") || colName.startsWith("Updated") || colName.equals("IsActive") || colName.equals("AD_Client_ID") || colName.equals("AD_Org_ID") || colName.equals("Processing")) continue;
                to.m_newValues[i2] = from.m_oldValues[i2];
            }
        }
    }

    protected void load(int ID, String trxName) {
        this.log.finest("ID=" + ID);
        if (ID > 0) {
            this.m_IDs = new Object[]{new Integer(ID)};
            this.m_KeyColumns = new String[]{this.p_info.getTableName() + "_ID"};
            this.load(trxName);
        } else {
            this.loadDefaults();
            this.m_createNew = true;
            this.setKeyInfo();
            this.loadComplete(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(String trxName) {
        this.m_trxName = trxName;
        boolean success = true;
        StringBuffer sql = this.p_info.buildSelect();
        sql.append(" WHERE ").append(this.get_WhereClause(false));
        int size = this.get_ColumnCount();
        if (CLogMgt.isLevelFinest()) {
            this.log.finest(this.get_WhereClause(true));
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.m_trxName);
            for (int i2 = 0; i2 < this.m_IDs.length; ++i2) {
                Object oo = this.m_IDs[i2];
                if (oo instanceof Integer) {
                    pstmt.setInt(i2 + 1, (Integer)this.m_IDs[i2]);
                    continue;
                }
                pstmt.setString(i2 + 1, this.m_IDs[i2].toString());
            }
            rs = pstmt.executeQuery();
            if (rs.next()) {
                success = this.load(rs);
            } else {
                this.log.log(Level.SEVERE, "NO Data found for " + this.get_WhereClause(true), new Exception());
                this.m_IDs = new Object[]{I_ZERO};
                success = false;
            }
            this.m_createNew = false;
            this.m_newValues = new Object[size];
        }
        catch (Exception e) {
            try {
                String msg = "";
                if (this.m_trxName != null) {
                    msg = "[" + this.m_trxName + "] - ";
                }
                msg = msg + this.get_WhereClause(true) + ", SQL=" + sql.toString();
                success = false;
                this.m_IDs = new Object[]{I_ZERO};
                this.log.log(Level.SEVERE, msg, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.loadComplete(success);
        return success;
    }

    protected boolean load(ResultSet rs) {
        int size = this.get_ColumnCount();
        boolean success = true;
        int index = 0;
        this.log.finest("(rs)");
        for (index = 0; index < size; ++index) {
            String columnName = this.p_info.getColumnName(index);
            Class<?> clazz = this.p_info.getColumnClass(index);
            int dt = this.p_info.getColumnDisplayType(index);
            try {
                this.m_oldValues[index] = clazz == Integer.class ? this.decrypt(index, new Integer(rs.getInt(columnName))) : (clazz == BigDecimal.class ? this.decrypt(index, rs.getBigDecimal(columnName)) : (clazz == Boolean.class ? new Boolean("Y".equals(this.decrypt(index, rs.getString(columnName)))) : (clazz == Timestamp.class ? this.decrypt(index, rs.getTimestamp(columnName)) : (DisplayType.isLOB(dt) ? this.get_LOB(rs.getObject(columnName)) : (clazz == String.class ? this.decrypt(index, rs.getString(columnName)) : this.loadSpecial(rs, index))))));
                if (rs.wasNull() && this.m_oldValues[index] != null) {
                    this.m_oldValues[index] = null;
                }
                if (!CLogMgt.isLevelAll()) continue;
                this.log.finest(String.valueOf(index) + ": " + this.p_info.getColumnName(index) + "(" + this.p_info.getColumnClass(index) + ") = " + this.m_oldValues[index]);
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (this.p_info.isVirtualColumn(index)) {
                    this.log.log(Level.FINER, "Virtual Column not loaded: " + columnName);
                    continue;
                }
                this.log.log(Level.SEVERE, "(rs) - " + String.valueOf(index) + ": " + this.p_info.getTableName() + "." + this.p_info.getColumnName(index) + " (" + this.p_info.getColumnClass(index) + ") - " + e);
                success = false;
            }
        }
        this.m_createNew = false;
        this.setKeyInfo();
        this.loadComplete(success);
        return success;
    }

    protected boolean load(HashMap<String, String> hmIn) {
        int size = this.get_ColumnCount();
        boolean success = true;
        int index = 0;
        this.log.finest("(hm)");
        for (index = 0; index < size; ++index) {
            String columnName = this.p_info.getColumnName(index);
            String value = hmIn.get(columnName);
            if (value == null) continue;
            Class<?> clazz = this.p_info.getColumnClass(index);
            int dt = this.p_info.getColumnDisplayType(index);
            try {
                this.m_oldValues[index] = clazz == Integer.class ? new Integer(value) : (clazz == BigDecimal.class ? new BigDecimal(value) : (clazz == Boolean.class ? new Boolean("Y".equals(value)) : (clazz == Timestamp.class ? Timestamp.valueOf(value) : (DisplayType.isLOB(dt) ? null : (clazz == String.class ? value : null)))));
                if (!CLogMgt.isLevelAll()) continue;
                this.log.finest(String.valueOf(index) + ": " + this.p_info.getColumnName(index) + "(" + this.p_info.getColumnClass(index) + ") = " + this.m_oldValues[index]);
                continue;
            }
            catch (Exception e) {
                if (this.p_info.isVirtualColumn(index)) {
                    this.log.log(Level.FINER, "Virtual Column not loaded: " + columnName);
                    continue;
                }
                this.log.log(Level.SEVERE, "(ht) - " + String.valueOf(index) + ": " + this.p_info.getTableName() + "." + this.p_info.getColumnName(index) + " (" + this.p_info.getColumnClass(index) + ") - " + e);
                success = false;
            }
        }
        this.m_createNew = false;
        this.setStandardDefaults();
        this.setKeyInfo();
        this.loadComplete(success);
        return success;
    }

    protected HashMap<String, String> get_HashMap() {
        HashMap<String, String> hmOut = new HashMap<String, String>();
        int size = this.get_ColumnCount();
        for (int i2 = 0; i2 < size; ++i2) {
            Object value = this.get_Value(i2);
            if (value == null || this.p_info.isVirtualColumn(i2)) continue;
            int dt = this.p_info.getColumnDisplayType(i2);
            Class<?> c = this.p_info.getColumnClass(i2);
            String stringValue = null;
            if (c != Object.class && value != null && !value.equals(Null.NULL)) {
                if (value instanceof Integer || value instanceof BigDecimal) {
                    stringValue = value.toString();
                } else if (c == Boolean.class) {
                    boolean bValue = false;
                    bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                    stringValue = bValue ? "Y" : "N";
                } else if (value instanceof Timestamp) {
                    stringValue = value.toString();
                } else if (c == String.class) {
                    stringValue = (String)value;
                } else if (DisplayType.isLOB(dt)) {
                    // empty if block
                }
            }
            if (stringValue == null) continue;
            hmOut.put(this.p_info.getColumnName(i2), stringValue);
        }
        if (this.m_custom != null) {
            for (String column : this.m_custom.keySet()) {
                String value = this.m_custom.get(column);
                if (value == null) continue;
                hmOut.put(column, value);
            }
            this.m_custom = null;
        }
        return hmOut;
    }

    protected Object loadSpecial(ResultSet rs, int index) throws SQLException {
        this.log.finest("(NOP) - " + this.p_info.getColumnName(index));
        return null;
    }

    protected void loadComplete(boolean success) {
    }

    protected void loadDefaults() {
        this.setStandardDefaults();
    }

    protected void setStandardDefaults() {
        int size = this.get_ColumnCount();
        for (int i2 = 0; i2 < size; ++i2) {
            if (this.p_info.isVirtualColumn(i2)) continue;
            String colName = this.p_info.getColumnName(i2);
            if (colName.endsWith("tedBy")) {
                this.m_newValues[i2] = new Integer(Env.getContextAsInt(this.p_ctx, "#AD_User_ID"));
                continue;
            }
            if (colName.equals("Created") || colName.equals("Updated")) {
                this.m_newValues[i2] = new Timestamp(System.currentTimeMillis());
                continue;
            }
            if (colName.equals(this.p_info.getTableName() + "_ID")) {
                this.m_newValues[i2] = I_ZERO;
                continue;
            }
            if (colName.equals("IsActive")) {
                this.m_newValues[i2] = new Boolean(true);
                continue;
            }
            if (colName.equals("AD_Client_ID")) {
                this.m_newValues[i2] = new Integer(Env.getAD_Client_ID(this.p_ctx));
                continue;
            }
            if (colName.equals("AD_Org_ID")) {
                this.m_newValues[i2] = new Integer(Env.getAD_Org_ID(this.p_ctx));
                continue;
            }
            if (colName.equals("Processed")) {
                this.m_newValues[i2] = new Boolean(false);
                continue;
            }
            if (colName.equals("Processing")) {
                this.m_newValues[i2] = new Boolean(false);
                continue;
            }
            if (!colName.equals("Posted")) continue;
            this.m_newValues[i2] = new Boolean(false);
        }
    }

    private void setKeyInfo() {
        for (int i2 = 0; i2 < this.p_info.getColumnCount(); ++i2) {
            if (!this.p_info.isKey(i2)) continue;
            String ColumnName = this.p_info.getColumnName(i2);
            this.m_KeyColumns = new String[]{ColumnName};
            if (this.p_info.getColumnName(i2).endsWith("_ID")) {
                Integer ii = (Integer)this.get_Value(i2);
                this.m_IDs = ii == null ? new Object[]{I_ZERO} : new Object[]{ii};
                this.log.finest("(PK) " + ColumnName + "=" + ii);
            } else {
                Object oo = this.get_Value(i2);
                this.m_IDs = oo == null ? new Object[]{null} : new Object[]{oo};
                this.log.finest("(PK) " + ColumnName + "=" + oo);
            }
            return;
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i3 = 0; i3 < this.p_info.getColumnCount(); ++i3) {
            if (!this.p_info.isColumnParent(i3)) continue;
            columnNames.add(this.p_info.getColumnName(i3));
        }
        int size = columnNames.size();
        if (size == 0) {
            throw new IllegalStateException("No PK nor FK - " + this.p_info.getTableName());
        }
        this.m_IDs = new Object[size];
        this.m_KeyColumns = new String[size];
        for (int i4 = 0; i4 < size; ++i4) {
            this.m_KeyColumns[i4] = (String)columnNames.get(i4);
            if (this.m_KeyColumns[i4].endsWith("_ID")) {
                Integer ii = null;
                try {
                    ii = (Integer)this.get_Value(this.m_KeyColumns[i4]);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "", e);
                }
                if (ii != null) {
                    this.m_IDs[i4] = ii;
                }
            } else {
                this.m_IDs[i4] = this.get_Value(this.m_KeyColumns[i4]);
            }
            this.log.finest("(FK) " + this.m_KeyColumns[i4] + "=" + this.m_IDs[i4]);
        }
    }

    protected boolean isMandatoryOK() {
        int size = this.get_ColumnCount();
        for (int i2 = 0; i2 < size; ++i2) {
            if (!this.p_info.isColumnMandatory(i2) || this.p_info.isVirtualColumn(i2) || this.get_Value(i2) != null && !this.get_Value(i2).equals(Null.NULL)) continue;
            this.log.info(this.p_info.getColumnName(i2));
            return false;
        }
        return true;
    }

    protected final void setAD_Client_ID(int AD_Client_ID) {
        this.set_ValueNoCheck("AD_Client_ID", new Integer(AD_Client_ID));
    }

    public final int getAD_Client_ID() {
        Integer ii = (Integer)this.get_Value("AD_Client_ID");
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    public final void setAD_Org_ID(int AD_Org_ID) {
        this.set_ValueNoCheck("AD_Org_ID", new Integer(AD_Org_ID));
    }

    public int getAD_Org_ID() {
        Integer ii = (Integer)this.get_Value("AD_Org_ID");
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    protected void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        if (AD_Client_ID != this.getAD_Client_ID()) {
            this.setAD_Client_ID(AD_Client_ID);
        }
        if (AD_Org_ID != this.getAD_Org_ID()) {
            this.setAD_Org_ID(AD_Org_ID);
        }
    }

    protected void setClientOrg(PO po) {
        this.setClientOrg(po.getAD_Client_ID(), po.getAD_Org_ID());
    }

    public final void setIsActive(boolean active) {
        this.set_Value("IsActive", (Object)new Boolean(active));
    }

    public final boolean isActive() {
        Boolean bb = (Boolean)this.get_Value("IsActive");
        if (bb != null) {
            return bb;
        }
        return false;
    }

    public final Timestamp getCreated() {
        return (Timestamp)this.get_Value("Created");
    }

    public final Timestamp getUpdated() {
        return (Timestamp)this.get_Value("Updated");
    }

    public final int getCreatedBy() {
        Integer ii = (Integer)this.get_Value("CreatedBy");
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    public final int getUpdatedBy() {
        Integer ii = (Integer)this.get_Value("UpdatedBy");
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    protected final void setUpdatedBy(int AD_User_ID) {
        this.set_ValueNoCheck("UpdatedBy", new Integer(AD_User_ID));
    }

    public String get_Translation(String columnName, String AD_Language) {
        if (columnName == null || AD_Language == null || this.m_IDs.length > 1 || this.m_IDs[0].equals(I_ZERO) || !(this.m_IDs[0] instanceof Integer)) {
            throw new IllegalArgumentException("ColumnName=" + columnName + ", AD_Language=" + AD_Language + ", ID.length=" + this.m_IDs.length + ", ID=" + this.m_IDs[0]);
        }
        String retValue = null;
        if (!Env.isBaseLanguage(AD_Language, this.get_TableName()) && this.p_info.isColumnTranslated(this.p_info.getColumnIndex(columnName))) {
            int ID = (Integer)this.m_IDs[0];
            StringBuffer sql = new StringBuffer("SELECT ").append(columnName).append(" FROM ").append(this.p_info.getTableName()).append("_Trl WHERE ").append(this.m_KeyColumns[0]).append("=?").append(" AND AD_Language=?");
            retValue = DB.getSQLValueString(this.get_TrxName(), sql.toString(), ID, AD_Language);
        }
        if (retValue == null) {
            Object val = this.get_Value(columnName);
            retValue = val != null ? val.toString() : null;
        }
        return retValue;
    }

    public String get_Translation(String columnName) {
        return this.get_Translation(columnName, Env.getAD_Language(this.getCtx()));
    }

    public boolean is_new() {
        if (this.m_createNew) {
            return true;
        }
        for (int i2 = 0; i2 < this.m_IDs.length; ++i2) {
            if (this.m_IDs[i2].equals(I_ZERO) || this.m_IDs[i2] == Null.NULL) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        CLogger.resetLast();
        boolean newRecord = this.is_new();
        if (!newRecord && !this.is_Changed()) {
            this.log.fine("Nothing changed - " + this.p_info.getTableName());
            return true;
        }
        if (this.getAD_Org_ID() == 0 && (this.get_AccessLevel() == 1 || this.get_AccessLevel() == 3 && MClientShare.isOrgLevelOnly(this.getAD_Client_ID(), this.get_Table_ID()))) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "AD_Org_ID"));
            return false;
        }
        if (this.getAD_Org_ID() != 0) {
            boolean reset;
            boolean bl = reset = this.get_AccessLevel() == 4;
            if (!reset && MClientShare.isClientLevelOnly(this.getAD_Client_ID(), this.get_Table_ID())) {
                boolean bl2 = reset = this.get_AccessLevel() == 2 || this.get_AccessLevel() == 6 || this.get_AccessLevel() == 7 || this.get_AccessLevel() == 3;
            }
            if (reset) {
                this.log.warning("Set Org to 0");
                this.setAD_Org_ID(0);
            }
        }
        Trx localTrx = null;
        Trx trx = null;
        Savepoint savepoint = null;
        if (this.m_trxName == null) {
            this.m_trxName = Trx.createTrxName("POSave");
            localTrx = Trx.get(this.m_trxName, true);
        } else {
            trx = Trx.get(this.m_trxName, false);
            if (trx == null) {
                trx = Trx.get(this.m_trxName, true);
                this.log.severe("Transaction closed or never opened (" + this.m_trxName + ") => starting now --> " + this.toString());
            }
        }
        try {
            if (localTrx == null) {
                savepoint = trx.setSavepoint(null);
            }
            if (!this.beforeSave(newRecord)) {
                this.log.warning("beforeSave failed - " + this.toString());
                if (localTrx != null) {
                    localTrx.rollback();
                    localTrx.close();
                    this.m_trxName = null;
                } else {
                    trx.rollback(savepoint);
                    savepoint = null;
                }
                return false;
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "beforeSave - " + this.toString(), e);
            this.log.saveError("Error", e, false);
            if (localTrx != null) {
                localTrx.rollback();
                localTrx.close();
                this.m_trxName = null;
            } else if (savepoint != null) {
                try {
                    trx.rollback(savepoint);
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                savepoint = null;
            }
            return false;
        }
        try {
            boolean b2;
            String errorMsg = ModelValidationEngine.get().fireModelChange(this, newRecord ? 1 : 2);
            if (errorMsg != null) {
                this.log.warning("Validation failed - " + errorMsg);
                this.log.saveError("Error", errorMsg);
                if (localTrx != null) {
                    localTrx.rollback();
                    this.m_trxName = null;
                } else {
                    trx.rollback(savepoint);
                }
                boolean e1 = false;
                return e1;
            }
            if (newRecord) {
                b2 = this.saveNew();
                if (b2) {
                    if (localTrx != null) {
                        boolean e = localTrx.commit();
                        return e;
                    }
                    boolean e = b2;
                    return e;
                }
                if (localTrx != null) {
                    localTrx.rollback();
                } else {
                    trx.rollback(savepoint);
                }
                boolean e = b2;
                return e;
            }
            b2 = this.saveUpdate();
            if (b2) {
                if (localTrx != null) {
                    boolean e = localTrx.commit();
                    return e;
                }
                boolean e = b2;
                return e;
            }
            if (localTrx != null) {
                localTrx.rollback();
            } else {
                trx.rollback(savepoint);
            }
            boolean e = b2;
            return e;
        }
        catch (SQLException e) {
            this.log.log(Level.WARNING, "afterSave - " + this.toString(), e);
            if (localTrx != null) {
                localTrx.rollback();
            } else if (savepoint != null) {
                try {
                    trx.rollback(savepoint);
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                savepoint = null;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (localTrx != null) {
                localTrx.close();
                this.m_trxName = null;
            } else {
                if (savepoint != null) {
                    try {
                        trx.releaseSavepoint(savepoint);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                savepoint = null;
                trx = null;
            }
        }
    }

    public void saveEx() throws AdempiereException {
        if (!this.save()) {
            String msg = null;
            ValueNamePair err = CLogger.retrieveError();
            if (err != null) {
                msg = err.getName();
            }
            if (msg == null || msg.length() == 0) {
                msg = "SaveError";
            }
            throw new AdempiereException(msg);
        }
    }

    private boolean saveFinish(boolean newRecord, boolean success) {
        if (success) {
            if (newRecord) {
                this.insertTranslations();
            } else {
                this.updateTranslations();
            }
        }
        try {
            success = this.afterSave(newRecord, success);
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "afterSave", e);
            this.log.saveError("Error", e, false);
            success = false;
        }
        if (success) {
            String errorMsg = ModelValidationEngine.get().fireModelChange(this, newRecord ? (this.isReplication() ? 7 : 4) : (this.isReplication() ? 8 : 5));
            this.setReplication(false);
            if (errorMsg != null) {
                this.log.saveError("Error", errorMsg);
                success = false;
            }
        }
        if (success) {
            if (s_docWFMgr == null) {
                try {
                    Class.forName("org.compiere.wf.DocWorkflowManager");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (s_docWFMgr != null) {
                s_docWFMgr.process(this, this.p_info.getAD_Table_ID());
            }
            int size = this.p_info.getColumnCount();
            for (int i2 = 0; i2 < size; ++i2) {
                if (this.m_newValues[i2] == null) continue;
                this.m_oldValues[i2] = this.m_newValues[i2] == Null.NULL ? null : this.m_newValues[i2];
            }
            this.m_newValues = new Object[size];
        }
        this.m_createNew = false;
        if (!newRecord) {
            CacheMgt.get().reset(this.p_info.getTableName());
        }
        return success;
    }

    public boolean save(String trxName) {
        this.set_TrxName(trxName);
        return this.save();
    }

    public void saveReplica(boolean isFromReplication) throws AdempiereException {
        this.setReplication(isFromReplication);
        this.saveEx();
    }

    public void saveEx(String trxName) throws AdempiereException {
        this.set_TrxName(trxName);
        this.saveEx();
    }

    public boolean is_Changed() {
        int size = this.get_ColumnCount();
        for (int i2 = 0; i2 < size; ++i2) {
            if (!this.is_ValueChanged(i2)) continue;
            return true;
        }
        return this.m_custom != null && this.m_custom.size() > 0;
    }

    protected boolean beforeSave(boolean newRecord) {
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        return success;
    }

    protected boolean saveUpdate() {
        String where = this.get_WhereClause(true);
        boolean changes = false;
        StringBuffer sql = new StringBuffer("UPDATE ");
        sql.append(this.p_info.getTableName()).append(" SET ");
        boolean updated = false;
        boolean updatedBy = false;
        this.lobReset();
        MSession session = MSession.get(this.p_ctx, false);
        if (session == null) {
            this.log.fine("No Session found");
        }
        int AD_ChangeLog_ID = 0;
        int size = this.get_ColumnCount();
        for (int i2 = 0; i2 < size; ++i2) {
            MChangeLog cLog;
            Object value = this.m_newValues[i2];
            if (value == null || this.p_info.isVirtualColumn(i2)) continue;
            Class<?> c = this.p_info.getColumnClass(i2);
            int dt = this.p_info.getColumnDisplayType(i2);
            String columnName = this.p_info.getColumnName(i2);
            if (columnName.equals("UpdatedBy")) {
                if (updatedBy) continue;
                updatedBy = true;
            } else if (columnName.equals("Updated")) {
                if (updated) continue;
                updated = true;
            }
            if (DisplayType.isLOB(dt)) {
                this.lobAdd(value, i2, dt);
                if (changes || updatedBy) continue;
                int AD_User_ID = Env.getContextAsInt(this.p_ctx, "#AD_User_ID");
                this.set_ValueNoCheck("UpdatedBy", new Integer(AD_User_ID));
                sql.append("UpdatedBy=").append(AD_User_ID);
                changes = true;
                updatedBy = true;
                continue;
            }
            if (columnName.equals("DocumentNo")) {
                String strValue = (String)value;
                if (strValue.startsWith("<") && strValue.endsWith(">")) {
                    value = null;
                    int AD_Client_ID = this.getAD_Client_ID();
                    int index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
                    if (index == -1) {
                        index = this.p_info.getColumnIndex("C_DocType_ID");
                    }
                    if (index != -1) {
                        value = DB.getDocumentNo(this.get_ValueAsInt(index), this.m_trxName, false, this);
                    }
                    if (value == null) {
                        value = DB.getDocumentNo(AD_Client_ID, this.p_info.getTableName(), this.m_trxName, this);
                    }
                } else {
                    this.log.warning("DocumentNo updated: " + this.m_oldValues[i2] + " -> " + value);
                }
            }
            if (changes) {
                sql.append(", ");
            }
            changes = true;
            sql.append(columnName).append("=");
            if (value == Null.NULL) {
                sql.append("NULL");
            } else if (value instanceof Integer || value instanceof BigDecimal) {
                sql.append(this.encrypt(i2, value));
            } else if (c == Boolean.class) {
                boolean bValue = false;
                bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                sql.append(this.encrypt(i2, bValue ? "'Y'" : "'N'"));
            } else if (value instanceof Timestamp) {
                sql.append(DB.TO_DATE((Timestamp)this.encrypt(i2, value), this.p_info.getColumnDisplayType(i2) == 15));
            } else if (value.toString().length() == 0) {
                sql.append(DB.TO_STRING(value.toString()));
            } else {
                sql.append(this.encrypt(i2, DB.TO_STRING(value.toString())));
            }
            if (session == null || this.m_IDs.length != 1 || !this.p_info.isAllowLogging(i2) || this.p_info.isEncrypted(i2) || this.p_info.isVirtualColumn(i2) || "Password".equals(columnName)) continue;
            Object oldV = this.m_oldValues[i2];
            Object newV = value;
            if (oldV != null && oldV == Null.NULL) {
                oldV = null;
            }
            if (newV != null && newV == Null.NULL) {
                newV = null;
            }
            if ((cLog = session.changeLog(this.m_trxName, AD_ChangeLog_ID, this.p_info.getAD_Table_ID(), this.p_info.getColumn((int)i2).AD_Column_ID, this.get_ID(), this.getAD_Client_ID(), this.getAD_Org_ID(), oldV, newV, ENTITYTYPE_UserMaintained)) == null) continue;
            AD_ChangeLog_ID = cLog.getAD_ChangeLog_ID();
        }
        if (this.m_custom != null) {
            Iterator<String> it = this.m_custom.keySet().iterator();
            while (it.hasNext()) {
                if (changes) {
                    sql.append(", ");
                }
                changes = true;
                String column = it.next();
                String value = this.m_custom.get(column);
                int index = this.p_info.getColumnIndex(column);
                sql.append(column).append("=").append(this.encrypt(index, value));
            }
            this.m_custom = null;
        }
        if (changes) {
            boolean ok;
            if (this.m_trxName == null) {
                this.log.fine(this.p_info.getTableName() + "." + where);
            } else {
                this.log.fine("[" + this.m_trxName + "] - " + this.p_info.getTableName() + "." + where);
            }
            if (!updated) {
                Timestamp now = new Timestamp(System.currentTimeMillis());
                this.set_ValueNoCheck("Updated", now);
                sql.append(",Updated=").append(DB.TO_DATE(now, false));
            }
            if (!updatedBy) {
                int AD_User_ID = Env.getContextAsInt(this.p_ctx, "#AD_User_ID");
                this.set_ValueNoCheck("UpdatedBy", new Integer(AD_User_ID));
                sql.append(",UpdatedBy=").append(AD_User_ID);
            }
            sql.append(" WHERE ").append(where);
            this.log.finest(sql.toString());
            int no = 0;
            no = this.isUseTimeoutForUpdate() ? DB.executeUpdateEx(sql.toString(), this.m_trxName, 10) : DB.executeUpdate(sql.toString(), this.m_trxName);
            boolean bl = ok = no == 1;
            if (ok) {
                ok = this.lobSave();
            } else if (this.m_trxName == null) {
                this.log.log(Level.WARNING, "#" + no + " - " + this.p_info.getTableName() + "." + where);
            } else {
                this.log.log(Level.WARNING, "#" + no + " - [" + this.m_trxName + "] - " + this.p_info.getTableName() + "." + where);
            }
            return this.saveFinish(false, ok);
        }
        return this.saveFinish(false, true);
    }

    private boolean isUseTimeoutForUpdate() {
        return "true".equalsIgnoreCase(System.getProperty(USE_TIMEOUT_FOR_UPDATE, "false")) && DB.getDatabase().isQueryTimeoutSupported();
    }

    private boolean saveNew() {
        boolean ok;
        String value;
        if (this.m_IDs.length == 1 && this.p_info.hasKeyColumn() && this.m_KeyColumns[0].endsWith("_ID")) {
            int no = this.saveNew_getID();
            if (no <= 0) {
                no = DB.getNextID(this.getAD_Client_ID(), this.p_info.getTableName(), this.m_trxName);
            }
            if (this.isReplication() && this.get_ID() > 0) {
                no = this.get_ID();
            }
            if (no <= 0) {
                this.log.severe("No NextID (" + no + ")");
                return this.saveFinish(true, false);
            }
            this.m_IDs[0] = new Integer(no);
            this.set_ValueNoCheck(this.m_KeyColumns[0], this.m_IDs[0]);
        }
        if (this.m_trxName == null) {
            this.log.fine(this.p_info.getTableName() + " - " + this.get_WhereClause(true));
        } else {
            this.log.fine("[" + this.m_trxName + "] - " + this.p_info.getTableName() + " - " + this.get_WhereClause(true));
        }
        String columnName = "DocumentNo";
        int index = this.p_info.getColumnIndex(columnName);
        if (index != -1) {
            value = (String)this.get_Value(index);
            if (value != null && value.startsWith("<") && value.endsWith(">")) {
                value = null;
            }
            if (value == null || value.length() == 0) {
                int dt = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
                if (dt == -1) {
                    dt = this.p_info.getColumnIndex("C_DocType_ID");
                }
                if (dt != -1) {
                    value = DB.getDocumentNo(this.get_ValueAsInt(dt), this.m_trxName, false, this);
                }
                if (value == null) {
                    value = DB.getDocumentNo(this.getAD_Client_ID(), this.p_info.getTableName(), this.m_trxName, this);
                }
                this.set_ValueNoCheck(columnName, value);
            }
        }
        if ((index = this.p_info.getColumnIndex(columnName = "Value")) != -1 && ((value = (String)this.get_Value(index)) == null || value.length() == 0)) {
            value = DB.getDocumentNo(this.getAD_Client_ID(), this.p_info.getTableName(), this.m_trxName, this);
            this.set_ValueNoCheck(columnName, value);
        }
        this.lobReset();
        MSession session = MSession.get(this.p_ctx, false);
        if (session == null) {
            this.log.fine("No Session found");
        }
        int AD_ChangeLog_ID = 0;
        StringBuffer sqlInsert = new StringBuffer("INSERT INTO ");
        sqlInsert.append(this.p_info.getTableName()).append(" (");
        StringBuffer sqlValues = new StringBuffer(") VALUES (");
        int size = this.get_ColumnCount();
        boolean doComma = false;
        for (int i2 = 0; i2 < size; ++i2) {
            MChangeLog cLog;
            Object value2 = this.get_Value(i2);
            if (value2 == null || this.p_info.isVirtualColumn(i2)) continue;
            int dt = this.p_info.getColumnDisplayType(i2);
            if (DisplayType.isLOB(dt)) {
                this.lobAdd(value2, i2, dt);
                continue;
            }
            if (doComma) {
                sqlInsert.append(",");
                sqlValues.append(",");
            } else {
                doComma = true;
            }
            sqlInsert.append(this.p_info.getColumnName(i2));
            Class<?> c = this.p_info.getColumnClass(i2);
            try {
                if (c == Object.class) {
                    sqlValues.append(this.saveNewSpecial(value2, i2));
                } else if (value2 == null || value2.equals(Null.NULL)) {
                    sqlValues.append("NULL");
                } else if (value2 instanceof Integer || value2 instanceof BigDecimal) {
                    sqlValues.append(this.encrypt(i2, value2));
                } else if (c == Boolean.class) {
                    boolean bValue = false;
                    bValue = value2 instanceof Boolean ? ((Boolean)value2).booleanValue() : "Y".equals(value2);
                    sqlValues.append(this.encrypt(i2, bValue ? "'Y'" : "'N'"));
                } else if (value2 instanceof Timestamp) {
                    sqlValues.append(DB.TO_DATE((Timestamp)this.encrypt(i2, value2), this.p_info.getColumnDisplayType(i2) == 15));
                } else if (c == String.class) {
                    sqlValues.append(this.encrypt(i2, DB.TO_STRING((String)value2)));
                } else if (DisplayType.isLOB(dt)) {
                    sqlValues.append("null");
                } else {
                    sqlValues.append(this.saveNewSpecial(value2, i2));
                }
            }
            catch (Exception e) {
                String msg = "";
                if (this.m_trxName != null) {
                    msg = "[" + this.m_trxName + "] - ";
                }
                msg = msg + this.p_info.toString(i2) + " - Value=" + value2 + "(" + (value2 == null ? "null" : value2.getClass().getName()) + ")";
                this.log.log(Level.SEVERE, msg, e);
                throw new DBException(e);
            }
            String insertLog = MSysConfig.getValue("SYSTEM_INSERT_CHANGELOG", "Y", this.getAD_Client_ID());
            if (session == null || this.m_IDs.length != 1 || !this.p_info.isAllowLogging(i2) || this.p_info.isEncrypted(i2) || this.p_info.isVirtualColumn(i2) || "Password".equals(columnName) || !insertLog.equalsIgnoreCase("Y") && (!insertLog.equalsIgnoreCase("K") || !this.p_info.getColumn((int)i2).IsKey) || (cLog = session.changeLog(this.m_trxName, AD_ChangeLog_ID, this.p_info.getAD_Table_ID(), this.p_info.getColumn((int)i2).AD_Column_ID, this.get_ID(), this.getAD_Client_ID(), this.getAD_Org_ID(), null, value2, "I")) == null) continue;
            AD_ChangeLog_ID = cLog.getAD_ChangeLog_ID();
        }
        if (this.m_custom != null) {
            for (String column : this.m_custom.keySet()) {
                index = this.p_info.getColumnIndex(column);
                String value3 = this.m_custom.get(column);
                if (doComma) {
                    sqlInsert.append(",");
                    sqlValues.append(",");
                } else {
                    doComma = true;
                }
                sqlInsert.append(column);
                sqlValues.append(this.encrypt(index, value3));
            }
            this.m_custom = null;
        }
        sqlInsert.append(sqlValues).append(")");
        int no = DB.executeUpdate(sqlInsert.toString(), this.m_trxName);
        boolean bl = ok = no == 1;
        if (ok) {
            ok = this.lobSave();
            if (!this.load(this.m_trxName)) {
                if (this.m_trxName == null) {
                    this.log.log(Level.SEVERE, "reloading");
                } else {
                    this.log.log(Level.SEVERE, "[" + this.m_trxName + "] - reloading");
                }
                ok = false;
            }
        } else {
            String msg = "Not inserted - ";
            msg = CLogMgt.isLevelFiner() ? msg + sqlInsert.toString() : msg + this.get_TableName();
            if (this.m_trxName == null) {
                this.log.log(Level.WARNING, msg);
            } else {
                this.log.log(Level.WARNING, "[" + this.m_trxName + "]" + msg);
            }
        }
        return this.saveFinish(true, ok);
    }

    protected int saveNew_getID() {
        if (this.get_ID() < 999999) {
            return this.get_ID();
        }
        return 0;
    }

    public String get_WhereClause(boolean withValues) {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < this.m_IDs.length; ++i2) {
            if (i2 != 0) {
                sb.append(" AND ");
            }
            sb.append(this.m_KeyColumns[i2]).append("=");
            if (withValues) {
                if (this.m_KeyColumns[i2].endsWith("_ID")) {
                    sb.append(this.m_IDs[i2]);
                    continue;
                }
                sb.append("'").append(this.m_IDs[i2]).append("'");
                continue;
            }
            sb.append("?");
        }
        return sb.toString();
    }

    protected String saveNewSpecial(Object value, int index) {
        String colName = this.p_info.getColumnName(index);
        String colClass = this.p_info.getColumnClass(index).toString();
        String colValue = value == null ? "null" : value.getClass().toString();
        this.log.log(Level.SEVERE, "Unknown class for column " + colName + " (" + colClass + ") - Value=" + colValue);
        if (value == null) {
            return "NULL";
        }
        return value.toString();
    }

    private Object encrypt(int index, Object xx) {
        if (xx == null) {
            return null;
        }
        if (index != -1 && this.p_info.isEncrypted(index)) {
            return SecureEngine.encrypt(xx);
        }
        return xx;
    }

    private Object decrypt(int index, Object yy) {
        if (yy == null) {
            return null;
        }
        if (index != -1 && this.p_info.isEncrypted(index)) {
            return SecureEngine.decrypt(yy);
        }
        return yy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(boolean force) {
        Boolean processed;
        int iProcessed;
        CLogger.resetLast();
        if (this.is_new()) {
            return true;
        }
        int AD_Table_ID = this.p_info.getAD_Table_ID();
        int Record_ID = this.get_ID();
        if (!force && (iProcessed = this.get_ColumnIndex("Processed")) != -1 && (processed = (Boolean)this.get_Value(iProcessed)) != null && processed.booleanValue()) {
            this.log.warning("Record processed");
            this.log.saveError("Processed", "Processed", false);
            return false;
        }
        Trx localTrx = null;
        boolean success = false;
        try {
            String localTrxName = this.m_trxName;
            if (localTrxName == null) {
                localTrxName = Trx.createTrxName("POdel");
                localTrx = Trx.get(localTrxName, true);
                this.m_trxName = localTrxName;
            }
            try {
                if (!this.beforeDelete()) {
                    this.log.warning("beforeDelete failed");
                    boolean bl = false;
                    return bl;
                }
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "beforeDelete", e);
                this.log.saveError("Error", e, false);
                boolean bl = false;
                return bl;
            }
            String errorMsg = PO_Record.exists(AD_Table_ID, Record_ID, this.m_trxName);
            if (errorMsg != null) {
                this.log.saveError("CannotDelete", errorMsg);
                boolean bl = false;
                return bl;
            }
            errorMsg = ModelValidationEngine.get().fireModelChange(this, this.isReplication() ? 9 : 3);
            this.setReplication(false);
            if (errorMsg != null) {
                this.log.saveError("Error", errorMsg);
                boolean bl = false;
                return bl;
            }
            this.deleteTranslations(localTrxName);
            PO_Record.deleteCascade(AD_Table_ID, Record_ID, localTrxName);
            StringBuffer sql = new StringBuffer("DELETE FROM ").append(this.p_info.getTableName()).append(" WHERE ").append(this.get_WhereClause(true));
            int no = 0;
            no = this.isUseTimeoutForUpdate() ? DB.executeUpdateEx(sql.toString(), localTrxName, 10) : DB.executeUpdate(sql.toString(), localTrxName);
            success = no == 1;
            this.m_idOld = this.get_ID();
            if (!success) {
                this.log.warning("Not deleted");
                if (localTrx != null) {
                    localTrx.rollback();
                }
            } else if (success) {
                if (this.p_info.isChangeLog()) {
                    MSession session = MSession.get(this.p_ctx, false);
                    if (session == null) {
                        this.log.fine("No Session found");
                    } else if (this.m_IDs.length == 1) {
                        int AD_ChangeLog_ID = 0;
                        int size = this.get_ColumnCount();
                        for (int i2 = 0; i2 < size; ++i2) {
                            MChangeLog cLog;
                            Object value = this.m_oldValues[i2];
                            if (value == null || !this.p_info.isAllowLogging(i2) || this.p_info.isEncrypted(i2) || this.p_info.isVirtualColumn(i2) || "Password".equals(this.p_info.getColumnName(i2)) || (cLog = session.changeLog(this.m_trxName != null ? this.m_trxName : localTrxName, AD_ChangeLog_ID, AD_Table_ID, this.p_info.getColumn((int)i2).AD_Column_ID, Record_ID, this.getAD_Client_ID(), this.getAD_Org_ID(), value, null, ENTITYTYPE_Dictionary)) == null) continue;
                            AD_ChangeLog_ID = cLog.getAD_ChangeLog_ID();
                        }
                    }
                    this.m_IDs[0] = I_ZERO;
                    if (this.m_trxName == null) {
                        this.log.fine("complete");
                    } else {
                        this.log.fine("[" + this.m_trxName + "] - complete");
                    }
                    this.m_attachment = null;
                }
            } else {
                this.log.warning("Not deleted");
            }
            try {
                success = this.afterDelete(success);
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "afterDelete", e);
                this.log.saveError("Error", e, false);
                success = false;
            }
            if (success && (errorMsg = ModelValidationEngine.get().fireModelChange(this, 6)) != null) {
                this.log.saveError("Error", errorMsg);
                success = false;
            }
            if (!success) {
                if (localTrx != null) {
                    localTrx.rollback();
                }
            } else if (localTrx != null) {
                try {
                    localTrx.commit(true);
                }
                catch (SQLException e) {
                    this.log.saveError("Error", e);
                    success = false;
                }
            }
            if (success) {
                this.m_idOld = 0;
                int size = this.p_info.getColumnCount();
                this.m_oldValues = new Object[size];
                this.m_newValues = new Object[size];
                CacheMgt.get().reset(this.p_info.getTableName());
            }
        }
        finally {
            if (localTrx != null) {
                localTrx.close();
                this.m_trxName = null;
            }
        }
        return success;
    }

    public void deleteEx(boolean force) throws AdempiereException {
        if (!this.delete(force)) {
            String msg = null;
            ValueNamePair err = CLogger.retrieveError();
            if (err != null) {
                msg = err.getName();
            }
            if (msg == null || msg.length() == 0) {
                msg = "DeleteError";
            }
            throw new AdempiereException(msg);
        }
    }

    public boolean delete(boolean force, String trxName) {
        this.set_TrxName(trxName);
        return this.delete(force);
    }

    public void deleteEx(boolean force, String trxName) throws AdempiereException {
        this.set_TrxName(trxName);
        this.deleteEx(force);
    }

    protected boolean beforeDelete() {
        return true;
    }

    protected boolean afterDelete(boolean success) {
        return success;
    }

    private boolean insertTranslations() {
        if (this.m_IDs.length > 1 || this.m_IDs[0].equals(I_ZERO) || !this.p_info.isTranslated() || !(this.m_IDs[0] instanceof Integer)) {
            return true;
        }
        StringBuffer iColumns = new StringBuffer();
        StringBuffer sColumns = new StringBuffer();
        for (int i2 = 0; i2 < this.p_info.getColumnCount(); ++i2) {
            if (!this.p_info.isColumnTranslated(i2)) continue;
            iColumns.append(this.p_info.getColumnName(i2)).append(",");
            sColumns.append("t.").append(this.p_info.getColumnName(i2)).append(",");
        }
        if (iColumns.length() == 0) {
            return true;
        }
        String tableName = this.p_info.getTableName();
        String keyColumn = this.m_KeyColumns[0];
        StringBuffer sql = new StringBuffer("INSERT INTO ").append(tableName).append("_Trl (AD_Language,").append(keyColumn).append(", ").append(iColumns).append(" IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy) ").append("SELECT l.AD_Language,t.").append(keyColumn).append(", ").append(sColumns).append(" 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy ").append("FROM AD_Language l, ").append(tableName).append(" t ").append("WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.").append(keyColumn).append("=").append(this.get_ID()).append(" AND NOT EXISTS (SELECT * FROM ").append(tableName).append("_Trl tt WHERE tt.AD_Language=l.AD_Language AND tt.").append(keyColumn).append("=t.").append(keyColumn).append(")");
        int no = DB.executeUpdate(sql.toString(), this.m_trxName);
        this.log.fine("#" + no);
        return no > 0;
    }

    private boolean updateTranslations() {
        if (this.m_IDs.length > 1 || this.m_IDs[0].equals(I_ZERO) || !this.p_info.isTranslated() || !(this.m_IDs[0] instanceof Integer)) {
            return true;
        }
        boolean trlColumnChanged = false;
        for (int i2 = 0; i2 < this.p_info.getColumnCount(); ++i2) {
            if (!this.p_info.isColumnTranslated(i2) || !this.is_ValueChanged(this.p_info.getColumnName(i2))) continue;
            trlColumnChanged = true;
            break;
        }
        if (!trlColumnChanged) {
            return true;
        }
        MClient client = MClient.get(this.getCtx());
        String tableName = this.p_info.getTableName();
        String keyColumn = this.m_KeyColumns[0];
        StringBuffer sql = new StringBuffer("UPDATE ").append(tableName).append("_Trl SET ");
        if (client.isAutoUpdateTrl(tableName)) {
            for (int i3 = 0; i3 < this.p_info.getColumnCount(); ++i3) {
                if (!this.p_info.isColumnTranslated(i3)) continue;
                String columnName = this.p_info.getColumnName(i3);
                sql.append(columnName).append("=");
                Object value = this.get_Value(columnName);
                if (value == null) {
                    sql.append("NULL");
                } else if (value instanceof String) {
                    sql.append(DB.TO_STRING((String)value));
                } else if (value instanceof Boolean) {
                    sql.append((Boolean)value != false ? "'Y'" : "'N'");
                } else if (value instanceof Timestamp) {
                    sql.append(DB.TO_DATE((Timestamp)value));
                } else {
                    sql.append(value.toString());
                }
                sql.append(",");
            }
            sql.append("IsTranslated='Y'");
        } else {
            sql.append("IsTranslated='N'");
        }
        sql.append(" WHERE ").append(keyColumn).append("=").append(this.get_ID());
        int no = DB.executeUpdate(sql.toString(), this.m_trxName);
        this.log.fine("#" + no);
        return no >= 0;
    }

    private boolean deleteTranslations(String trxName) {
        if (this.m_IDs.length > 1 || this.m_IDs[0].equals(I_ZERO) || !this.p_info.isTranslated() || !(this.m_IDs[0] instanceof Integer)) {
            return true;
        }
        String tableName = this.p_info.getTableName();
        String keyColumn = this.m_KeyColumns[0];
        StringBuffer sql = new StringBuffer("DELETE  FROM  ").append(tableName).append("_Trl WHERE ").append(keyColumn).append("=").append(this.get_ID());
        int no = DB.executeUpdate(sql.toString(), trxName);
        this.log.fine("#" + no);
        return no >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean insert_Accounting(String acctTable, String acctBaseTable, String whereClause) {
        int i2;
        block11: {
            if (this.s_acctColumns != null && !acctTable.startsWith("C_BP_")) break block11;
            this.s_acctColumns = new ArrayList();
            String sql = "SELECT c.ColumnName FROM AD_Column c INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) WHERE t.TableName=? AND c.IsActive='Y' AND c.AD_Reference_ID=25 ORDER BY c.ColumnName";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setString(1, acctTable);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.s_acctColumns.add(rs.getString(1));
                }
            }
            catch (Exception e) {
                try {
                    this.log.log(Level.SEVERE, acctTable, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            if (this.s_acctColumns.size() == 0) {
                this.log.severe("No Columns for " + acctTable);
                return false;
            }
        }
        StringBuffer sb = new StringBuffer("INSERT INTO ").append(acctTable).append(" (").append(this.get_TableName()).append("_ID, C_AcctSchema_ID, AD_Client_ID,AD_Org_ID,IsActive, Created,CreatedBy,Updated,UpdatedBy ");
        for (i2 = 0; i2 < this.s_acctColumns.size(); ++i2) {
            sb.append(",").append(this.s_acctColumns.get(i2));
        }
        sb.append(") SELECT ").append(this.get_ID()).append(", p.C_AcctSchema_ID, p.AD_Client_ID,0,'Y', SysDate,").append(this.getUpdatedBy()).append(",SysDate,").append(this.getUpdatedBy());
        for (i2 = 0; i2 < this.s_acctColumns.size(); ++i2) {
            sb.append(",p.").append(this.s_acctColumns.get(i2));
        }
        sb.append(" FROM ").append(acctBaseTable).append(" p WHERE p.AD_Client_ID=").append(this.getAD_Client_ID());
        if (whereClause != null && whereClause.length() > 0) {
            sb.append(" AND ").append(whereClause);
        }
        sb.append(" AND NOT EXISTS (SELECT * FROM ").append(acctTable).append(" e WHERE e.C_AcctSchema_ID=p.C_AcctSchema_ID AND e.").append(this.get_TableName()).append("_ID=").append(this.get_ID()).append(")");
        int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
        if (no > 0) {
            this.log.fine("#" + no);
        } else {
            this.log.warning("#" + no + " - Table=" + acctTable + " from " + acctBaseTable);
        }
        return no > 0;
    }

    protected boolean delete_Accounting(String acctTable) {
        return true;
    }

    protected boolean insert_Tree(String treeType) {
        return this.insert_Tree(treeType, 0);
    }

    protected boolean insert_Tree(String treeType, int C_Element_ID) {
        StringBuffer sb = new StringBuffer("INSERT INTO ").append(MTree_Base.getNodeTableName(treeType)).append(" (AD_Client_ID,AD_Org_ID, IsActive,Created,CreatedBy,Updated,UpdatedBy, AD_Tree_ID, Node_ID, Parent_ID, SeqNo) SELECT t.AD_Client_ID, 0, 'Y', SysDate, " + this.getUpdatedBy() + ", SysDate, " + this.getUpdatedBy() + "," + "t.AD_Tree_ID, ").append(this.get_ID()).append(", 0, 999 FROM AD_Tree t WHERE t.AD_Client_ID=").append(this.getAD_Client_ID()).append(" AND t.IsActive='Y'");
        if (C_Element_ID != 0) {
            sb.append(" AND EXISTS (SELECT * FROM C_Element ae WHERE ae.C_Element_ID=").append(C_Element_ID).append(" AND t.AD_Tree_ID=ae.AD_Tree_ID)");
        } else {
            sb.append(" AND t.IsAllNodes='Y' AND t.TreeType='").append(treeType).append("'");
        }
        sb.append(" AND NOT EXISTS (SELECT * FROM " + MTree_Base.getNodeTableName(treeType) + " e " + "WHERE e.AD_Tree_ID=t.AD_Tree_ID AND Node_ID=").append(this.get_ID()).append(")");
        int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
        if (no > 0) {
            this.log.fine("#" + no + " - TreeType=" + treeType);
        } else {
            this.log.warning("#" + no + " - TreeType=" + treeType);
        }
        return no > 0;
    }

    protected boolean delete_Tree(String treeType) {
        StringBuffer sb;
        int no;
        int id = this.get_ID();
        if (id == 0) {
            id = this.get_IDOld();
        }
        if ((no = DB.executeUpdate((sb = new StringBuffer("DELETE FROM ").append(MTree_Base.getNodeTableName(treeType)).append(" n WHERE Node_ID=").append(id).append(" AND EXISTS (SELECT * FROM AD_Tree t WHERE t.AD_Tree_ID=n.AD_Tree_ID AND t.TreeType='").append(treeType).append("')")).toString(), this.get_TrxName())) > 0) {
            this.log.fine("#" + no + " - TreeType=" + treeType);
        } else {
            this.log.warning("#" + no + " - TreeType=" + treeType);
        }
        return no > 0;
    }

    public boolean lock() {
        int index = this.get_ProcessingIndex();
        if (index != -1) {
            this.m_newValues[index] = Boolean.TRUE;
            String sql = "UPDATE " + this.p_info.getTableName() + " SET Processing='Y' WHERE (Processing='N' OR Processing IS NULL) AND " + this.get_WhereClause(true);
            boolean success = false;
            if (this.isUseTimeoutForUpdate()) {
                success = DB.executeUpdateEx(sql, null, 10) == 1;
            } else {
                boolean bl = success = DB.executeUpdate(sql, null) == 1;
            }
            if (success) {
                this.log.fine("success");
            } else {
                this.log.log(Level.WARNING, "failed");
            }
            return success;
        }
        return false;
    }

    private int get_ProcessingIndex() {
        return this.p_info.getColumnIndex("Processing");
    }

    public boolean unlock(String trxName) {
        int index = this.get_ProcessingIndex();
        if (index != -1) {
            this.m_newValues[index] = Boolean.FALSE;
            String sql = "UPDATE " + this.p_info.getTableName() + " SET Processing='N' WHERE " + this.get_WhereClause(true);
            boolean success = false;
            if (this.isUseTimeoutForUpdate()) {
                success = DB.executeUpdateEx(sql, trxName, 10) == 1;
            } else {
                boolean bl = success = DB.executeUpdate(sql, trxName) == 1;
            }
            if (success) {
                this.log.fine("success" + (trxName == null ? "" : "[" + trxName + "]"));
            } else {
                this.log.log(Level.WARNING, "failed" + (trxName == null ? "" : " [" + trxName + "]"));
            }
            return success;
        }
        return true;
    }

    public void set_TrxName(String trxName) {
        this.m_trxName = trxName;
    }

    public String get_TrxName() {
        return this.m_trxName;
    }

    public MAttachment getAttachment() {
        return this.getAttachment(false);
    }

    public MAttachment getAttachment(boolean requery) {
        if (this.m_attachment == null || requery) {
            this.m_attachment = MAttachment.get(this.getCtx(), this.p_info.getAD_Table_ID(), this.get_ID());
        }
        return this.m_attachment;
    }

    public MAttachment createAttachment() {
        this.getAttachment(false);
        if (this.m_attachment == null) {
            this.m_attachment = new MAttachment(this.getCtx(), this.p_info.getAD_Table_ID(), this.get_ID(), null);
        }
        return this.m_attachment;
    }

    public boolean isAttachment(String extension) {
        this.getAttachment(false);
        if (this.m_attachment == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.m_attachment.getEntryCount(); ++i2) {
            if (!this.m_attachment.getEntryName(i2).endsWith(extension)) continue;
            this.log.fine("#" + i2 + ": " + this.m_attachment.getEntryName(i2));
            return true;
        }
        return false;
    }

    public byte[] getAttachmentData(String extension) {
        this.getAttachment(false);
        if (this.m_attachment == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.m_attachment.getEntryCount(); ++i2) {
            if (!this.m_attachment.getEntryName(i2).endsWith(extension)) continue;
            this.log.fine("#" + i2 + ": " + this.m_attachment.getEntryName(i2));
            return this.m_attachment.getEntryData(i2);
        }
        return null;
    }

    public boolean isPdfAttachment() {
        return this.isAttachment(".pdf");
    }

    public byte[] getPdfAttachment() {
        return this.getAttachmentData(".pdf");
    }

    public void dump() {
        if (CLogMgt.isLevelFinest()) {
            this.log.finer(this.get_WhereClause(true));
            for (int i2 = 0; i2 < this.get_ColumnCount(); ++i2) {
                this.dump(i2);
            }
        }
    }

    public void dump(int index) {
        StringBuffer sb = new StringBuffer(" ").append(index);
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.finest(sb.append(": invalid").toString());
            return;
        }
        sb.append(": ").append(this.get_ColumnName(index)).append(" = ").append(this.m_oldValues[index]).append(" (").append(this.m_newValues[index]).append(")");
        this.log.finest(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getAllIDs(String TableName, String WhereClause, String trxName) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringBuffer sql = new StringBuffer("SELECT ");
        sql.append(TableName).append("_ID FROM ").append(TableName);
        if (WhereClause != null && WhereClause.length() > 0) {
            sql.append(" WHERE ").append(WhereClause);
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), trxName);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new Integer(rs.getInt(1)));
            }
        }
        catch (SQLException e) {
            int[] nArray;
            try {
                s_log.log(Level.SEVERE, sql.toString(), e);
                nArray = null;
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return nArray;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        int[] retValue = new int[list.size()];
        for (int i2 = 0; i2 < retValue.length; ++i2) {
            retValue[i2] = (Integer)list.get(i2);
        }
        return retValue;
    }

    protected static String getFindParameter(String query) {
        if (query == null) {
            return null;
        }
        if (query.length() == 0 || query.equals("%")) {
            return null;
        }
        if (!query.endsWith("%")) {
            query = query + "%";
        }
        return query.toUpperCase();
    }

    private Object get_LOB(Object value) {
        this.log.fine("Value=" + value);
        if (value == null) {
            return null;
        }
        Object retValue = null;
        long length = -99L;
        try {
            if (value instanceof String || value instanceof byte[]) {
                retValue = value;
            } else if (value instanceof Clob) {
                Clob clob = (Clob)value;
                length = clob.length();
                retValue = clob.getSubString(1L, (int)length);
            } else if (value instanceof Blob) {
                Blob blob = (Blob)value;
                length = blob.length();
                int index = 1;
                if (blob.getClass().getName().equals("oracle.jdbc.rowset.OracleSerialBlob")) {
                    index = 0;
                }
                retValue = blob.getBytes(index, (int)length);
            } else {
                this.log.log(Level.SEVERE, "Unknown: " + value);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Length=" + length, e);
        }
        return retValue;
    }

    private void lobReset() {
        this.m_lobInfo = null;
    }

    private void lobAdd(Object value, int index, int displayType) {
        this.log.finest("Value=" + value);
        PO_LOB lob = new PO_LOB(this.p_info.getTableName(), this.get_ColumnName(index), this.get_WhereClause(true), displayType, value);
        if (this.m_lobInfo == null) {
            this.m_lobInfo = new ArrayList();
        }
        this.m_lobInfo.add(lob);
    }

    private boolean lobSave() {
        if (this.m_lobInfo == null) {
            return true;
        }
        boolean retValue = true;
        for (int i2 = 0; i2 < this.m_lobInfo.size(); ++i2) {
            PO_LOB lob = this.m_lobInfo.get(i2);
            if (lob.save(this.get_TrxName())) continue;
            retValue = false;
            break;
        }
        this.lobReset();
        return retValue;
    }

    public StringBuffer get_xmlString(StringBuffer xml) {
        if (xml == null) {
            xml = new StringBuffer();
        } else {
            xml.append(Env.NL);
        }
        try {
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            DOMSource source = new DOMSource(this.get_xmlDocument(xml.length() != 0));
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
            StringBuffer newXML = writer.getBuffer();
            if (xml.length() != 0) {
                int tagIndex = newXML.indexOf("?>");
                if (tagIndex != -1) {
                    xml.append(newXML.substring(tagIndex + 2));
                } else {
                    xml.append(newXML);
                }
            } else {
                xml.append(newXML);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
        }
        return xml;
    }

    public Document get_xmlDocument(boolean noComment) {
        Object value;
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            if (!noComment) {
                document.appendChild(document.createComment(Adempiere.getSummaryAscii()));
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
        }
        Element root = document.createElement(this.get_TableName());
        root.setAttribute(XML_ATTRIBUTE_AD_Table_ID, String.valueOf(this.get_Table_ID()));
        root.setAttribute(XML_ATTRIBUTE_Record_ID, String.valueOf(this.get_ID()));
        document.appendChild(root);
        int size = this.get_ColumnCount();
        for (int i2 = 0; i2 < size; ++i2) {
            if (this.p_info.isVirtualColumn(i2)) continue;
            Element col = document.createElement(this.p_info.getColumnName(i2));
            value = this.get_Value(i2);
            int dt = this.p_info.getColumnDisplayType(i2);
            Class<?> c = this.p_info.getColumnClass(i2);
            if (value != null && !value.equals(Null.NULL)) {
                if (c == Object.class) {
                    col.appendChild(document.createCDATASection(value.toString()));
                } else if (value instanceof Integer || value instanceof BigDecimal) {
                    col.appendChild(document.createTextNode(value.toString()));
                } else if (c == Boolean.class) {
                    boolean bValue = false;
                    bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                    col.appendChild(document.createTextNode(bValue ? "Y" : "N"));
                } else if (value instanceof Timestamp) {
                    col.appendChild(document.createTextNode(value.toString()));
                } else if (c == String.class) {
                    col.appendChild(document.createCDATASection((String)value));
                } else if (DisplayType.isLOB(dt)) {
                    col.appendChild(document.createCDATASection(value.toString()));
                } else {
                    col.appendChild(document.createCDATASection(value.toString()));
                }
            }
            root.appendChild(col);
        }
        if (this.m_custom != null) {
            for (String columnName : this.m_custom.keySet()) {
                value = this.m_custom.get(columnName);
                Element col = document.createElement(columnName);
                if (value != null) {
                    col.appendChild(document.createTextNode((String)value));
                }
                root.appendChild(col);
            }
            this.m_custom = null;
        }
        return document;
    }

    public void setDoc(Doc doc) {
        this.m_doc = doc;
    }

    public void setReplication(boolean isFromReplication) {
        this.m_isReplication = isFromReplication;
    }

    public boolean isReplication() {
        return this.m_isReplication;
    }

    public Doc getDoc() {
        return this.m_doc;
    }

    public static void set_TrxName(PO[] lines, String trxName) {
        for (PO line : lines) {
            line.set_TrxName(trxName);
        }
    }

    public int get_ValueAsInt(String columnName) {
        int idx = this.get_ColumnIndex(columnName);
        if (idx < 0) {
            return 0;
        }
        return this.get_ValueAsInt(idx);
    }

    public boolean get_ValueAsBoolean(String columnName) {
        Object oo = this.get_Value(columnName);
        if (oo != null) {
            if (oo instanceof Boolean) {
                return (Boolean)oo;
            }
            return "Y".equals(oo);
        }
        return false;
    }

    protected Object clone() throws CloneNotSupportedException {
        int i2;
        PO clone = (PO)super.clone();
        clone.m_trxName = null;
        if (this.m_custom != null) {
            clone.m_custom = new HashMap();
            clone.m_custom.putAll(this.m_custom);
        }
        if (this.m_newValues != null) {
            clone.m_newValues = new Object[this.m_newValues.length];
            for (i2 = 0; i2 < this.m_newValues.length; ++i2) {
                clone.m_newValues[i2] = this.m_newValues[i2];
            }
        }
        if (this.m_oldValues != null) {
            clone.m_oldValues = new Object[this.m_oldValues.length];
            for (i2 = 0; i2 < this.m_oldValues.length; ++i2) {
                clone.m_oldValues[i2] = this.m_oldValues[i2];
            }
        }
        if (this.m_IDs != null) {
            clone.m_IDs = new Object[this.m_IDs.length];
            for (i2 = 0; i2 < this.m_IDs.length; ++i2) {
                clone.m_IDs[i2] = this.m_IDs[i2];
            }
        }
        clone.p_ctx = Env.getCtx();
        clone.m_doc = null;
        clone.m_lobInfo = null;
        clone.m_attachment = null;
        clone.m_isReplication = false;
        return clone;
    }
}

