/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.script.ScriptEngine;
import org.adempiere.model.ImportValidator;
import org.adempiere.process.ImportProcess;
import org.compiere.acct.Fact;
import org.compiere.model.FactsValidator;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MRule;
import org.compiere.model.MSystem;
import org.compiere.model.MTable;
import org.compiere.model.MTableScriptValidator;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_ModelValidator;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ModelValidationEngine {
    private static ModelValidationEngine s_engine = null;
    private static String missingModelValidationMessage = null;
    private static CLogger log = CLogger.getCLogger(ModelValidationEngine.class);
    private ArrayList<ModelValidator> m_validators = new ArrayList();
    private Hashtable<String, ArrayList<ModelValidator>> m_modelChangeListeners = new Hashtable();
    private Hashtable<String, ArrayList<ModelValidator>> m_docValidateListeners = new Hashtable();
    private Hashtable<String, ArrayList<FactsValidator>> m_factsValidateListeners = new Hashtable();
    private Hashtable<String, ArrayList<ImportValidator>> m_impValidateListeners = new Hashtable();
    private ArrayList<ModelValidator> m_globalValidators = new ArrayList();

    public static synchronized ModelValidationEngine get() {
        if (s_engine == null) {
            s_engine = new ModelValidationEngine();
        }
        return s_engine;
    }

    private ModelValidationEngine() {
        MTable table2 = MTable.get(Env.getCtx(), X_AD_ModelValidator.Table_ID);
        Query query = table2.createQuery("IsActive='Y'", null);
        query.setOrderBy("SeqNo");
        try {
            List entityTypes = query.list();
            for (X_AD_ModelValidator entityType : entityTypes) {
                String className = entityType.getModelValidationClass();
                if (className == null || className.length() == 0) continue;
                this.loadValidatorClass(null, className);
            }
        }
        catch (Exception e) {
            missingModelValidationMessage = missingModelValidationMessage + e.toString() + " global" + '\n';
        }
        MClient[] clients = MClient.getAll(Env.getCtx());
        for (int i2 = 0; i2 < clients.length; ++i2) {
            String classNames = clients[i2].getModelValidationClasses();
            if (classNames == null || classNames.length() == 0) continue;
            this.loadValidatorClasses(clients[i2], classNames);
        }
    }

    private void loadValidatorClasses(MClient client, String classNames) {
        StringTokenizer st = new StringTokenizer(classNames, ";");
        while (st.hasMoreTokens()) {
            String className = null;
            try {
                className = st.nextToken();
                if (className == null || (className = className.trim()).length() == 0) continue;
                this.loadValidatorClass(client, className);
            }
            catch (Exception e) {
                missingModelValidationMessage = missingModelValidationMessage + e.toString() + " on client " + client.getName() + '\n';
            }
        }
    }

    private void loadValidatorClass(MClient client, String className) {
        try {
            Class<?> clazz = Class.forName(className);
            ModelValidator validator = (ModelValidator)clazz.newInstance();
            this.initialize(validator, client);
        }
        catch (Exception e) {
            missingModelValidationMessage = missingModelValidationMessage + e.toString() + (client != null ? " on client " + client.getName() : " global") + '\n';
        }
    }

    private void initialize(ModelValidator validator, MClient client) {
        if (client == null) {
            this.m_globalValidators.add(validator);
        }
        this.m_validators.add(validator);
        validator.initialize(this, client);
    }

    public String loginComplete(int AD_Client_ID, int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        MSystem system;
        for (int i2 = 0; i2 < this.m_validators.size(); ++i2) {
            String error;
            ModelValidator validator = this.m_validators.get(i2);
            if (AD_Client_ID != validator.getAD_Client_ID() && !this.m_globalValidators.contains(validator) || (error = validator.login(AD_Org_ID, AD_Role_ID, AD_User_ID)) == null || error.length() <= 0) continue;
            return error;
        }
        List<MRule> loginRules = MRule.getModelValidatorLoginRules(Env.getCtx());
        if (loginRules != null) {
            for (MRule loginRule : loginRules) {
                String error;
                if (!loginRule.getRuleType().equals("S") || !loginRule.getEventType().equals("L")) continue;
                try {
                    ScriptEngine engine = loginRule.getScriptEngine();
                    MRule.setContext(engine, Env.getCtx(), 0);
                    engine.put("A_Ctx", Env.getCtx());
                    engine.put("A_AD_Client_ID", AD_Client_ID);
                    engine.put("A_AD_Org_ID", AD_Org_ID);
                    engine.put("A_AD_Role_ID", AD_Role_ID);
                    engine.put("A_AD_User_ID", AD_User_ID);
                    Object retval = engine.eval(loginRule.getScript());
                    error = retval == null ? "" : retval.toString();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    error = e.toString();
                }
                if (error == null || error.length() <= 0) continue;
                return error;
            }
        }
        if ((AD_User_ID != 0 || AD_Role_ID != 0) && missingModelValidationMessage != null && (system = MSystem.get(Env.getCtx())).isFailOnMissingModelValidator()) {
            return missingModelValidationMessage;
        }
        return null;
    }

    public void addModelChange(String tableName, ModelValidator listener) {
        if (tableName == null || listener == null) {
            return;
        }
        String propertyName = this.m_globalValidators.contains(listener) ? tableName + "*" : tableName + listener.getAD_Client_ID();
        ArrayList<ModelValidator> list = this.m_modelChangeListeners.get(propertyName);
        if (list == null) {
            list = new ArrayList();
            list.add(listener);
            this.m_modelChangeListeners.put(propertyName, list);
        } else {
            list.add(listener);
        }
    }

    public void removeModelChange(String tableName, ModelValidator listener) {
        if (tableName == null || listener == null) {
            return;
        }
        String propertyName = this.m_globalValidators.contains(listener) ? tableName + "*" : tableName + listener.getAD_Client_ID();
        ArrayList<ModelValidator> list = this.m_modelChangeListeners.get(propertyName);
        if (list == null) {
            return;
        }
        list.remove(listener);
        if (list.size() == 0) {
            this.m_modelChangeListeners.remove(propertyName);
        }
    }

    public String fireModelChange(PO po, int changeType) {
        String error;
        if (po == null || this.m_modelChangeListeners.size() == 0) {
            return null;
        }
        String propertyName = po.get_TableName() + "*";
        ArrayList<ModelValidator> list = this.m_modelChangeListeners.get(propertyName);
        if (list != null && (error = this.fireModelChange(po, changeType, list)) != null && error.length() > 0) {
            return error;
        }
        propertyName = po.get_TableName() + po.getAD_Client_ID();
        list = this.m_modelChangeListeners.get(propertyName);
        if (list != null && (error = this.fireModelChange(po, changeType, list)) != null && error.length() > 0) {
            return error;
        }
        List<MTableScriptValidator> scriptValidators = MTableScriptValidator.getModelValidatorRules(po.getCtx(), po.get_Table_ID(), ModelValidator.tableEventValidators[changeType]);
        if (scriptValidators != null) {
            for (MTableScriptValidator scriptValidator : scriptValidators) {
                String error2;
                MRule rule = MRule.get(po.getCtx(), scriptValidator.getAD_Rule_ID());
                if (rule == null || !rule.isActive() || !rule.getRuleType().equals("S") || !rule.getEventType().equals("T")) continue;
                try {
                    ScriptEngine engine = rule.getScriptEngine();
                    MRule.setContext(engine, po.getCtx(), 0);
                    engine.put("A_Ctx", po.getCtx());
                    engine.put("A_PO", po);
                    engine.put("A_Type", changeType);
                    engine.put("A_Event", ModelValidator.tableEventValidators[changeType]);
                    Object retval = engine.eval(rule.getScript());
                    error2 = retval == null ? "" : retval.toString();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    error2 = e.toString();
                }
                if (error2 == null || error2.length() <= 0) continue;
                return error2;
            }
        }
        return null;
    }

    private String fireModelChange(PO po, int changeType, ArrayList<ModelValidator> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String error;
            try {
                ModelValidator validator = list.get(i2);
                if (validator.getAD_Client_ID() != po.getAD_Client_ID() && !this.m_globalValidators.contains(validator) || (error = validator.modelChange(po, changeType)) == null || error.length() <= 0) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "po=" + po + " validator=" + validator + " changeType=" + changeType);
                }
                return error;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getLocalizedMessage(), e);
                error = e.getLocalizedMessage();
                if (error == null) {
                    error = e.toString();
                }
                return error;
            }
        }
        return null;
    }

    public void addDocValidate(String tableName, ModelValidator listener) {
        if (tableName == null || listener == null) {
            return;
        }
        String propertyName = this.m_globalValidators.contains(listener) ? tableName + "*" : tableName + listener.getAD_Client_ID();
        ArrayList<ModelValidator> list = this.m_docValidateListeners.get(propertyName);
        if (list == null) {
            list = new ArrayList();
            list.add(listener);
            this.m_docValidateListeners.put(propertyName, list);
        } else if (!list.contains(listener)) {
            list.add(listener);
        }
    }

    public void removeDocValidate(String tableName, ModelValidator listener) {
        if (tableName == null || listener == null) {
            return;
        }
        String propertyName = this.m_globalValidators.contains(listener) ? tableName + "*" : tableName + listener.getAD_Client_ID();
        ArrayList<ModelValidator> list = this.m_docValidateListeners.get(propertyName);
        if (list == null) {
            return;
        }
        list.remove(listener);
        if (list.size() == 0) {
            this.m_docValidateListeners.remove(propertyName);
        }
    }

    public String fireDocValidate(PO po, int docTiming) {
        String error;
        if (po == null || this.m_docValidateListeners.size() == 0) {
            return null;
        }
        String propertyName = po.get_TableName() + "*";
        ArrayList<ModelValidator> list = this.m_docValidateListeners.get(propertyName);
        if (list != null && (error = this.fireDocValidate(po, docTiming, list)) != null && error.length() > 0) {
            return error;
        }
        propertyName = po.get_TableName() + po.getAD_Client_ID();
        list = this.m_docValidateListeners.get(propertyName);
        if (list != null && (error = this.fireDocValidate(po, docTiming, list)) != null && error.length() > 0) {
            return error;
        }
        List<MTableScriptValidator> scriptValidators = MTableScriptValidator.getModelValidatorRules(po.getCtx(), po.get_Table_ID(), ModelValidator.documentEventValidators[docTiming]);
        if (scriptValidators != null) {
            for (MTableScriptValidator scriptValidator : scriptValidators) {
                String error2;
                MRule rule = MRule.get(po.getCtx(), scriptValidator.getAD_Rule_ID());
                if (rule == null || !rule.isActive() || !rule.getRuleType().equals("S") || !rule.getEventType().equals("D")) continue;
                try {
                    ScriptEngine engine = rule.getScriptEngine();
                    MRule.setContext(engine, po.getCtx(), 0);
                    engine.put("A_Ctx", po.getCtx());
                    engine.put("A_PO", po);
                    engine.put("A_Type", docTiming);
                    engine.put("A_Event", ModelValidator.documentEventValidators[docTiming]);
                    Object retval = engine.eval(rule.getScript());
                    error2 = retval == null ? "" : retval.toString();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    error2 = e.toString();
                }
                if (error2 == null || error2.length() <= 0) continue;
                return error2;
            }
        }
        return null;
    }

    private String fireDocValidate(PO po, int docTiming, ArrayList<ModelValidator> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ModelValidator validator = null;
            try {
                String error;
                validator = list.get(i2);
                if (validator.getAD_Client_ID() != po.getAD_Client_ID() && !this.m_globalValidators.contains(validator) || (error = validator.docValidate(po, docTiming)) == null || error.length() <= 0) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "po=" + po + " validator=" + validator + " timing=" + docTiming);
                }
                return error;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getLocalizedMessage(), e);
                String error = e.getLocalizedMessage();
                if (error == null) {
                    error = e.toString();
                }
                return error;
            }
        }
        return null;
    }

    public void addFactsValidate(String tableName, FactsValidator listener) {
        if (tableName == null || listener == null) {
            return;
        }
        String propertyName = this.m_globalValidators.contains(listener) ? tableName + "*" : tableName + listener.getAD_Client_ID();
        ArrayList<FactsValidator> list = this.m_factsValidateListeners.get(propertyName);
        if (list == null) {
            list = new ArrayList();
            list.add(listener);
            this.m_factsValidateListeners.put(propertyName, list);
        } else {
            list.add(listener);
        }
    }

    public void addImportValidate(String importTableName, ImportValidator listener) {
        String propertyName = importTableName + "*";
        ArrayList<ImportValidator> list = this.m_impValidateListeners.get(propertyName);
        if (list == null) {
            list = new ArrayList();
            list.add(listener);
            this.m_impValidateListeners.put(propertyName, list);
        } else {
            list.add(listener);
        }
    }

    public void removeFactsValidate(String tableName, FactsValidator listener) {
        if (tableName == null || listener == null) {
            return;
        }
        String propertyName = this.m_globalValidators.contains(listener) ? tableName + "*" : tableName + listener.getAD_Client_ID();
        ArrayList<FactsValidator> list = this.m_factsValidateListeners.get(propertyName);
        if (list == null) {
            return;
        }
        list.remove(listener);
        if (list.size() == 0) {
            this.m_factsValidateListeners.remove(propertyName);
        }
    }

    public String fireFactsValidate(MAcctSchema schema, List<Fact> facts, PO po) {
        String error;
        if (schema == null || facts == null || po == null || this.m_factsValidateListeners.size() == 0) {
            return null;
        }
        String propertyName = po.get_TableName() + "*";
        ArrayList<FactsValidator> list = this.m_factsValidateListeners.get(propertyName);
        if (list != null && (error = this.fireFactsValidate(schema, facts, po, list)) != null && error.length() > 0) {
            return error;
        }
        propertyName = po.get_TableName() + po.getAD_Client_ID();
        list = this.m_factsValidateListeners.get(propertyName);
        if (list != null && (error = this.fireFactsValidate(schema, facts, po, list)) != null && error.length() > 0) {
            return error;
        }
        return null;
    }

    private String fireFactsValidate(MAcctSchema schema, List<Fact> facts, PO po, ArrayList<FactsValidator> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            FactsValidator validator = null;
            try {
                String error;
                validator = list.get(i2);
                if (validator.getAD_Client_ID() != po.getAD_Client_ID() && !this.m_globalValidators.contains(validator) || (error = validator.factsValidate(schema, facts, po)) == null || error.length() <= 0) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "po=" + po + " schema=" + schema + " validator=" + validator);
                }
                return error;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getLocalizedMessage(), e);
                String error = e.getLocalizedMessage();
                if (error == null) {
                    error = e.toString();
                }
                return error;
            }
        }
        return null;
    }

    public void fireImportValidate(ImportProcess process, PO importModel, PO targetModel, int timing) {
        if (this.m_impValidateListeners.size() == 0) {
            return;
        }
        String propertyName = process.getImportTableName() + "*";
        ArrayList<ImportValidator> list = this.m_impValidateListeners.get(propertyName);
        if (list != null) {
            for (ImportValidator validator : list) {
                validator.validate(process, importModel, targetModel, timing);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelValidationEngine[");
        sb.append("Validators=#").append(this.m_validators.size()).append(", ModelChange=#").append(this.m_modelChangeListeners.size()).append(", DocValidate=#").append(this.m_docValidateListeners.size()).append("]");
        return sb.toString();
    }

    public StringBuffer getInfoDetail(StringBuffer sb, Properties ctx) {
        ArrayList<ModelValidator> list;
        if (sb == null) {
            sb = new StringBuffer();
        }
        sb.append("=== ModelValidationEngine ===").append(Env.NL);
        sb.append("Validators #").append(this.m_validators.size()).append(Env.NL);
        for (ModelValidator mv : this.m_validators) {
            sb.append(mv.toString()).append(Env.NL);
        }
        sb.append(Env.NL).append(Env.NL);
        sb.append("ModelChange #").append(this.m_modelChangeListeners.size()).append(Env.NL);
        for (String key : this.m_modelChangeListeners.keySet()) {
            list = this.m_modelChangeListeners.get(key);
            for (ModelValidator mv : list) {
                sb.append(key).append(": ").append(mv.toString()).append(Env.NL);
            }
        }
        sb.append(Env.NL).append(Env.NL);
        sb.append("DocValidate #").append(this.m_docValidateListeners.size()).append(Env.NL);
        for (String key : this.m_docValidateListeners.keySet()) {
            list = this.m_docValidateListeners.get(key);
            for (ModelValidator mv : list) {
                sb.append(key).append(": ").append(mv.toString()).append(Env.NL);
            }
        }
        sb.append(Env.NL).append(Env.NL);
        return sb;
    }

    public void afterLoadPreferences(Properties ctx) {
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        for (int i2 = 0; i2 < this.m_validators.size(); ++i2) {
            ModelValidator validator = this.m_validators.get(i2);
            if (AD_Client_ID != validator.getAD_Client_ID() && !this.m_globalValidators.contains(validator)) continue;
            Method m = null;
            try {
                m = validator.getClass().getMethod("afterLoadPreferences", Properties.class);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            try {
                if (m == null) continue;
                m.invoke((Object)validator, ctx);
                continue;
            }
            catch (Exception e) {
                log.warning("" + validator + ": " + e.getLocalizedMessage());
            }
        }
    }

    public void beforeSaveProperties() {
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        for (int i2 = 0; i2 < this.m_validators.size(); ++i2) {
            ModelValidator validator = this.m_validators.get(i2);
            if (AD_Client_ID != validator.getAD_Client_ID() && !this.m_globalValidators.contains(validator)) continue;
            Method m = null;
            try {
                m = validator.getClass().getMethod("beforeSaveProperties", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            try {
                if (m == null) continue;
                m.invoke((Object)validator, new Object[0]);
                continue;
            }
            catch (Exception e) {
                log.warning("" + validator + ": " + e.getLocalizedMessage());
            }
        }
    }
}

