/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.cm.CacheHandler;
import org.compiere.model.MAd;
import org.compiere.model.MWebProject;
import org.compiere.model.X_CM_Template;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MTemplate
extends X_CM_Template {
    private static final long serialVersionUID = -2349891937695644752L;
    private MWebProject m_project = null;
    private StringBuffer m_preBuildTemplate;

    public static MTemplate get(Properties ctx, int CM_Template_ID, String trxName) {
        MTemplate retValue = new MTemplate(ctx, CM_Template_ID, trxName);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MTemplate(ctx, CM_Template_ID, null);
        return retValue;
    }

    public MTemplate(Properties ctx, int CM_Template_ID, String trxName) {
        super(ctx, CM_Template_ID, trxName);
    }

    public MTemplate(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MWebProject getWebProject() {
        if (this.m_project == null) {
            this.m_project = MWebProject.get(this.getCtx(), this.getCM_WebProject_ID());
        }
        return this.m_project;
    }

    public int getAD_Tree_ID() {
        return this.getWebProject().getAD_TreeCMT_ID();
    }

    public StringBuffer getPreBuildTemplate() {
        if (this.m_preBuildTemplate != null) {
            return this.m_preBuildTemplate;
        }
        this.m_preBuildTemplate = new StringBuffer(this.getTemplateXST());
        if (this.m_preBuildTemplate.indexOf("<xsl:call-template") >= 0) {
            StringBuffer subTemplates = new StringBuffer();
            int pos = 0;
            Hashtable<String, String> subTemplateNames = new Hashtable<String, String>();
            while (this.m_preBuildTemplate.indexOf("<xsl:call-template", pos) >= 0) {
                String thisName = null;
                int beginPos = this.m_preBuildTemplate.indexOf("<xsl:call-template", pos);
                int endPos = this.m_preBuildTemplate.indexOf("/>", beginPos);
                if (this.m_preBuildTemplate.indexOf(">", beginPos) < endPos) {
                    endPos = this.m_preBuildTemplate.indexOf(">", beginPos) + 1;
                }
                String tempTemplate = this.m_preBuildTemplate.substring(beginPos, endPos);
                pos = this.m_preBuildTemplate.indexOf("<xsl:call-template", pos) + tempTemplate.length();
                if (tempTemplate.indexOf("name=") < 0 || subTemplateNames.containsKey(thisName = tempTemplate.substring(tempTemplate.indexOf("name=\"") + 6, tempTemplate.indexOf("\"", tempTemplate.indexOf("name=\"") + 7)))) continue;
                subTemplateNames.put(thisName, "0");
            }
            Enumeration thisEnum = subTemplateNames.keys();
            while (thisEnum.hasMoreElements()) {
                MTemplate thisSubTemplate;
                String thisElement = thisEnum.nextElement().toString();
                int[] templateIDs = MTemplate.getAllIDs("CM_Template", "Value LIKE '" + thisElement + "' AND CM_WebProject_ID=" + this.getCM_WebProject_ID(), this.get_TrxName());
                if (templateIDs == null || templateIDs.length == 0) continue;
                if (templateIDs.length == 1) {
                    thisSubTemplate = new MTemplate(this.getCtx(), templateIDs[0], this.get_TrxName());
                    subTemplates.append(thisSubTemplate.getTemplateXST());
                    continue;
                }
                thisSubTemplate = new MTemplate(this.getCtx(), templateIDs[0], this.get_TrxName());
                subTemplates.append("\n" + thisSubTemplate.getTemplateXST() + "\n");
            }
            this.m_preBuildTemplate.append(subTemplates);
            this.m_preBuildTemplate = new StringBuffer(this.m_preBuildTemplate.substring(0, this.m_preBuildTemplate.indexOf("</xsl:stylesheet>")) + subTemplates.toString() + "\n</xsl:stylesheet>");
        }
        return this.m_preBuildTemplate;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (newRecord) {
            StringBuffer sb = new StringBuffer("INSERT INTO AD_TreeNodeCMT (AD_Client_ID,AD_Org_ID, IsActive,Created,CreatedBy,Updated,UpdatedBy, AD_Tree_ID, Node_ID, Parent_ID, SeqNo) VALUES (").append(this.getAD_Client_ID()).append(",0, 'Y', SysDate, 0, SysDate, 0,").append(this.getAD_Tree_ID()).append(",").append(this.get_ID()).append(", 0, 999)");
            int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
            if (no > 0) {
                this.log.fine("#" + no + " - TreeType=CMT");
            } else {
                this.log.warning("#" + no + " - TreeType=CMT");
            }
            return no > 0;
        }
        if (!newRecord) {
            CacheHandler thisHandler = new CacheHandler(CacheHandler.convertJNPURLToCacheURL(this.getCtx().getProperty("java.naming.provider.url")), this.log, this.getCtx(), this.get_TrxName());
            if (!this.isInclude()) {
                thisHandler.cleanTemplate(this.get_ID());
            } else {
                thisHandler.emptyTemplate();
            }
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        StringBuffer sb = new StringBuffer("DELETE FROM AD_TreeNodeCMT ").append(" WHERE Node_ID=").append(this.get_IDOld()).append(" AND AD_Tree_ID=").append(this.getAD_Tree_ID());
        int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
        if (no > 0) {
            this.log.fine("#" + no + " - TreeType=CMT");
        } else {
            this.log.warning("#" + no + " - TreeType=CMT");
        }
        return no > 0;
    }

    public MAd[] getAds() {
        int[] AdCats = null;
        String sql = "SELECT count(*) FROM CM_Template_AD_Cat WHERE CM_Template_ID=?";
        CPreparedStatement pstmt = null;
        try {
            int numberAdCats = 0;
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.get_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                numberAdCats = rs.getInt(1);
            }
            rs.close();
            AdCats = new int[numberAdCats];
            int i2 = 0;
            sql = "SELECT CM_Ad_Cat_ID FROM CM_Template_AD_Cat WHERE CM_Template_ID=?";
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.get_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                AdCats[i2] = rs.getInt(1);
                ++i2;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, sql, ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        if (AdCats != null && AdCats.length > 0) {
            MAd[] returnAds = new MAd[AdCats.length];
            for (int i3 = 0; i3 < AdCats.length; ++i3) {
                returnAds[i3] = MAd.getNext(this.getCtx(), AdCats[i3], this.get_TrxName());
            }
            return returnAds;
        }
        return null;
    }
}

