/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.db.CConnection;
import org.compiere.db.Database;
import org.compiere.db.LDAP;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.compiere.model.X_AD_System;
import org.compiere.util.CLogMgt;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.TimeUtil;

public class MSystem
extends X_AD_System {
    private static final long serialVersionUID = 8639311032004561198L;
    private static MSystem s_system = null;
    private static final String SYSTEM_ALLOW_REMEMBER_USER = "U";
    private static final String SYSTEM_ALLOW_REMEMBER_PASSWORD = "P";

    public static MSystem get(Properties ctx) {
        if (s_system != null) {
            return s_system;
        }
        s_system = (MSystem)new Query(ctx, "AD_System", null, null).setOrderBy("AD_System_ID").firstOnly();
        if (s_system == null) {
            return null;
        }
        if (!Ini.isClient() && s_system.setInfo()) {
            s_system.saveEx();
        }
        return s_system;
    }

    public MSystem(Properties ctx, int ignored, String mtrxName) {
        super(ctx, 0, mtrxName);
        String trxName = null;
        this.load(trxName);
        if (s_system == null) {
            s_system = this;
        }
    }

    public MSystem(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        if (s_system == null) {
            s_system = this;
        }
    }

    public MSystem() {
        this(new Properties(), 0, null);
    }

    public boolean isLDAP() {
        String host = this.getLDAPHost();
        if (host == null || host.length() == 0) {
            return false;
        }
        String domain = this.getLDAPDomain();
        return domain != null && domain.length() > 0;
    }

    public boolean isLDAP(String userName, String password) {
        return LDAP.validate(this.getLDAPHost(), this.getLDAPDomain(), userName, password);
    }

    @Override
    public String getDBAddress() {
        String s = super.getDBAddress();
        if (s == null || s.length() == 0) {
            s = CConnection.get().getConnectionURL();
        }
        return s;
    }

    public String getStatisticsInfo(boolean recalc) {
        String s = super.getStatisticsInfo();
        if (s == null || recalc) {
            String sql = DB.isMySQL() ? "SELECT CONCAT('C', (SELECT CAST(COUNT(*) AS char(3)) FROM AD_Client), 'U', (SELECT CAST(COUNT(*) AS char(3)) FROM AD_User), 'B', (SELECT CAST(COUNT(*) AS char(3)) FROM C_BPartner), 'P', (SELECT CAST(COUNT(*) AS char(3)) FROM M_Product), 'I', (SELECT CAST(COUNT(*) AS char(3)) FROM C_Invoice), 'L', (SELECT CAST(COUNT(*) AS char(3)) FROM C_InvoiceLine), 'M', (SELECT CAST(COUNT(*) AS char(3)) FROM M_Transaction))FROM AD_System" : "SELECT 'C'||(SELECT " + DB.TO_CHAR("COUNT(*)", 22, Env.getAD_Language(Env.getCtx())) + " FROM AD_Client)" + "||'U'|| (SELECT " + DB.TO_CHAR("COUNT(*)", 22, Env.getAD_Language(Env.getCtx())) + " FROM AD_User)" + "||'B'|| (SELECT " + DB.TO_CHAR("COUNT(*)", 22, Env.getAD_Language(Env.getCtx())) + " FROM C_BPartner)" + "||'P'|| (SELECT " + DB.TO_CHAR("COUNT(*)", 22, Env.getAD_Language(Env.getCtx())) + " FROM M_Product)" + "||'I'|| (SELECT " + DB.TO_CHAR("COUNT(*)", 22, Env.getAD_Language(Env.getCtx())) + " FROM C_Invoice)" + "||'L'|| (SELECT " + DB.TO_CHAR("COUNT(*)", 22, Env.getAD_Language(Env.getCtx())) + " FROM C_InvoiceLine)" + "||'M'|| (SELECT " + DB.TO_CHAR("COUNT(*)", 22, Env.getAD_Language(Env.getCtx())) + " FROM M_Transaction)" + " FROM AD_System";
            s = DB.getSQLValueString(null, sql, new Object[0]);
        }
        return s;
    }

    public String getProfileInfo(boolean recalc) {
        String s;
        block5: {
            s = super.getProfileInfo();
            if (s != null && !recalc) break block5;
            String sql = "SELECT Value FROM AD_Client  WHERE IsActive='Y' ORDER BY AD_Client_ID DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            StringBuffer sb = new StringBuffer();
            try {
                pstmt = DB.prepareStatement("SELECT Value FROM AD_Client  WHERE IsActive='Y' ORDER BY AD_Client_ID DESC", null);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    sb.append(rs.getString(1)).append('|');
                }
            }
            catch (SQLException e) {
                try {
                    throw new DBException(e, "SELECT Value FROM AD_Client  WHERE IsActive='Y' ORDER BY AD_Client_ID DESC");
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            s = sb.toString();
        }
        return s;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        boolean userChange;
        if (this.get_Value("IsAutoErrorReport") == null) {
            this.setIsAutoErrorReport(true);
        }
        boolean bl = userChange = Ini.isClient() && (this.is_ValueChanged("Name") || this.is_ValueChanged("UserName") || this.is_ValueChanged("Password") || this.is_ValueChanged("LDAPHost") || this.is_ValueChanged("LDAPDomain") || this.is_ValueChanged("CustomPrefix"));
        if (userChange) {
            String name = this.getName();
            if (name.equals("?") || name.length() < 2) {
                throw new AdempiereException("Define a unique System name (e.g. Company name) not " + name);
            }
            if (this.getUserName().equals("?") || this.getUserName().length() < 2) {
                throw new AdempiereException("Use the same EMail address as in the Adempiere Web Store");
            }
            if (this.getPassword().equals("?") || this.getPassword().length() < 2) {
                throw new AdempiereException("Use the same Password as in the Adempiere Web Store");
            }
        }
        this.setInfo();
        return true;
    }

    @Override
    public boolean save() {
        if (!this.beforeSave(false)) {
            return false;
        }
        return this.saveUpdate();
    }

    @Override
    public String toString() {
        return "MSystem[" + this.getName() + ",User=" + this.getUserName() + ",ReleaseNo=" + this.getReleaseNo() + "]";
    }

    public boolean isValid() {
        if (this.getName() == null || this.getName().length() < 2) {
            this.log.log(Level.WARNING, "Name not valid: " + this.getName());
            return false;
        }
        if (this.getPassword() == null || this.getPassword().length() < 2) {
            this.log.log(Level.WARNING, "Password not valid: " + this.getPassword());
            return false;
        }
        if (this.getInfo() == null || this.getInfo().length() < 2) {
            this.log.log(Level.WARNING, "Need to run Migration once");
            return false;
        }
        return true;
    }

    public boolean isPDFLicense() {
        String key = this.getSummary();
        return key != null && key.length() > 25;
    }

    public boolean setInfo() {
        if (!TimeUtil.getDay(this.getUpdated()).before(TimeUtil.getDay(null))) {
            return false;
        }
        try {
            this.setDBInfo();
            this.setInternalUsers();
            if (this.isAllowStatistics()) {
                this.setStatisticsInfo(this.getStatisticsInfo(true));
                this.setProfileInfo(this.getProfileInfo(true));
            }
        }
        catch (Exception e) {
            this.setSupportUnits(9999);
            this.setInfo(e.getLocalizedMessage());
            this.log.log(Level.SEVERE, "", e);
        }
        return true;
    }

    private void setInternalUsers() {
        String sql = "SELECT COUNT(DISTINCT (u.AD_User_ID)) AS iu FROM AD_User u INNER JOIN AD_User_Roles ur ON (u.AD_User_ID=ur.AD_User_ID) WHERE u.AD_Client_ID<>11 AND u.AD_User_ID NOT IN (0,100)";
        int internalUsers = DB.getSQLValue(null, "SELECT COUNT(DISTINCT (u.AD_User_ID)) AS iu FROM AD_User u INNER JOIN AD_User_Roles ur ON (u.AD_User_ID=ur.AD_User_ID) WHERE u.AD_Client_ID<>11 AND u.AD_User_ID NOT IN (0,100)");
        this.setSupportUnits(internalUsers);
    }

    private void setDBInfo() {
        String dbAddress = CConnection.get().getConnectionURL();
        this.setDBAddress(dbAddress.toLowerCase());
        if (!Ini.isClient()) {
            int noProcessors = Runtime.getRuntime().availableProcessors();
            this.setNoProcessors(noProcessors);
        }
        String dbName = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = null;
        try {
            String dbType = CConnection.get().getDatabase().getName();
            sql = MSystem.getDBInfoSQL(dbType);
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                dbName = rs.getString(2);
                this.setDBInstance(dbName.toLowerCase());
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    public static String getDBInfoSQL(String dbType) {
        if (Database.DB_ORACLE.equals(dbType)) {
            return "SELECT SYS_CONTEXT('USERENV','HOST') || '/' || SYS_CONTEXT('USERENV','IP_ADDRESS') AS DBAddress,\tSYS_CONTEXT('USERENV','CURRENT_USER') || '.' || SYS_CONTEXT('USERENV','DB_NAME') || '.' || SYS_CONTEXT('USERENV','DB_DOMAIN') AS DBName FROM DUAL";
        }
        return "SELECT NULL,NULL FROM AD_System WHERE AD_System_ID=-1";
    }

    public void info() {
        if (!CLogMgt.isLevelFine()) {
            return;
        }
        RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
        if (CLogMgt.isLevelFiner()) {
            List<MemoryPoolMXBean> list = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean pool : list) {
            }
        } else {
            MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        }
        ThreadMXBean th2 = ManagementFactory.getThreadMXBean();
    }

    public static boolean isZKRememberUserAllowed() {
        String ca = MSysConfig.getValue("ZK_LOGIN_ALLOW_REMEMBER_ME", SYSTEM_ALLOW_REMEMBER_USER);
        return ca.equalsIgnoreCase(SYSTEM_ALLOW_REMEMBER_USER) || ca.equalsIgnoreCase(SYSTEM_ALLOW_REMEMBER_PASSWORD);
    }

    public static boolean isZKRememberPasswordAllowed() {
        String ca = MSysConfig.getValue("ZK_LOGIN_ALLOW_REMEMBER_ME", SYSTEM_ALLOW_REMEMBER_USER);
        return ca.equalsIgnoreCase(SYSTEM_ALLOW_REMEMBER_PASSWORD);
    }

    public static boolean isSwingRememberUserAllowed() {
        String ca = MSysConfig.getValue("SWING_LOGIN_ALLOW_REMEMBER_ME", SYSTEM_ALLOW_REMEMBER_PASSWORD);
        return ca.equalsIgnoreCase(SYSTEM_ALLOW_REMEMBER_USER) || ca.equalsIgnoreCase(SYSTEM_ALLOW_REMEMBER_PASSWORD);
    }

    public static boolean isSwingRememberPasswordAllowed() {
        String ca = MSysConfig.getValue("SWING_LOGIN_ALLOW_REMEMBER_ME", SYSTEM_ALLOW_REMEMBER_PASSWORD);
        return ca.equalsIgnoreCase(SYSTEM_ALLOW_REMEMBER_PASSWORD);
    }

    public static void main(String[] args) {
        new MSystem();
    }
}

