/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.util.Calendar;
import java.util.StringTokenizer;
import org.compiere.util.CLogger;

public class MPaymentValidate {
    private static CLogger s_log = CLogger.getCLogger(MPaymentValidate.class);

    public static String validateCreditCardExp(String mmyy) {
        String exp = MPaymentValidate.checkNumeric(mmyy);
        if (exp.length() != 4) {
            return "CreditCardExpFormat";
        }
        String mmStr = exp.substring(0, 2);
        String yyStr = exp.substring(2, 4);
        int mm = 0;
        int yy = 0;
        try {
            mm = Integer.parseInt(mmStr);
            yy = Integer.parseInt(yyStr);
        }
        catch (Exception e) {
            return "CreditCardExpFormat";
        }
        return MPaymentValidate.validateCreditCardExp(mm, yy);
    }

    public static int getCreditCardExpMM(String mmyy) {
        String mmStr = mmyy.substring(0, 2);
        int mm = 0;
        try {
            mm = Integer.parseInt(mmStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mm;
    }

    public static int getCreditCardExpYY(String mmyy) {
        String yyStr = mmyy.substring(2);
        int yy = 0;
        try {
            yy = Integer.parseInt(yyStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return yy;
    }

    public static String validateCreditCardExp(int mm, int yy) {
        if (mm < 1 || mm > 12) {
            return "CreditCardExpMonth";
        }
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1) - 2000;
        int month = cal.get(2) + 1;
        if (yy < year) {
            return "CreditCardExpired";
        }
        if (yy == year && mm < month) {
            return "CreditCardExpired";
        }
        return "";
    }

    public static String validateCreditCardNumber(String creditCardNumber) {
        if (creditCardNumber == null || creditCardNumber.length() == 0) {
            return "CreditCardNumberError";
        }
        String ccNumber1 = MPaymentValidate.checkNumeric(creditCardNumber);
        int ccLength = ccNumber1.length();
        StringBuffer buf = new StringBuffer();
        for (int i2 = ccLength; i2 != 0; --i2) {
            buf.append(ccNumber1.charAt(i2 - 1));
        }
        String ccNumber = buf.toString();
        int sum = 0;
        for (int i3 = 0; i3 < ccLength; ++i3) {
            int digit = Character.getNumericValue(ccNumber.charAt(i3));
            if (i3 % 2 == 1 && (digit *= 2) > 9) {
                digit -= 9;
            }
            sum += digit;
        }
        if (sum % 10 == 0) {
            return "";
        }
        s_log.fine("validateCreditCardNumber - " + creditCardNumber + " -> " + ccNumber + ", Luhn=" + sum);
        return "CreditCardNumberError";
    }

    public static String validateCreditCardNumber(String creditCardNumber, String creditCardType) {
        String check;
        if (creditCardNumber == null || creditCardType == null) {
            return "CreditCardNumberError";
        }
        String ccStartList = "";
        String ccLengthList = "";
        if (creditCardType.equals("M")) {
            ccStartList = "51,52,53,54,55";
            ccLengthList = "16";
        } else if (creditCardType.equals("V")) {
            ccStartList = "4";
            ccLengthList = "13,16";
        } else if (creditCardType.equals("A")) {
            ccStartList = "34,37";
            ccLengthList = "15";
        } else if (creditCardType.equals("N")) {
            ccStartList = "6011";
            ccLengthList = "16";
        } else if (creditCardType.equals("D")) {
            ccStartList = "300,301,302,303,304,305,36,38";
            ccLengthList = "14";
        } else {
            ccStartList = "2014,2149";
            ccLengthList = "15";
            ccStartList = ccStartList + ",3088,3096,3112,3158,3337,3528";
            ccLengthList = ccLengthList + ",16";
            ccStartList = ccStartList + ",2131,1800";
            ccLengthList = ccLengthList + ",15";
        }
        String ccNumber = MPaymentValidate.checkNumeric(creditCardNumber);
        int ccLength = ccNumber.length();
        boolean ccLengthOK = false;
        StringTokenizer st = new StringTokenizer(ccLengthList, ",", false);
        while (st.hasMoreTokens() && !ccLengthOK) {
            int l = Integer.parseInt(st.nextToken());
            if (ccLength != l) continue;
            ccLengthOK = true;
        }
        if (!ccLengthOK) {
            s_log.fine("validateCreditCardNumber Length=" + ccLength + " <> " + ccLengthList);
            return "CreditCardNumberError";
        }
        boolean ccIdentified = false;
        st = new StringTokenizer(ccStartList, ",", false);
        while (st.hasMoreTokens() && !ccIdentified) {
            if (!ccNumber.startsWith(st.nextToken())) continue;
            ccIdentified = true;
        }
        if (!ccIdentified) {
            s_log.fine("validateCreditCardNumber Type=" + creditCardType + " <> " + ccStartList);
        }
        if ((check = MPaymentValidate.validateCreditCardNumber(ccNumber)).length() != 0) {
            return check;
        }
        if (!ccIdentified) {
            return "CreditCardNumberProblem?";
        }
        return "";
    }

    public static String validateCreditCardVV(String creditCardVV) {
        if (creditCardVV == null) {
            return "";
        }
        int length = MPaymentValidate.checkNumeric(creditCardVV).length();
        if (length == 3 || length == 4) {
            return "";
        }
        try {
            Integer.parseInt(creditCardVV);
            return "";
        }
        catch (NumberFormatException ex) {
            s_log.fine("validateCreditCardVV - " + ex);
            s_log.fine("validateCreditCardVV - length=" + length);
            return "CreditCardVVError";
        }
    }

    public static String validateCreditCardVV(String creditCardVV, String creditCardType) {
        if (creditCardVV == null || creditCardVV.length() == 0 || creditCardType == null || creditCardType.length() == 0) {
            return "";
        }
        int length = MPaymentValidate.checkNumeric(creditCardVV).length();
        if (creditCardType.equals("A")) {
            if (length == 4) {
                try {
                    Integer.parseInt(creditCardVV);
                    return "";
                }
                catch (NumberFormatException ex) {
                    s_log.fine("validateCreditCardVV - " + ex);
                }
            }
            s_log.fine("validateCreditCardVV(4) CC=" + creditCardType + ", length=" + length);
            return "CreditCardVVError";
        }
        if (creditCardType.equals("V") || creditCardType.equals("M")) {
            if (length == 3) {
                try {
                    Integer.parseInt(creditCardVV);
                    return "";
                }
                catch (NumberFormatException ex) {
                    s_log.fine("validateCreditCardVV - " + ex);
                }
            }
            s_log.fine("validateCreditCardVV(3) CC=" + creditCardType + ", length=" + length);
            return "CreditCardVVError";
        }
        return "";
    }

    public static String validateRoutingNo(String routingNo) {
        int length = MPaymentValidate.checkNumeric(routingNo).length();
        if (length > 0) {
            return "";
        }
        return "PaymentBankRoutingNotValid";
    }

    public static String validateAccountNo(String AccountNo) {
        int length = MPaymentValidate.checkNumeric(AccountNo).length();
        if (length > 0) {
            return "";
        }
        return "PaymentBankAccountNotValid";
    }

    public static String validateCheckNo(String CheckNo) {
        int length = MPaymentValidate.checkNumeric(CheckNo).length();
        if (length > 0) {
            return "";
        }
        return "PaymentBankCheckNotValid";
    }

    public static String checkNumeric(String data) {
        if (data == null || data.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < data.length(); ++i2) {
            if (!Character.isDigit(data.charAt(i2))) continue;
            sb.append(data.charAt(i2));
        }
        return sb.toString();
    }
}

