/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Dimension;
import java.awt.Image;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.Icon;
import org.compiere.model.GridWindow;
import org.compiere.model.MQuery;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GridWorkbench
implements Serializable {
    private static final long serialVersionUID = 3947016961582548630L;
    private Properties m_ctx;
    private ArrayList<WBWindow> m_windows = new ArrayList();
    private int AD_Workbench_ID = 0;
    private String Name = "";
    private String Description = "";
    private String Help = "";
    private int AD_Column_ID = 0;
    private int AD_Image_ID = 0;
    private int AD_Color_ID = 0;
    private int PA_Goal_ID = 0;
    private String ColumnName = "";
    private static CLogger log = CLogger.getCLogger(GridWorkbench.class);
    public static final int TYPE_WINDOW = 1;
    public static final int TYPE_FORM = 2;
    public static final int TYPE_PROCESS = 3;
    public static final int TYPE_TASK = 4;

    public GridWorkbench(Properties ctx) {
        this.m_ctx = ctx;
    }

    public GridWorkbench(Properties ctx, int AD_Window_ID) {
        this.m_ctx = ctx;
        this.m_windows.add(new WBWindow(1, AD_Window_ID));
    }

    public boolean initWorkbench(int ad_Workbench_ID) {
        this.AD_Workbench_ID = ad_Workbench_ID;
        String sql = null;
        sql = Env.isBaseLanguage(this.m_ctx, "AD_Workbench") ? "SELECT w.Name,w.Description,w.Help, w.AD_Column_ID,w.AD_Image_ID,w.AD_Color_ID,w.PA_Goal_ID, c.ColumnName FROM AD_Workbench w, AD_Column c WHERE w.AD_Workbench_ID=? AND w.IsActive='Y' AND w.AD_Column_ID=c.AD_Column_ID" : "SELECT t.Name,t.Description,t.Help, w.AD_Column_ID,w.AD_Image_ID,w.AD_Color_ID,w.PA_Goal_ID, c.ColumnName FROM AD_Workbench w, AD_Workbench_Trl t, AD_Column c WHERE w.AD_Workbench_ID=? AND w.IsActive='Y' AND w.AD_Workbench_ID=t.AD_Workbench_ID AND t.AD_Language='" + Env.getAD_Language(this.m_ctx) + "'" + " AND w.AD_Column_ID=c.AD_Column_ID";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.AD_Workbench_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.Name = rs.getString(1);
                this.Description = rs.getString(2);
                if (this.Description == null) {
                    this.Description = "";
                }
                this.Help = rs.getString(3);
                if (this.Help == null) {
                    this.Help = "";
                }
                this.AD_Column_ID = rs.getInt(4);
                this.AD_Image_ID = rs.getInt(5);
                this.AD_Color_ID = rs.getInt(6);
                this.PA_Goal_ID = rs.getInt(7);
                this.ColumnName = rs.getString(8);
            } else {
                this.AD_Workbench_ID = 0;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        if (this.AD_Workbench_ID == 0) {
            return false;
        }
        return this.initWorkbenchWindows();
    }

    public String toString() {
        return "MWorkbench ID=" + this.AD_Workbench_ID + " " + this.Name + ", windows=" + this.m_windows.size() + ", LinkColumn=" + this.ColumnName;
    }

    public void dispose() {
        for (int i2 = 0; i2 < this.m_windows.size(); ++i2) {
            this.dispose(i2);
        }
        this.m_windows.clear();
        this.m_windows = null;
    }

    public MQuery getQuery() {
        return MQuery.getEqualQuery(this.ColumnName, "@#" + this.ColumnName + "@");
    }

    public int getAD_Workbench_ID() {
        return this.AD_Workbench_ID;
    }

    public String getName() {
        return this.Name;
    }

    public String getDescription() {
        return this.Description;
    }

    public String getHelp() {
        return this.Help;
    }

    public int getAD_Column_ID() {
        return this.AD_Column_ID;
    }

    public int getAD_Image_ID() {
        return this.AD_Image_ID;
    }

    public int getAD_Color_ID() {
        return this.AD_Color_ID;
    }

    public int getPA_Goal_ID() {
        return this.PA_Goal_ID;
    }

    private boolean initWorkbenchWindows() {
        String sql = "SELECT AD_Window_ID, AD_Form_ID, AD_Process_ID, AD_Task_ID FROM AD_WorkbenchWindow WHERE AD_Workbench_ID=? AND IsActive='Y'ORDER BY SeqNo";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.AD_Workbench_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int AD_Window_ID = rs.getInt(1);
                int AD_Form_ID = rs.getInt(2);
                int AD_Process_ID = rs.getInt(3);
                int AD_Task_ID = rs.getInt(4);
                if (AD_Window_ID > 0) {
                    this.m_windows.add(new WBWindow(1, AD_Window_ID));
                    continue;
                }
                if (AD_Form_ID > 0) {
                    this.m_windows.add(new WBWindow(2, AD_Form_ID));
                    continue;
                }
                if (AD_Process_ID > 0) {
                    this.m_windows.add(new WBWindow(3, AD_Process_ID));
                    continue;
                }
                if (AD_Task_ID <= 0) continue;
                this.m_windows.add(new WBWindow(4, AD_Task_ID));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
            return false;
        }
        return true;
    }

    public int getWindowCount() {
        return this.m_windows.size();
    }

    public int getWindowType(int index) {
        if (index < 0 || index > this.m_windows.size()) {
            return -1;
        }
        WBWindow win = this.m_windows.get(index);
        return win.Type;
    }

    public int getWindowID(int index) {
        if (index < 0 || index > this.m_windows.size()) {
            return -1;
        }
        WBWindow win = this.m_windows.get(index);
        return win.ID;
    }

    public void setMWindow(int index, GridWindow mw) {
        if (index < 0 || index > this.m_windows.size()) {
            throw new IllegalArgumentException("Index invalid: " + index);
        }
        WBWindow win = this.m_windows.get(index);
        if (win.Type != 1) {
            throw new IllegalArgumentException("Not a MWindow: " + index);
        }
        win.mWindow = mw;
    }

    public GridWindow getMWindow(int index) {
        if (index < 0 || index > this.m_windows.size()) {
            throw new IllegalArgumentException("Index invalid: " + index);
        }
        WBWindow win = this.m_windows.get(index);
        if (win.Type != 1) {
            throw new IllegalArgumentException("Not a MWindow: " + index);
        }
        return win.mWindow;
    }

    public String getName(int index) {
        if (index < 0 || index > this.m_windows.size()) {
            throw new IllegalArgumentException("Index invalid: " + index);
        }
        WBWindow win = this.m_windows.get(index);
        if (win.mWindow != null && win.Type == 1) {
            return win.mWindow.getName();
        }
        return null;
    }

    public String getDescription(int index) {
        if (index < 0 || index > this.m_windows.size()) {
            throw new IllegalArgumentException("Index invalid: " + index);
        }
        WBWindow win = this.m_windows.get(index);
        if (win.mWindow != null && win.Type == 1) {
            return win.mWindow.getDescription();
        }
        return null;
    }

    public String getHelp(int index) {
        if (index < 0 || index > this.m_windows.size()) {
            throw new IllegalArgumentException("Index invalid: " + index);
        }
        WBWindow win = this.m_windows.get(index);
        if (win.mWindow != null && win.Type == 1) {
            return win.mWindow.getHelp();
        }
        return null;
    }

    public Icon getIcon(int index) {
        if (index < 0 || index > this.m_windows.size()) {
            throw new IllegalArgumentException("Index invalid: " + index);
        }
        WBWindow win = this.m_windows.get(index);
        if (win.mWindow != null && win.Type == 1) {
            return win.mWindow.getIcon();
        }
        return null;
    }

    public Image getImage(int index) {
        if (index < 0 || index > this.m_windows.size()) {
            throw new IllegalArgumentException("Index invalid: " + index);
        }
        WBWindow win = this.m_windows.get(index);
        if (win.mWindow != null && win.Type == 1) {
            return win.mWindow.getImage();
        }
        return null;
    }

    public int getAD_Color_ID(int index) {
        if (index < 0 || index > this.m_windows.size()) {
            throw new IllegalArgumentException("Index invalid: " + index);
        }
        WBWindow win = this.m_windows.get(index);
        int retValue = -1;
        if (retValue == -1) {
            return this.getAD_Color_ID();
        }
        return retValue;
    }

    public void setWindowNo(int index, int windowNo) {
        if (index < 0 || index > this.m_windows.size()) {
            throw new IllegalArgumentException("Index invalid: " + index);
        }
        WBWindow win = this.m_windows.get(index);
        win.WindowNo = windowNo;
    }

    public int getWindowNo(int index) {
        if (index < 0 || index > this.m_windows.size()) {
            throw new IllegalArgumentException("Index invalid: " + index);
        }
        WBWindow win = this.m_windows.get(index);
        return win.WindowNo;
    }

    public void dispose(int index) {
        if (index < 0 || index > this.m_windows.size()) {
            throw new IllegalArgumentException("Index invalid: " + index);
        }
        WBWindow win = this.m_windows.get(index);
        if (win.mWindow != null) {
            win.mWindow.dispose();
        }
        win.mWindow = null;
    }

    public Dimension getWindowSize() {
        return null;
    }

    class WBWindow {
        public int Type = 0;
        public int ID = 0;
        public int WindowNo = -1;
        public GridWindow mWindow = null;

        public WBWindow(int type, int id) {
            this.Type = type;
            this.ID = id;
        }
    }
}

