/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MPayment;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class CreateFromStatement
extends CreateFrom {
    public MBankAccount bankAccount;

    public CreateFromStatement(GridTab mTab) {
        super(mTab);
        this.log.info(mTab.toString());
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(Msg.translate(Env.getCtx(), "C_BankStatement_ID") + " .. " + Msg.translate(Env.getCtx(), "CreateFrom"));
        return true;
    }

    public String getSQLWhere(String DocumentNo, Object BPartner, Object DateFrom, Object DateTo, Object AmtFrom, Object AmtTo, Object DocType, Object TenderType, String AuthCode) {
        Comparable<Date> to;
        Comparable<Date> from;
        StringBuffer sql = new StringBuffer("WHERE p.Processed='Y' AND p.IsReconciled='N' AND p.DocStatus IN ('CO','CL','RE','VO') AND p.PayAmt<>0 AND p.C_BankAccount_ID = ?");
        sql.append(" AND NOT EXISTS (SELECT * FROM C_BankStatementLine l WHERE p.C_Payment_ID=l.C_Payment_ID AND l.StmtAmt <> 0)");
        if (DocumentNo.length() > 0) {
            sql.append(" AND UPPER(p.DocumentNo) LIKE ?");
        }
        if (BPartner != null) {
            sql.append(" AND p.C_BPartner_ID=?");
        }
        if (DateFrom != null || DateTo != null) {
            from = (Timestamp)DateFrom;
            to = (Timestamp)DateTo;
            if (from == null && to != null) {
                sql.append(" AND TRUNC(p.DateTrx, 'DD') <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND TRUNC(p.DateTrx, 'DD') >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(p.DateTrx, 'DD') BETWEEN ? AND ?");
            }
        }
        if (AmtFrom != null || AmtTo != null) {
            from = (BigDecimal)AmtFrom;
            to = (BigDecimal)AmtTo;
            if (from == null && to != null) {
                sql.append(" AND p.PayAmt <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND p.PayAmt >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND p.PayAmt BETWEEN ? AND ?");
            }
        }
        if (DocType != null) {
            sql.append(" AND p.C_DocType_ID=?");
        }
        if (TenderType != null && TenderType.toString().length() > 0) {
            sql.append(" AND p.TenderType=?");
        }
        if (AuthCode.length() > 0) {
            sql.append(" AND p.R_AuthCode LIKE ?");
        }
        this.log.fine(sql.toString());
        return sql.toString();
    }

    void setParameters(PreparedStatement pstmt, boolean forCount, String DocumentNo, Object BPartner, Object DateFrom, Object DateTo, Object AmtFrom, Object AmtTo, Object DocType, Object TenderType, String AuthCode) throws SQLException {
        Comparable<Date> to;
        Comparable<Date> from;
        int index = 1;
        pstmt.setInt(index++, this.bankAccount.getC_BankAccount_ID());
        if (DocumentNo.length() > 0) {
            pstmt.setString(index++, this.getSQLText(DocumentNo));
        }
        if (BPartner != null) {
            Integer bp = (Integer)BPartner;
            pstmt.setInt(index++, bp);
            this.log.fine("BPartner=" + bp);
        }
        if (DateFrom != null || DateTo != null) {
            from = (Timestamp)DateFrom;
            to = (Timestamp)DateTo;
            this.log.fine("Date From=" + from + ", To=" + to);
            if (from == null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)to);
            } else if (from != null && to == null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
            } else if (from != null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
                pstmt.setTimestamp(index++, (Timestamp)to);
            }
        }
        if (AmtFrom != null || AmtTo != null) {
            from = (BigDecimal)AmtFrom;
            to = (BigDecimal)AmtTo;
            this.log.fine("Amt From=" + from + ", To=" + to);
            if (from == null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            } else if (from != null && to == null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
            } else if (from != null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            }
        }
        if (DocType != null) {
            pstmt.setInt(index++, (Integer)DocType);
        }
        if (TenderType != null && TenderType.toString().length() > 0) {
            pstmt.setString(index++, (String)TenderType);
        }
        if (AuthCode.length() > 0) {
            pstmt.setString(index++, this.getSQLText(AuthCode));
        }
    }

    private String getSQLText(String text) {
        String s = text.toUpperCase();
        if (!s.endsWith("%")) {
            s = s + "%";
        }
        this.log.fine("String=" + s);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<Vector<Object>> getBankData(String DocumentNo, Object BPartner, Object DateFrom, Object DateTo, Object AmtFrom, Object AmtTo, Object DocType, Object TenderType, String AuthCode) {
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        String sql = "SELECT p.DateTrx,p.C_Payment_ID,p.DocumentNo, p.C_Currency_ID,c.ISO_Code, p.PayAmt,currencyConvert(p.PayAmt,p.C_Currency_ID,ba.C_Currency_ID,pay.DateAcct,p.C_ConversionType_ID,p.AD_Client_ID,p.AD_Org_ID), bp.Name FROM C_BankAccount ba INNER JOIN C_Payment_v p ON (p.C_BankAccount_ID=ba.C_BankAccount_ID) INNER JOIN C_Payment pay ON (p.C_Payment_ID=pay.C_Payment_ID) INNER JOIN C_Currency c ON (p.C_Currency_ID=c.C_Currency_ID) LEFT OUTER JOIN C_BPartner bp ON (p.C_BPartner_ID=bp.C_BPartner_ID) ";
        sql = sql + this.getSQLWhere(DocumentNo, BPartner, DateFrom, DateTo, AmtFrom, AmtTo, DocType, TenderType, AuthCode) + " ORDER BY p.DateTrx";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), null);
            this.setParameters(pstmt, false, DocumentNo, BPartner, DateFrom, DateTo, AmtFrom, AmtTo, DocType, TenderType, AuthCode);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>(6);
                line.add(new Boolean(false));
                line.add(rs.getTimestamp(1));
                KeyNamePair pp = new KeyNamePair(rs.getInt(2), rs.getString(3));
                line.add(pp);
                pp = new KeyNamePair(rs.getInt(4), rs.getString(5));
                line.add(pp);
                line.add(rs.getBigDecimal(6));
                line.add(rs.getBigDecimal(7));
                line.add(rs.getString(8));
                data.add(line);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    @Override
    public void info() {
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, Timestamp.class, true);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, BigDecimal.class, true);
        miniTable.setColumnClass(5, BigDecimal.class, true);
        miniTable.setColumnClass(6, String.class, true);
        miniTable.autoSize();
    }

    @Override
    public boolean save(IMiniTable miniTable, String trxName) {
        int C_BankStatement_ID = (Integer)this.getGridTab().getValue("C_BankStatement_ID");
        MBankStatement bs = new MBankStatement(Env.getCtx(), C_BankStatement_ID, trxName);
        this.log.config(bs.toString());
        for (int i = 0; i < miniTable.getRowCount(); ++i) {
            if (!((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) continue;
            Timestamp trxDate = (Timestamp)miniTable.getValueAt(i, 1);
            KeyNamePair pp = (KeyNamePair)miniTable.getValueAt(i, 2);
            int C_Payment_ID = pp.getKey();
            pp = (KeyNamePair)miniTable.getValueAt(i, 3);
            int C_Currency_ID = pp.getKey();
            BigDecimal TrxAmt = (BigDecimal)miniTable.getValueAt(i, 5);
            this.log.fine("Line Date=" + trxDate + ", Payment=" + C_Payment_ID + ", Currency=" + C_Currency_ID + ", Amt=" + TrxAmt);
            MBankStatementLine bsl = new MBankStatementLine(bs);
            bsl.setStatementLineDate(trxDate);
            bsl.setPayment(new MPayment(Env.getCtx(), C_Payment_ID, trxName));
            bsl.setTrxAmt(TrxAmt);
            bsl.setStmtAmt(TrxAmt);
            bsl.setC_Currency_ID(this.bankAccount.getC_Currency_ID());
            if (bsl.save()) continue;
            this.log.log(Level.SEVERE, "Line not created #" + i);
        }
        return true;
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(6);
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "Date"));
        columnNames.add(Msg.getElement(Env.getCtx(), "C_Payment_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_Currency_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "Amount"));
        columnNames.add(Msg.translate(Env.getCtx(), "ConvertedAmount"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        return columnNames;
    }
}

