/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.compiere.Adempiere;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.AWindow;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.PrintScreenPainter;
import org.compiere.apps.StatusBar;
import org.compiere.apps.search.InfoAsset;
import org.compiere.apps.search.InfoAssignment;
import org.compiere.apps.search.InfoBPartner;
import org.compiere.apps.search.InfoCashLine;
import org.compiere.apps.search.InfoGeneral;
import org.compiere.apps.search.InfoInOut;
import org.compiere.apps.search.InfoInvoice;
import org.compiere.apps.search.InfoOrder;
import org.compiere.apps.search.InfoPayment;
import org.compiere.apps.search.InfoProduct;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.Calculator;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.swing.CButton;
import org.compiere.swing.CDialog;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public abstract class Info
extends CDialog
implements ListSelectionListener {
    private static final long serialVersionUID = -5606614040914295869L;
    public static final String SYSCONFIG_INFO_DEFAULTSELECTED = "INFO_DEFAULTSELECTED";
    public static final String SYSCONFIG_INFO_DOUBLECLICKTOGGLESSELECTION = "INFO_DOUBLECLICKTOGGLESSELECTION";
    Toolkit toolkit = Toolkit.getDefaultToolkit();
    Dimension screensize = this.toolkit.getScreenSize();
    protected final int INFO_WIDTH;
    protected final int SCREEN_HEIGHT;
    protected int p_WindowNo;
    protected String p_tableName;
    protected String p_keyColumn;
    protected boolean p_multiSelection;
    private boolean p_isDefaultSelected;
    private boolean p_doubleClickTogglesSelection;
    protected String p_whereClause;
    protected MiniTable p_table;
    private int m_keyColumnIndex;
    private boolean m_ok;
    private boolean m_cancel;
    private ArrayList<Integer> m_results;
    protected Info_Column[] p_layout;
    private String m_sqlMain;
    private String m_sqlCount;
    private String m_sqlOrder;
    protected boolean p_loadedOK;
    private int m_SO_Window_ID;
    private int m_PO_Window_ID;
    private Worker m_worker;
    protected CLogger log;
    private CPanel southPanel;
    private BorderLayout southLayout;
    ConfirmPanel confirmPanel;
    protected CPanel addonPanel;
    protected StatusBar statusBar;
    protected CPanel parameterPanel;
    private JScrollPane scrollPane;
    private JPopupMenu popup;
    private CMenuItem calcMenu;

    public static Info create(Frame frame, boolean modal, int WindowNo, String tableName, String keyColumn, String value, boolean multiSelection, String whereClause) {
        Info info = null;
        info = tableName.equals("C_BPartner") ? new InfoBPartner(frame, modal, WindowNo, value, !Env.getContext(Env.getCtx(), "IsSOTrx").equals("N"), multiSelection, whereClause) : (tableName.equals("M_Product") ? new InfoProduct(frame, modal, WindowNo, 0, 0, value, multiSelection, whereClause) : (tableName.equals("C_Invoice") ? new InfoInvoice(frame, modal, WindowNo, value, multiSelection, whereClause) : (tableName.equals("A_Asset") ? new InfoAsset(frame, modal, WindowNo, 0, value, multiSelection, whereClause) : (tableName.equals("C_Order") ? new InfoOrder(frame, modal, WindowNo, value, multiSelection, whereClause) : (tableName.equals("M_InOut") ? new InfoInOut(frame, modal, WindowNo, value, multiSelection, whereClause) : (tableName.equals("C_Payment") ? new InfoPayment(frame, modal, WindowNo, value, multiSelection, whereClause) : (tableName.equals("C_CashLine") ? new InfoCashLine(frame, modal, WindowNo, value, multiSelection, whereClause) : (tableName.equals("S_ResourceAssigment") ? new InfoAssignment(frame, modal, WindowNo, value, multiSelection, whereClause) : new InfoGeneral(frame, modal, WindowNo, value, tableName, keyColumn, multiSelection, whereClause)))))))));
        AEnv.positionCenterWindow(frame, info);
        return info;
    }

    public static void showBPartner(Frame frame, int WindowNo) {
        InfoBPartner info = new InfoBPartner(frame, false, WindowNo, "", !Env.getContext(Env.getCtx(), "IsSOTrx").equals("N"), false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showAsset(Frame frame, int WindowNo) {
        InfoAsset info = new InfoAsset(frame, false, WindowNo, 0, "", false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showProduct(Frame frame, int WindowNo) {
        InfoProduct info = new InfoProduct(frame, false, WindowNo, Env.getContextAsInt(Env.getCtx(), WindowNo, "M_Warehouse_ID"), Env.getContextAsInt(Env.getCtx(), WindowNo, "M_PriceList_ID"), "", false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showOrder(Frame frame, int WindowNo, String value) {
        InfoOrder info = new InfoOrder(frame, false, WindowNo, value, false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showInvoice(Frame frame, int WindowNo, String value) {
        InfoInvoice info = new InfoInvoice(frame, false, WindowNo, value, false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showInOut(Frame frame, int WindowNo, String value) {
        InfoInOut info = new InfoInOut(frame, false, WindowNo, value, false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showPayment(Frame frame, int WindowNo, String value) {
        InfoPayment info = new InfoPayment(frame, false, WindowNo, value, false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showCashLine(Frame frame, int WindowNo, String value) {
        InfoCashLine info = new InfoCashLine(frame, false, WindowNo, value, false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showAssignment(Frame frame, int WindowNo, String value) {
        InfoAssignment info = new InfoAssignment(frame, false, WindowNo, value, false, "");
        AEnv.showCenterWindow(frame, info);
    }

    protected Info(Frame frame, boolean modal, int WindowNo, String tableName, String keyColumn, boolean multiSelection, String whereClause) {
        super(frame, modal);
        this.INFO_WIDTH = this.screensize.width > 1500 ? 1500 : this.screensize.width - 100;
        this.SCREEN_HEIGHT = this.screensize.height;
        this.p_isDefaultSelected = MSysConfig.getBooleanValue(SYSCONFIG_INFO_DEFAULTSELECTED, false, Env.getAD_Client_ID(Env.getCtx()));
        this.p_doubleClickTogglesSelection = MSysConfig.getBooleanValue(SYSCONFIG_INFO_DOUBLECLICKTOGGLESSELECTION, false, Env.getAD_Client_ID(Env.getCtx()));
        this.p_whereClause = "";
        this.p_table = new MiniTable();
        this.m_keyColumnIndex = -1;
        this.m_ok = false;
        this.m_cancel = false;
        this.m_results = new ArrayList(3);
        this.p_loadedOK = false;
        this.m_SO_Window_ID = -1;
        this.m_PO_Window_ID = -1;
        this.m_worker = null;
        this.log = CLogger.getCLogger(this.getClass());
        this.southPanel = new CPanel();
        this.southLayout = new BorderLayout();
        this.confirmPanel = new ConfirmPanel(true, true, true, true, true, true, true);
        this.addonPanel = new CPanel();
        this.statusBar = new StatusBar();
        this.parameterPanel = new CPanel();
        this.scrollPane = new JScrollPane();
        this.popup = new JPopupMenu();
        this.calcMenu = new CMenuItem();
        this.log.info("WinNo=" + this.p_WindowNo + " " + whereClause);
        this.p_WindowNo = WindowNo;
        this.p_tableName = tableName;
        this.p_keyColumn = keyColumn;
        this.p_multiSelection = multiSelection;
        if (whereClause == null || whereClause.indexOf(64) == -1) {
            this.p_whereClause = whereClause;
        } else {
            this.p_whereClause = Env.parseContext(Env.getCtx(), this.p_WindowNo, whereClause, false, false);
            if (this.p_whereClause.length() == 0) {
                this.log.log(Level.SEVERE, "Cannot parse context= " + whereClause);
            }
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "Info", ex);
        }
    }

    protected void jbInit() throws Exception {
        this.setDefaultCloseOperation(2);
        this.southPanel.setLayout(this.southLayout);
        this.southPanel.add((Component)this.addonPanel, "North");
        this.southPanel.add((Component)this.confirmPanel, "Center");
        this.southPanel.add((Component)this.statusBar, "South");
        this.getContentPane().add((Component)this.southPanel, "South");
        this.getContentPane().add((Component)this.parameterPanel, "North");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.p_table, null);
        this.confirmPanel.addActionListener(this);
        this.confirmPanel.getResetButton().setVisible(this.hasReset());
        this.confirmPanel.getCustomizeButton().setVisible(this.hasCustomize());
        this.confirmPanel.getHistoryButton().setVisible(this.hasHistory());
        this.confirmPanel.getZoomButton().setVisible(this.hasZoom());
        CButton print = ConfirmPanel.createPrintButton(true);
        print.addActionListener(this);
        this.confirmPanel.addButton(print);
        this.popup.add(this.calcMenu);
        this.calcMenu.setText(Msg.getMsg(Env.getCtx(), "Calculator"));
        this.calcMenu.setIcon(new ImageIcon(Adempiere.class.getResource("images/Calculator16.gif")));
        this.calcMenu.addActionListener(this);
        this.p_table.getSelectionModel().addListSelectionListener(this);
        this.enableButtons();
    }

    public boolean loadedOK() {
        return this.p_loadedOK;
    }

    public void setStatusLine(String text, boolean error) {
        this.statusBar.setStatusLine(text, error);
        Thread.yield();
    }

    public void setStatusDB(String text) {
        this.statusBar.setStatusDB(text);
    }

    protected void prepareTable(Info_Column[] layout, String from, String staticWhere, String orderBy) {
        int i;
        this.p_layout = layout;
        StringBuffer sql = new StringBuffer("SELECT ");
        for (i = 0; i < layout.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(layout[i].getColSQL());
            if (layout[i].isIDcol()) {
                sql.append(",").append(layout[i].getIDcolSQL());
            }
            this.p_table.addColumn(layout[i].getColHeader());
            if (layout[i].isColorColumn()) {
                this.p_table.setColorColumn(i);
            }
            if (layout[i].getColClass() != IDColumn.class) continue;
            this.m_keyColumnIndex = i;
        }
        this.p_table.setRowSelectionAllowed(true);
        this.p_table.addMouseListener(this);
        this.p_table.setMultiSelection(this.p_multiSelection);
        this.p_table.setShowTotals(true);
        for (i = 0; i < layout.length; ++i) {
            this.p_table.setColumnClass(i, layout[i].getColClass(), layout[i].isReadOnly(), layout[i].getColHeader());
        }
        sql.append(" FROM ").append(from);
        sql.append(" WHERE ").append(staticWhere);
        this.m_sqlMain = sql.toString();
        this.m_sqlCount = "SELECT COUNT(*) FROM " + from + " WHERE " + staticWhere;
        this.m_sqlOrder = "";
        if (orderBy != null && orderBy.length() > 0) {
            this.m_sqlOrder = " ORDER BY " + orderBy;
        }
        if (this.m_keyColumnIndex == -1) {
            this.log.log(Level.SEVERE, "No KeyColumn - " + sql);
        }
        this.parameterPanel.setPreferredSize(new Dimension(this.INFO_WIDTH, this.parameterPanel.getPreferredSize().height));
        this.scrollPane.setPreferredSize(new Dimension(this.INFO_WIDTH, 300));
    }

    protected void executeQuery() {
        if (this.m_worker != null && this.m_worker.isAlive()) {
            return;
        }
        if (!this.testCount()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setStatusLine(Msg.getMsg(Env.getCtx(), "StartSearch"), false);
        this.m_worker = new Worker();
        this.m_worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testCount() {
        int no;
        ResultSet rs;
        CPreparedStatement pstmt;
        long start;
        block6: {
            start = System.currentTimeMillis();
            String dynWhere = this.getSQLWhere();
            StringBuffer sql = new StringBuffer(this.m_sqlCount);
            if (dynWhere.length() > 0) {
                sql.append(dynWhere);
            }
            String countSql = Msg.parseTranslation(Env.getCtx(), sql.toString());
            countSql = MRole.getDefault().addAccessSQL(countSql, this.getTableName(), true, false);
            this.log.finer(countSql);
            pstmt = null;
            rs = null;
            no = -1;
            try {
                pstmt = DB.prepareStatement(countSql, null);
                this.setParameters(pstmt, true);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block6;
                no = rs.getInt(1);
            }
            catch (Exception e) {
                try {
                    this.log.log(Level.SEVERE, countSql, e);
                    no = -2;
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.log.fine("#" + no + " - " + (System.currentTimeMillis() - start) + "ms");
        MRole role = MRole.getDefault();
        if (role.isQueryMax(no)) {
            return ADialog.ask(this.p_WindowNo, this, "InfoHighRecordCount", String.valueOf(no));
        }
        return true;
    }

    protected void saveSelection() {
        if (this.p_table == null) {
            return;
        }
        this.log.config("OK=" + this.m_ok);
        if (!this.m_ok) {
            this.m_results.clear();
            this.p_table.removeAll();
            this.p_table = null;
            return;
        }
        if (this.p_multiSelection) {
            this.m_results.addAll(this.getSelectedRowKeys());
        } else {
            Integer data = this.getSelectedRowKey();
            if (data != null) {
                this.m_results.add(data);
            }
        }
        this.log.config(this.getSelectedSQL());
        this.saveSelectionDetail();
        this.p_table.removeAll();
        this.p_table = null;
    }

    protected Integer getSelectedRowKey() {
        ArrayList<Integer> selectedDataList = this.getSelectedRowKeys();
        if (selectedDataList.size() == 0) {
            return null;
        }
        return selectedDataList.get(0);
    }

    protected ArrayList<Integer> getSelectedRowKeys() {
        int row;
        ArrayList<Integer> selectedDataList = new ArrayList<Integer>();
        if (this.m_keyColumnIndex == -1) {
            return selectedDataList;
        }
        if (this.p_multiSelection) {
            int rows = this.p_table.getRowCount();
            for (int row2 = 0; row2 < rows; ++row2) {
                if (this.p_table.getShowTotals() && row2 == rows - 1) continue;
                Object data = this.p_table.getModel().getValueAt(row2, this.m_keyColumnIndex);
                if (data instanceof IDColumn) {
                    IDColumn dataColumn = (IDColumn)data;
                    if (!dataColumn.isSelected()) continue;
                    selectedDataList.add(dataColumn.getRecord_ID());
                    continue;
                }
                this.log.severe("For multiple selection, IDColumn should be key column for selection");
            }
        }
        if (selectedDataList.size() == 0 && (row = this.p_table.getSelectedRow()) != -1 && this.m_keyColumnIndex != -1) {
            Object data = this.p_table.getModel().getValueAt(row, this.m_keyColumnIndex);
            if (data instanceof IDColumn) {
                selectedDataList.add(((IDColumn)data).getRecord_ID());
            }
            if (data instanceof Integer) {
                selectedDataList.add((Integer)data);
            }
        }
        return selectedDataList;
    }

    public Object[] getSelectedKeys() {
        if (!this.m_ok || this.m_results.size() == 0) {
            return null;
        }
        Object[] values = new Integer[this.m_results.size()];
        this.m_results.toArray(values);
        return values;
    }

    public Object getSelectedKey() {
        if (!this.m_ok || this.m_results.size() == 0) {
            return null;
        }
        return this.m_results.get(0);
    }

    public boolean isCancelled() {
        return this.m_cancel;
    }

    public String getSelectedSQL() {
        Object[] keys = this.getSelectedKeys();
        if (keys == null || keys.length == 0) {
            this.log.config("No Results - OK=" + this.m_ok + ", Cancel=" + this.m_cancel);
            return "";
        }
        StringBuffer sb = new StringBuffer(this.getKeyColumn());
        if (keys.length > 1) {
            sb.append(" IN (");
        } else {
            sb.append("=");
        }
        for (int i = 0; i < keys.length; ++i) {
            if (this.getKeyColumn().endsWith("_ID")) {
                sb.append(keys[i].toString()).append(",");
                continue;
            }
            sb.append("'").append(keys[i].toString()).append("',");
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        if (keys.length > 1) {
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.calcMenu)) {
            BigDecimal number = null;
            Object data = this.p_table.getSelectedValue();
            try {
                if (data != null) {
                    number = data instanceof BigDecimal ? (BigDecimal)data : new BigDecimal(data.toString());
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            Calculator c = new Calculator(null, number);
            c.setVisible(true);
            return;
        }
        String cmd = e.getActionCommand();
        if (cmd.equals("Ok")) {
            this.dispose(true);
        } else if (cmd.equals("Cancel")) {
            this.m_cancel = true;
            this.dispose(false);
        } else if (cmd.equals("History")) {
            this.showHistory();
        } else if (cmd.equals("Customize")) {
            this.customize();
        } else if (cmd.equals("Zoom")) {
            this.zoom();
        } else if (cmd.equals("Reset")) {
            this.doReset();
        } else if (cmd.equals("Print")) {
            PrintScreenPainter.printScreen(this);
        } else {
            this.executeQuery();
        }
    }

    protected void zoom(int AD_Window_ID, MQuery zoomQuery) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        final AWindow frame = new AWindow();
        if (!frame.initWindow(AD_Window_ID, zoomQuery)) {
            return;
        }
        AEnv.addToWindowManager(frame);
        if (this.isModal()) {
            this.setModal(false);
            this.dispose();
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    1.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AEnv.showCenterScreen(frame);
            }
        }.start();
    }

    @Override
    public void dispose() {
        this.dispose(false);
    }

    public void dispose(boolean ok) {
        this.log.config("OK=" + ok);
        this.m_ok = ok;
        if (this.m_worker != null) {
            if (this.m_worker.isAlive()) {
                this.m_worker.interrupt();
            }
            this.log.config("Worker alive=" + this.m_worker.isAlive());
        }
        this.m_worker = null;
        this.saveSelection();
        this.removeAll();
        super.dispose();
    }

    protected String getTableName() {
        return this.p_tableName;
    }

    protected String getKeyColumn() {
        return this.p_keyColumn;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.enableButtons();
    }

    protected void enableButtons() {
        boolean enable = this.p_table.getSelectedRowCount() == 1;
        this.confirmPanel.getOKButton().setEnabled(this.p_table.getSelectedRowCount() > 0);
        if (this.hasHistory()) {
            this.confirmPanel.getHistoryButton().setEnabled(enable);
        }
        if (this.hasZoom()) {
            this.confirmPanel.getZoomButton().setEnabled(enable);
        }
    }

    protected abstract String getSQLWhere();

    protected abstract void setParameters(PreparedStatement var1, boolean var2) throws SQLException;

    protected void doReset() {
    }

    protected boolean hasReset() {
        return false;
    }

    protected void showHistory() {
    }

    protected boolean hasHistory() {
        return false;
    }

    protected void customize() {
    }

    protected boolean hasCustomize() {
        return false;
    }

    protected void zoom() {
    }

    protected boolean hasZoom() {
        return false;
    }

    protected void saveSelectionDetail() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getAD_Window_ID(String tableName, boolean isSOTrx) {
        ResultSet rs;
        CPreparedStatement pstmt;
        block7: {
            if (!isSOTrx && this.m_PO_Window_ID > 0) {
                return this.m_PO_Window_ID;
            }
            if (this.m_SO_Window_ID > 0) {
                return this.m_SO_Window_ID;
            }
            String sql = "SELECT AD_Window_ID, PO_Window_ID FROM AD_Table WHERE TableName=?";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setString(1, tableName);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block7;
                this.m_SO_Window_ID = rs.getInt(1);
                this.m_PO_Window_ID = rs.getInt(2);
            }
            catch (Exception e) {
                try {
                    this.log.log(Level.SEVERE, sql, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (!isSOTrx && this.m_PO_Window_ID > 0) {
            return this.m_PO_Window_ID;
        }
        return this.m_SO_Window_ID;
    }

    protected int getKeyColumnIndex() {
        return this.m_keyColumnIndex;
    }

    public boolean isOkPressed() {
        return this.m_ok;
    }

    public boolean isCancelPressed() {
        return this.m_cancel;
    }

    public void setDefaultSelected(boolean value) {
        this.p_isDefaultSelected = value;
    }

    public boolean isDefaultSelected() {
        return this.p_isDefaultSelected;
    }

    public void setDoubleClickTogglesSelection(boolean value) {
        this.p_doubleClickTogglesSelection = value;
    }

    public boolean isDoubleClickTogglesSelection() {
        return this.p_doubleClickTogglesSelection;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1 && this.p_table.getSelectedRow() != -1) {
            if (this.p_multiSelection && this.isDoubleClickTogglesSelection()) {
                Object data;
                if (this.m_keyColumnIndex >= 0 && (data = this.p_table.getValueAt(this.p_table.getSelectedRow(), this.m_keyColumnIndex)) instanceof IDColumn) {
                    IDColumn id;
                    id.setSelected(!(id = (IDColumn)data).isSelected());
                    this.p_table.setValueAt(data, this.p_table.getSelectedRow(), this.m_keyColumnIndex);
                }
            } else {
                this.dispose(true);
            }
        } else if (SwingUtilities.isRightMouseButton(e)) {
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    class Worker
    extends Thread {
        private PreparedStatement m_pstmt = null;
        private ResultSet m_rs = null;

        Worker() {
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            Info.this.p_table.setRowCount(0);
            String dynWhere = Info.this.getSQLWhere();
            StringBuffer sql = new StringBuffer(Info.this.m_sqlMain);
            if (dynWhere.length() > 0) {
                sql.append(dynWhere);
            }
            sql.append(Info.this.m_sqlOrder);
            String dataSql = Msg.parseTranslation(Env.getCtx(), sql.toString());
            dataSql = MRole.getDefault().addAccessSQL(dataSql, Info.this.getTableName(), true, false);
            Info.this.log.finer(dataSql);
            try {
                this.m_pstmt = DB.prepareStatement(dataSql, null);
                Info.this.setParameters(this.m_pstmt, false);
                Info.this.log.fine("Start query - " + (System.currentTimeMillis() - start) + "ms");
                this.m_rs = this.m_pstmt.executeQuery();
                Info.this.log.fine("End query - " + (System.currentTimeMillis() - start) + "ms");
                while (this.m_rs.next()) {
                    if (this.isInterrupted()) {
                        Info.this.log.finer("Interrupted");
                        this.close();
                        return;
                    }
                    int row = Info.this.p_table.getRowCount();
                    Info.this.p_table.setRowCount(row + 1);
                    int colOffset = 1;
                    for (int col = 0; col < Info.this.p_layout.length; ++col) {
                        Object data = null;
                        Class<?> c = Info.this.p_layout[col].getColClass();
                        int colIndex = col + colOffset;
                        if (c == IDColumn.class) {
                            data = new IDColumn(this.m_rs.getInt(colIndex));
                            if (Info.this.p_multiSelection) {
                                ((IDColumn)data).setSelected(Info.this.isDefaultSelected());
                            }
                        } else if (c == Boolean.class) {
                            data = new Boolean("Y".equals(this.m_rs.getString(colIndex)));
                        } else if (c == Timestamp.class) {
                            data = this.m_rs.getTimestamp(colIndex);
                        } else if (c == BigDecimal.class) {
                            data = this.m_rs.getBigDecimal(colIndex);
                        } else if (c == Double.class) {
                            data = new Double(this.m_rs.getDouble(colIndex));
                        } else if (c == Integer.class) {
                            data = new Integer(this.m_rs.getInt(colIndex));
                        } else if (c == KeyNamePair.class) {
                            String display = this.m_rs.getString(colIndex);
                            int key = this.m_rs.getInt(colIndex + 1);
                            data = new KeyNamePair(key, display);
                            ++colOffset;
                        } else {
                            data = this.m_rs.getString(colIndex);
                        }
                        Info.this.p_table.setValueAt(data, row, col);
                    }
                }
            }
            catch (SQLException e) {
                Info.this.log.log(Level.SEVERE, dataSql, e);
            }
            this.close();
            int no = Info.this.p_table.getRowCount();
            Info.this.log.fine("#" + no + " - " + (System.currentTimeMillis() - start) + "ms");
            if (Info.this.p_table.getShowTotals()) {
                Info.this.p_table.addTotals(Info.this.p_layout);
            }
            Info.this.p_table.autoSize();
            Info.this.setCursor(Cursor.getDefaultCursor());
            Info.this.setStatusLine(Integer.toString(no) + " " + Msg.getMsg(Env.getCtx(), "SearchRows_EnterQuery"), false);
            Info.this.setStatusDB(Integer.toString(no));
            if (no == 0) {
                Info.this.log.fine(dataSql);
            } else {
                Info.this.p_table.getSelectionModel().setSelectionInterval(0, 0);
                Info.this.p_table.requestFocus();
            }
        }

        private void close() {
            DB.close(this.m_rs, this.m_pstmt);
            this.m_rs = null;
            this.m_pstmt = null;
        }

        @Override
        public void interrupt() {
            if (this.m_pstmt != null) {
                try {
                    this.m_pstmt.cancel();
                    this.close();
                }
                catch (SQLException e) {
                    Info.this.log.log(Level.SEVERE, "Cannot cancel SQL statement", e);
                }
            }
            super.interrupt();
        }
    }
}

