/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.ADialogDialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.ProcessCtl;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.GenForm;
import org.compiere.apps.form.VInOutGen;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MQuery;
import org.compiere.model.MTable;
import org.compiere.model.PrintInfo;
import org.compiere.plaf.CompiereColor;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportCtl;
import org.compiere.print.ReportEngine;
import org.compiere.print.Viewer;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTabbedPane;
import org.compiere.swing.CTextPane;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VGenPanel
extends CPanel
implements ActionListener,
ChangeListener,
TableModelListener,
ASyncProcess {
    private static final long serialVersionUID = 8154208229173738517L;
    private GenForm genForm;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private static CLogger log = CLogger.getCLogger(VInOutGen.class);
    private CTabbedPane tabbedPane = new CTabbedPane();
    private CPanel selPanel = new CPanel();
    private CPanel selNorthPanel = new CPanel();
    private BorderLayout selPanelLayout = new BorderLayout();
    private FlowLayout northPanelLayout = new FlowLayout();
    private ConfirmPanel confirmPanelSel = new ConfirmPanel(true);
    private ConfirmPanel confirmPanelGen = new ConfirmPanel(false, true, false, false, false, false, true);
    private StatusBar statusBar = new StatusBar();
    private CPanel genPanel = new CPanel();
    private BorderLayout genLayout = new BorderLayout();
    private CTextPane info = new CTextPane();
    private JScrollPane scrollPane = new JScrollPane();
    private MiniTable miniTable = new MiniTable();

    public VGenPanel(GenForm genForm, int WindowNo, FormFrame frame) {
        log.info("");
        this.genForm = genForm;
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.jbInit();
            this.dynInit();
            frame.getContentPane().add((Component)this.tabbedPane, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "init", ex);
        }
    }

    void jbInit() throws Exception {
        CompiereColor.setBackground(this);
        this.selPanel.setLayout(this.selPanelLayout);
        this.selNorthPanel.setLayout(this.northPanelLayout);
        this.northPanelLayout.setAlignment(0);
        this.tabbedPane.add((Component)this.selPanel, Msg.getMsg(Env.getCtx(), "Select"));
        this.selPanel.add((Component)this.selNorthPanel, "North");
        this.selPanel.setName("selPanel");
        this.selPanel.add((Component)this.confirmPanelSel, "South");
        this.selPanel.add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.miniTable, null);
        this.confirmPanelSel.addActionListener(this);
        this.tabbedPane.add((Component)this.genPanel, Msg.getMsg(Env.getCtx(), "Generate"));
        this.genPanel.setLayout(this.genLayout);
        this.genPanel.add((Component)this.info, "Center");
        this.genPanel.setEnabled(false);
        this.info.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.info.setEditable(false);
        this.genPanel.add((Component)this.confirmPanelGen, "South");
        this.confirmPanelGen.addActionListener(this);
    }

    private void dynInit() {
        this.genForm.configureMiniTable(this.miniTable);
        this.miniTable.setRowSelectionAllowed(true);
        this.miniTable.getModel().addTableModelListener(this);
        this.statusBar.setStatusDB(" ");
        this.tabbedPane.addChangeListener(this);
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info("Cmd=" + e.getActionCommand());
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
            return;
        }
        try {
            this.genForm.validate();
        }
        catch (Exception ex) {
            ADialog.error(this.m_WindowNo, this, "Error", ex.getLocalizedMessage());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int index = this.tabbedPane.getSelectedIndex();
        this.genForm.setSelectionActive(index == 0);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int rowsSelected = 0;
        int rows = this.miniTable.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IDColumn id = (IDColumn)this.miniTable.getValueAt(i, 0);
            if (id == null || !id.isSelected()) continue;
            ++rowsSelected;
        }
        this.statusBar.setStatusDB(" " + rowsSelected + " ");
    }

    public void saveSelection() {
        this.miniTable.editingStopped(new ChangeEvent(this));
        this.genForm.saveSelection(this.miniTable);
    }

    public void generate() {
        this.info.setText(this.genForm.generate());
        ProcessCtl worker = new ProcessCtl(this, Env.getWindowNo(this), this.genForm.getProcessInfo(), this.genForm.getTrx());
        worker.start();
    }

    public void generateComplete(ProcessInfo pi) {
        this.tabbedPane.setSelectedIndex(1);
        ProcessInfoUtil.setLogFromDB(pi);
        StringBuffer iText = new StringBuffer();
        iText.append("<b>").append(pi.getSummary()).append("</b><br>(").append(Msg.getMsg(Env.getCtx(), this.genForm.getTitle())).append(")<br>").append(pi.getLogInfo(true));
        this.info.setText(iText.toString());
        int[] ids = pi.getIDs();
        if (ids == null || ids.length == 0) {
            return;
        }
        log.config("PrintItems=" + ids.length);
        this.confirmPanelGen.getOKButton().setEnabled(false);
        if (ADialog.ask(this.m_WindowNo, this, this.genForm.getAskPrintMsg())) {
            ADialogDialog d;
            this.setCursor(Cursor.getPredefinedCursor(3));
            int retValue = ADialogDialog.A_CANCEL;
            do {
                for (int i = 0; i < ids.length; ++i) {
                    int Record_ID = ids[i];
                    if (this.genForm.getPrintFormat() != null) {
                        MPrintFormat format = this.genForm.getPrintFormat();
                        MTable table2 = MTable.get(Env.getCtx(), format.getAD_Table_ID());
                        MQuery query = new MQuery(table2.getTableName());
                        query.addRestriction(table2.getTableName() + "_ID", "=", Record_ID);
                        PrintInfo info = new PrintInfo(table2.getTableName(), table2.get_Table_ID(), Record_ID);
                        ReportEngine re = new ReportEngine(Env.getCtx(), format, query, info);
                        re.print();
                        new Viewer(this.m_frame.getGraphicsConfiguration(), re);
                        continue;
                    }
                    ReportCtl.startDocumentPrint(this.genForm.getReportEngineType(), Record_ID, this, Env.getWindowNo(this), true);
                }
            } while ((retValue = (d = new ADialogDialog((Frame)this.m_frame, Env.getHeader(Env.getCtx(), this.m_WindowNo), Msg.getMsg(Env.getCtx(), "PrintoutOK?"), 3)).getReturnCode()) == ADialogDialog.A_CANCEL);
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.confirmPanelGen.getOKButton().setEnabled(true);
    }

    @Override
    public void lockUI(ProcessInfo pi) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setEnabled(false);
    }

    @Override
    public void unlockUI(ProcessInfo pi) {
        this.setEnabled(true);
        this.setCursor(Cursor.getDefaultCursor());
        this.generateComplete(pi);
    }

    @Override
    public boolean isUILocked() {
        return this.isEnabled();
    }

    @Override
    public void executeASync(ProcessInfo pi) {
    }

    public CPanel getParameterPanel() {
        return this.selNorthPanel;
    }

    public MiniTable getMiniTable() {
        return this.miniTable;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }
}

