/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.Charge;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.minigrid.MiniTable;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CPanel;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class VCharge
extends Charge
implements FormPanel,
ActionListener {
    private CPanel panel = new CPanel();
    private FormFrame m_frame;
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel newPanel = new CPanel();
    private TitledBorder newBorder;
    private GridBagLayout newLayout = new GridBagLayout();
    private JLabel valueLabel = new JLabel();
    private JTextField valueField = new JTextField();
    private JCheckBox isExpense = new JCheckBox();
    private JLabel nameLabel = new JLabel();
    private JTextField nameField = new JTextField();
    private JButton newButton = new JButton();
    private CPanel accountPanel = new CPanel();
    private TitledBorder accountBorder;
    private BorderLayout accountLayout = new BorderLayout();
    private CPanel accountOKPanel = new CPanel();
    private JButton accountButton = new JButton();
    private FlowLayout accountOKLayout = new FlowLayout();
    private JScrollPane dataPane = new JScrollPane();
    private MiniTable dataTable = new MiniTable();
    private ConfirmPanel confirmPanel = new ConfirmPanel();

    @Override
    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.jbInit();
            this.dynInit();
            frame.getContentPane().add((Component)this.mainPanel, "Center");
            frame.getContentPane().add((Component)this.confirmPanel, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground(this.panel);
        this.newBorder = new TitledBorder("");
        this.accountBorder = new TitledBorder("");
        this.mainPanel.setLayout(this.mainLayout);
        this.newPanel.setBorder(this.newBorder);
        this.newPanel.setLayout(this.newLayout);
        this.newBorder.setTitle(Msg.getMsg(Env.getCtx(), "ChargeNewAccount"));
        this.valueLabel.setText(Msg.translate(Env.getCtx(), "Value"));
        this.isExpense.setSelected(true);
        this.isExpense.setText(Msg.getMsg(Env.getCtx(), "Expense"));
        this.nameLabel.setText(Msg.translate(Env.getCtx(), "Name"));
        this.nameField.setColumns(20);
        this.valueField.setColumns(10);
        this.newButton.setText(Msg.getMsg(Env.getCtx(), "Create") + " " + Util.cleanAmp(Msg.getMsg(Env.getCtx(), "New")));
        this.newButton.addActionListener(this);
        this.accountPanel.setBorder(this.accountBorder);
        this.accountPanel.setLayout(this.accountLayout);
        this.accountBorder.setTitle(Msg.getMsg(Env.getCtx(), "ChargeFromAccount"));
        this.accountButton.setText(Msg.getMsg(Env.getCtx(), "Create") + " " + Msg.getMsg(Env.getCtx(), "From") + " " + Msg.getElement(Env.getCtx(), "Account_ID"));
        this.accountButton.addActionListener(this);
        this.accountOKPanel.setLayout(this.accountOKLayout);
        this.accountOKLayout.setAlignment(2);
        this.confirmPanel.addActionListener(this);
        this.mainPanel.add((Component)this.newPanel, "North");
        this.newPanel.add((Component)this.valueLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.newPanel.add((Component)this.valueField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.newPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.newPanel.add((Component)this.nameField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.newPanel.add((Component)this.isExpense, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.newPanel.add((Component)this.newButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.accountPanel, "Center");
        this.accountPanel.add((Component)this.accountOKPanel, "South");
        this.accountOKPanel.add((Component)this.accountButton, null);
        this.accountPanel.add((Component)this.dataPane, "Center");
        this.dataPane.getViewport().add((Component)this.dataTable, null);
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info(e.getActionCommand());
        if (e.getActionCommand().equals("Ok") || this.m_C_Element_ID == 0) {
            this.dispose();
        } else if (e.getSource().equals(this.newButton)) {
            this.createNew();
        } else if (e.getSource().equals(this.accountButton)) {
            this.createAccount();
        }
    }

    private void createNew() {
        log.config("");
        String value = this.valueField.getText();
        if (value.length() == 0) {
            this.valueField.setBackground(AdempierePLAF.getFieldBackground_Error());
            return;
        }
        String name = this.nameField.getText();
        if (name.length() == 0) {
            this.nameField.setBackground(AdempierePLAF.getFieldBackground_Error());
            return;
        }
        int C_ElementValue_ID = this.createElementValue(value, name, this.isExpense.isSelected());
        if (C_ElementValue_ID == 0) {
            ADialog.error(this.m_WindowNo, this.panel, "ChargeNotCreated", name);
            return;
        }
        int C_Charge_ID = this.createCharge(name, C_ElementValue_ID);
        if (C_Charge_ID == 0) {
            ADialog.error(this.m_WindowNo, this.panel, "ChargeNotCreated", name);
            return;
        }
        ADialog.info(this.m_WindowNo, this.panel, "ChargeCreated", name);
    }

    private void createAccount() {
        this.createAccount(this.dataTable);
        if (this.listCreated.length() > 0) {
            ADialog.info(this.m_WindowNo, this.panel, "ChargeCreated", this.listCreated.toString());
        }
        if (this.listRejected.length() > 0) {
            ADialog.error(this.m_WindowNo, this.panel, "ChargeNotCreated", this.listRejected.toString());
        }
    }

    private void dynInit() {
        this.findChargeElementID();
        DefaultTableModel model = new DefaultTableModel(this.getData(), this.getColumnNames());
        this.dataTable.setModel(model);
        this.setColumnClass(this.dataTable);
        this.findTaxCategoryID();
    }
}

