/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

class Worker
extends Thread {
    private String m_urlString = null;
    private HashMap<String, String> m_links = null;

    Worker(String urlString, HashMap<String, String> links) {
        this.m_urlString = urlString;
        this.m_links = links;
        this.setPriority(1);
    }

    @Override
    public void run() {
        if (this.m_links == null) {
            return;
        }
        URL url = null;
        try {
            url = new URL(this.m_urlString);
        }
        catch (Exception e) {
            System.err.println("OnlineHelp.Worker.run (url) - " + e);
        }
        if (url == null) {
            return;
        }
        try {
            URLConnection conn = url.openConnection();
            InputStream is = conn.getInputStream();
            HTMLEditorKit kit = new HTMLEditorKit();
            HTMLDocument doc = (HTMLDocument)kit.createDefaultDocument();
            doc.putProperty("IgnoreCharsetDirective", new Boolean(true));
            kit.read(new InputStreamReader(is), (Document)doc, 0);
            HTMLDocument.Iterator it = doc.getIterator(HTML.Tag.A);
            Object target = null;
            Object href = null;
            while (it != null && it.isValid()) {
                String hrefString;
                AttributeSet as = it.getAttributes();
                if (target == null || href == null) {
                    Enumeration<?> en = as.getAttributeNames();
                    while (en.hasMoreElements()) {
                        Object o = en.nextElement();
                        if (target == null && o.toString().equals("target")) {
                            target = o;
                            continue;
                        }
                        if (href != null || !o.toString().equals("href")) continue;
                        href = o;
                    }
                }
                if (target != null && "Online".equals(as.getAttribute(target)) && (hrefString = (String)as.getAttribute(href)) != null) {
                    try {
                        String AD_Window_ID = hrefString.substring(hrefString.indexOf(47, 1), hrefString.lastIndexOf(47));
                        this.m_links.put(AD_Window_ID, hrefString);
                    }
                    catch (Exception e) {
                        System.err.println("OnlineHelp.Worker.run (help) - " + e);
                    }
                }
                it.next();
            }
            is.close();
        }
        catch (ConnectException e) {
        }
        catch (UnknownHostException uhe) {
        }
        catch (Exception e) {
            System.err.println("OnlineHelp.Worker.run (e) " + e);
        }
        catch (Throwable t) {
            System.err.println("OnlineHelp.Worker.run (t) " + t);
        }
    }

    private void dumpTags(HTMLDocument doc, HTML.Tag tag) {
        System.out.println("Doc=" + doc.getBase() + ", Tag=" + tag);
        HTMLDocument.Iterator it = doc.getIterator(tag);
        while (it != null && it.isValid()) {
            AttributeSet as = it.getAttributes();
            System.out.println("~ " + as);
            it.next();
        }
    }
}

