/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.I_AD_EntityType;
import org.compiere.model.MEntityType;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class EntityTypeElementHandler
extends AbstractElementHandler {
    public static final String TAG_Name = "entitytype";
    private final List<Integer> entityTypes = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String Object_Status;
        int AD_Backup_ID;
        String elementValue = element.getElementValue();
        Attributes atts = element.attributes;
        String entitytype = atts.getValue("EntityType");
        this.log.info(elementValue + " " + entitytype);
        if (!this.isProcessElement(ctx, entitytype)) {
            element.skip = true;
            return;
        }
        int id = this.get_IDWithColumn(ctx, "AD_EntityType", "EntityType", entitytype);
        MEntityType entity = new MEntityType(ctx, id, this.getTrxName(ctx));
        if (id <= 0 && this.getIntValue(atts, "AD_EntityType_ID", 0) <= 999999) {
            entity.setAD_EntityType_ID(this.getIntValue(atts, "AD_EntityType_ID", 0));
        }
        if (id > 0) {
            AD_Backup_ID = this.copyRecord(ctx, "AD_EntityType", entity);
            Object_Status = "Update";
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
        }
        entity.setName(this.getStringValue(atts, "Name"));
        entity.setDescription(this.getStringValue(atts, "Description"));
        entity.setHelp(this.getStringValue(atts, "Help"));
        entity.setEntityType(this.getStringValue(atts, "EntityType"));
        entity.setVersion(atts.getValue("Version"));
        entity.setIsActive(this.getBooleanValue(atts, "IsActive", true));
        entity.setModelPackage(this.getStringValue(atts, "ModelPackage"));
        entity.setClasspath(this.getStringValue(atts, "Classpath"));
        if (entity.save(this.getTrxName(ctx))) {
            this.record_log(ctx, 1, entity.getEntityType(), TAG_Name, entity.get_ID(), AD_Backup_ID, Object_Status, "AD_EntityType", I_AD_EntityType.Table_ID);
            return;
        }
        this.record_log(ctx, 0, entity.getEntityType(), TAG_Name, entity.get_ID(), AD_Backup_ID, Object_Status, "AD_EntityType", I_AD_EntityType.Table_ID);
        throw new POSaveFailedException("Failed to save message.");
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int AD_EntityType_ID = Env.getContextAsInt(ctx, "AD_EntityType_ID");
        if (this.entityTypes.contains(AD_EntityType_ID)) {
            return;
        }
        this.entityTypes.add(AD_EntityType_ID);
        MEntityType entity = new MEntityType(ctx, AD_EntityType_ID, null);
        AttributesImpl atts = new AttributesImpl();
        this.createMessageBinding(atts, entity);
        document.startElement("", "", TAG_Name, atts);
        document.endElement("", "", TAG_Name);
    }

    private AttributesImpl createMessageBinding(AttributesImpl atts, MEntityType entity) {
        atts.clear();
        if (entity.getAD_EntityType_ID() <= 999999) {
            this.addAttribute(atts, "AD_EntityType_ID", entity);
        }
        this.addAttribute(atts, "Name", entity);
        this.addAttribute(atts, "Description", entity);
        this.addAttribute(atts, "Help", entity);
        this.addAttribute(atts, "EntityType", entity);
        this.addAttribute(atts, "Version", entity);
        this.addAttribute(atts, "IsActive", entity);
        this.addAttribute(atts, "ModelPackage", entity);
        this.addAttribute(atts, "Classpath", entity);
        return atts;
    }

    protected boolean getBooleanValue(Attributes atts, String qName, boolean defaultValue) {
        String s = atts.getValue(qName);
        return s != null ? Boolean.valueOf(s) : defaultValue;
    }

    protected int getIntValue(Attributes atts, String qName, int defaultValue) {
        String o = atts.getValue(qName);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return ((Number)((Object)o)).intValue();
        }
        return Integer.parseInt(o.toString());
    }

    private final void addAttribute(AttributesImpl atts, String name, PO po) {
        Object value = po.get_Value(name);
        atts.addAttribute("", "", name, "CDATA", this.toStringAttribute(value));
    }

    private final String toStringAttribute(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Boolean) {
            return (Boolean)value == true ? "true" : "false";
        }
        return value.toString();
    }
}

