/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.compiere.Adempiere;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class CodeSnipitElementHandler
extends AbstractElementHandler {
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String elementValue = element.getElementValue();
        int AD_Backup_ID = -1;
        String Object_Status = null;
        this.log.info(elementValue);
        Object_Status = "Update";
        Attributes atts = element.attributes;
        String releaseNumber = atts.getValue("ReleaseNo");
        if (Adempiere.MAIN_VERSION.equals(releaseNumber) || releaseNumber.equals("all")) {
            boolean success;
            String sourceName = atts.getValue("filename");
            String targetDirectory = atts.getValue("filedir");
            String oldCode = atts.getValue("oldcode");
            String newCode = atts.getValue("newcode");
            int idDetail = 0;
            File currentDirectory = new File(".");
            String packagePath = null;
            String sourcePath = null;
            try {
                packagePath = this.getPackageDirectory(ctx);
                File parentDirectory = new File(packagePath);
                while (!parentDirectory.getName().equals("packages")) {
                    parentDirectory = parentDirectory.getParentFile();
                }
                parentDirectory = parentDirectory.getParentFile();
                sourcePath = parentDirectory.getCanonicalPath();
            }
            catch (IOException e1) {
                System.out.println("Can't find adempiere-all directory.");
            }
            File backupDir = new File(packagePath + File.separator + "backup" + File.separator);
            if (!backupDir.exists() && !(success = new File(packagePath + File.separator + "backup" + File.separator).mkdirs())) {
                this.log.info("Backup directory creation failed");
            }
            String fullDirectory = sourcePath + targetDirectory;
            String targetDirectoryModified = null;
            String fileDate = null;
            char slash1 = '\\';
            char slash2 = '/';
            targetDirectoryModified = File.separator.equals("/") ? fullDirectory.replace(slash1, slash2) : fullDirectory.replace(slash2, slash1);
            File file = new File(targetDirectoryModified + sourceName);
            this.log.info(targetDirectoryModified + sourceName);
            boolean force = true;
            if (file.exists() && !force) {
                System.out.println("Output file exists.  Use the -f option to replace it.");
                return;
            }
            if (file.exists() && force) {
                Object_Status = "Update";
                this.log.info("Target Backup:" + targetDirectoryModified + sourceName);
                FileInputStream source = this.OpenInputfile(targetDirectoryModified + sourceName);
                SimpleDateFormat formatter_file = new SimpleDateFormat("yyMMddHHmmssSSSSZ");
                Date today = new Date();
                fileDate = formatter_file.format(today);
                OutputStream copy = this.OpenOutputfile(packagePath + File.separator + "backup" + File.separator + fileDate + "_" + sourceName);
                this.log.info("Source Backup:" + packagePath + File.separator + "backup" + File.separator + fileDate + "_" + sourceName);
                this.copyFile(source, copy);
                this.log.info("Backup Complete");
            }
            int success2 = CodeSnipitElementHandler.readReplace(targetDirectoryModified + sourceName, oldCode, newCode);
            int idBackup = DB.getNextID(this.getClientId(ctx), "AD_Package_Imp_Backup", this.getTrxName(ctx));
            if (success2 != -1) {
                try {
                    idDetail = this.record_log(ctx, 1, sourceName, "codesnipit", 0, 0, Object_Status, sourceName, 0);
                }
                catch (SAXException e) {
                    this.log.info("setfile:" + e);
                }
            } else {
                try {
                    idDetail = this.record_log(ctx, 0, sourceName, "codesnipit", 0, 0, Object_Status, sourceName, 0);
                }
                catch (SAXException e) {
                    this.log.info("setfile:" + e);
                }
            }
            StringBuffer sqlB = new StringBuffer("INSERT INTO AD_Package_Imp_Backup").append("(AD_Client_ID, AD_Org_ID, CreatedBy, UpdatedBy, ").append("AD_PACKAGE_IMP_BACKUP_ID, AD_PACKAGE_IMP_DETAIL_ID, AD_PACKAGE_IMP_ID,").append(" AD_PACKAGE_IMP_ORG_DIR, AD_PACKAGE_IMP_BCK_DIR)").append("VALUES(").append(" " + Env.getAD_Client_ID(ctx)).append(", " + Env.getAD_Org_ID(ctx)).append(", " + Env.getAD_User_ID(ctx)).append(", " + Env.getAD_User_ID(ctx)).append(", " + idBackup).append(", " + idDetail).append(", " + this.getPackageImpId(ctx)).append(", '" + targetDirectoryModified + sourceName).append("', '" + packagePath + File.separator + "backup" + File.separator + fileDate + "_" + sourceName).append("')");
            int no = DB.executeUpdate(sqlB.toString(), this.getTrxName(ctx));
            if (no == -1) {
                this.log.info("Insert to import backup failed");
            }
        }
    }

    public static int readReplace(String fname, String oldPattern, String replPattern) {
        StringBuffer sb = new StringBuffer();
        try {
            String line;
            FileInputStream fis = new FileInputStream(fname);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
            while ((line = reader.readLine()) != null) {
                line = line.replaceAll(oldPattern, replPattern);
                System.err.println(line);
                sb.append(line + "\n");
            }
            reader.close();
            BufferedWriter out = new BufferedWriter(new FileWriter(fname));
            out.write(sb.toString());
            out.close();
        }
        catch (Throwable e) {
            System.err.println("error replacing codesnipit " + e);
            return -1;
        }
        return 0;
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        String FileDir = Env.getContext(ctx, "File_Directory");
        String FileName = Env.getContext(ctx, "FileName");
        String OldCode = Env.getContext(ctx, "AD_Package_Code_Old");
        String NewCode = Env.getContext(ctx, "AD_Package_Code_New");
        String ReleaseNo = Env.getContext(ctx, "ReleaseNo");
        AttributesImpl atts = new AttributesImpl();
        this.createSnipitBinding(atts, FileDir, FileName, OldCode, NewCode, ReleaseNo);
        document.startElement("", "", "codesnipit", atts);
        document.endElement("", "", "codesnipit");
    }

    private AttributesImpl createSnipitBinding(AttributesImpl atts, String FileDir, String FileName, String OldCode, String NewCode, String ReleaseNo) {
        atts.clear();
        atts.addAttribute("", "", "filedir", "CDATA", FileDir);
        atts.addAttribute("", "", "filename", "CDATA", FileName);
        String preOldCode = OldCode.toString();
        String preNewCode = NewCode.toString();
        String modOldCode = preOldCode.replaceAll("\\$", "\\\\\\$").replaceAll("\\.", "\\\\.").replaceAll("\\^", "\\\\^").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\[", "\\\\[").replaceAll("\\/", "\\\\/").replaceAll("\\+", "\\\\+").replaceAll("\\*", "\\\\*").replaceAll("\\|", "\\\\|");
        String modNewCode = preNewCode.replaceAll("\\$", "\\\\\\$").replaceAll("\\.", "\\\\.").replaceAll("\\^", "\\\\^").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\[", "\\\\[").replaceAll("\\/", "\\\\/").replaceAll("\\+", "\\\\+").replaceAll("\\*", "\\\\*").replaceAll("\\|", "\\\\|");
        atts.addAttribute("", "", "oldcode", "CDATA", modOldCode);
        atts.addAttribute("", "", "newcode", "CDATA", modNewCode);
        atts.addAttribute("", "", "ReleaseNo", "CDATA", ReleaseNo);
        return atts;
    }
}

