/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CLogger;

public class POWrapper
implements InvocationHandler {
    private final CLogger log = CLogger.getCLogger(this.getClass());
    private final PO po;

    public static <T> T create(Object po, Class<T> cl) {
        if (!(po instanceof PO)) {
            throw new AdempiereException("Not a PO object - " + po);
        }
        if (cl.isInstance(po)) {
            return (T)po;
        }
        return (T)Proxy.newProxyInstance(cl.getClassLoader(), new Class[]{cl}, (InvocationHandler)new POWrapper((PO)po));
    }

    public static <T extends PO> T getPO(Object model) {
        POWrapper wrapper = (POWrapper)Proxy.getInvocationHandler(model);
        return (T)wrapper.getPO();
    }

    private POWrapper(PO po) {
        this.po = po;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.startsWith("set") && args.length == 1) {
            String propertyName = methodName.substring(3);
            this.po.set_ValueOfColumn(propertyName, args[0]);
            return null;
        }
        if (methodName.startsWith("get") && (args == null || args.length == 0)) {
            String propertyName = methodName.substring(3);
            Object value = null;
            int idx = this.po.get_ColumnIndex(propertyName);
            if (idx >= 0) {
                value = this.po.get_Value(propertyName);
            }
            if (value != null) {
                return value;
            }
            if (method.getReturnType() == Integer.TYPE) {
                value = 0;
            } else if (method.getReturnType() == BigDecimal.class) {
                value = BigDecimal.ZERO;
            } else if (this.isModelInterface(method.getReturnType())) {
                value = this.getReferencedObject(propertyName, method);
            } else if (PO.class.isAssignableFrom(method.getReturnType())) {
                throw new IllegalArgumentException("Method not supported - " + methodName);
            }
            return value;
        }
        if (methodName.startsWith("is") && (args == null || args.length == 0)) {
            String propertyName = methodName.substring(2);
            int ii = this.po.get_ColumnIndex(propertyName);
            if (ii >= 0) {
                return this.po.get_Value(ii);
            }
            ii = this.po.get_ColumnIndex("Is" + propertyName);
            if (ii >= 0) {
                return this.po.get_Value(ii);
            }
            throw new IllegalArgumentException("Method not supported - " + methodName);
        }
        return method.invoke((Object)this.po, args);
    }

    public PO getPO() {
        return this.po;
    }

    private final Object getReferencedObject(String propertyName, Method method) {
        String tableName;
        int i = this.po.get_ColumnIndex(propertyName + "_ID");
        if (i < 0) {
            return null;
        }
        Integer record_id = this.po.get_ValueAsInt(i);
        if (record_id == null || record_id <= 0) {
            return null;
        }
        Class<?> cl = method.getReturnType();
        try {
            tableName = (String)cl.getField("Table_Name").get(null);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return null;
        }
        PO child = MTable.get(this.po.getCtx(), tableName).getPO(record_id, this.po.get_TrxName());
        return child;
    }

    private boolean isModelInterface(Class<?> cl) {
        try {
            String tableName = (String)cl.getField("Table_Name").get(null);
            return tableName != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

