/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.apps.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.adempiere.apps.graph.GraphUtil;
import org.compiere.model.MColorSchema;
import org.compiere.model.MGoal;
import org.compiere.swing.CMenuItem;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.data.Range;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.ui.RectangleInsets;

public class PerformanceIndicator
extends JPanel
implements MouseListener,
ActionListener {
    private static final long serialVersionUID = 2267850468607341211L;
    private MGoal m_goal = null;
    private String m_text = null;
    private double m_line = 0.0;
    private static double s_height = 45.0;
    private static double s_width100 = 150.0;
    private static double s_widthMax = 250.0;
    private static DecimalFormat s_format = DisplayType.getNumberFormat(11);
    JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem mRefresh = new CMenuItem(Msg.getMsg(Env.getCtx(), "Refresh"), Env.getImageIcon("Refresh16.gif"));
    private static Color colorOK = Color.magenta;
    private static Color colorNotOK = Color.lightGray;
    private static Dimension indicatordimension = new Dimension(170, 120);
    private static Dimension paneldimension = new Dimension(180, 150);
    ChartPanel chartPanel;

    public PerformanceIndicator(MGoal goal) {
        this.m_goal = goal;
        this.setName(this.m_goal.getName());
        this.init();
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.setOpaque(true);
        this.mRefresh.addActionListener(this);
        this.popupMenu.add(this.mRefresh);
        this.addMouseListener(this);
    }

    public MGoal getGoal() {
        return this.m_goal;
    }

    private JFreeChart createChart() {
        JFreeChart chart = null;
        StringBuffer text = new StringBuffer(this.m_goal.getName());
        if (this.m_goal.isTarget()) {
            text.append(": ").append(this.m_goal.getPercent()).append("%");
        } else {
            text.append(": ").append(s_format.format(this.m_goal.getMeasureActual()));
        }
        this.m_text = text.toString();
        text = new StringBuffer();
        if (this.m_goal.getDescription() != null) {
            text.append(this.m_goal.getDescription()).append(": ");
        }
        text.append(s_format.format(this.m_goal.getMeasureActual()));
        if (this.m_goal.isTarget()) {
            text.append(" ").append(Msg.getMsg(Env.getCtx(), "of")).append(" ").append(s_format.format(this.m_goal.getMeasureTarget()));
        }
        this.setToolTipText(text.toString());
        this.setForeground(GraphUtil.getForeground(this.getBackground()));
        int percent = this.m_goal.getPercent();
        this.m_line = percent > 100 ? s_width100 : s_width100 * this.m_goal.getGoalPerformanceDouble();
        String title = this.m_text;
        DefaultValueDataset data = new DefaultValueDataset((double)this.m_goal.getPercent());
        MeterPlot plot = new MeterPlot((ValueDataset)data);
        MColorSchema colorSchema = this.m_goal.getColorSchema();
        int rangeLo = 0;
        int rangeHi = 0;
        for (int i = 1; i <= 4; ++i) {
            switch (i) {
                case 1: {
                    rangeHi = colorSchema.getMark1Percent();
                    break;
                }
                case 2: {
                    rangeHi = colorSchema.getMark2Percent();
                    break;
                }
                case 3: {
                    rangeHi = colorSchema.getMark3Percent();
                    break;
                }
                case 4: {
                    rangeHi = colorSchema.getMark4Percent();
                }
            }
            if (rangeHi == 9999) {
                rangeHi = (int)Math.floor((double)rangeLo * 1.5);
            }
            if (rangeLo >= rangeHi) continue;
            plot.addInterval(new MeterInterval("Normal", new Range((double)rangeLo, (double)rangeHi), (Paint)colorSchema.getColor(rangeHi), (Stroke)new BasicStroke(7.0f), (Paint)new Color(-13091716)));
            rangeLo = rangeHi;
        }
        plot.setRange(new Range(0.0, (double)rangeLo));
        plot.setDialBackgroundPaint((Paint)new Color(-13091716));
        plot.setUnits(this.m_goal.getName());
        plot.setDialShape(DialShape.CHORD);
        plot.setNeedlePaint((Paint)Color.white);
        plot.setTickSize(2000.0);
        plot.setTickLabelFont(new Font("SansSerif", 1, 12));
        plot.setTickLabelPaint((Paint)Color.white);
        plot.setInsets(new RectangleInsets(1.0, 2.0, 3.0, 4.0));
        chart = new JFreeChart(this.m_text, new Font("SansSerif", 1, 15), (Plot)plot, false);
        return chart;
    }

    private void init() {
        this.chartPanel = new ChartPanel(this.createChart(), false, false, false, false, true);
        this.chartPanel.setPreferredSize(indicatordimension);
        this.chartPanel.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent e) {
                MouseEvent me = e.getTrigger();
                if (SwingUtilities.isLeftMouseButton(me) && me.getClickCount() > 1) {
                    PerformanceIndicator.this.fireActionPerformed(me);
                }
                if (SwingUtilities.isRightMouseButton(me)) {
                    PerformanceIndicator.this.popupMenu.show((Component)me.getSource(), me.getX(), me.getY());
                }
            }

            public void chartMouseMoved(ChartMouseEvent e) {
            }
        });
        this.add((Component)this.chartPanel, "North");
        this.setMinimumSize(paneldimension);
        this.setMaximumSize(paneldimension);
        this.invalidate();
    }

    protected void updateDisplay() {
        this.chartPanel.setChart(this.createChart());
        this.invalidate();
    }

    public void addActionListener(ActionListener l) {
        if (l != null) {
            this.listenerList.add(ActionListener.class, l);
        }
    }

    public void removeActionListener(ActionListener l) {
        if (l != null) {
            this.listenerList.remove(ActionListener.class, l);
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    protected void fireActionPerformed(MouseEvent event) {
        ActionListener[] listeners = this.getActionListeners();
        ActionEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new ActionEvent(this, 1001, "pi", event.getWhen(), event.getModifiers());
            }
            listeners[i].actionPerformed(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
            this.fireActionPerformed(e);
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            this.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mRefresh) {
            this.m_goal.updateGoal(true);
            this.updateDisplay();
            Container parent = this.getParent();
            if (parent != null) {
                parent.invalidate();
            }
            this.invalidate();
            if (parent != null) {
                parent.repaint();
            } else {
                this.repaint();
            }
        }
    }
}

