/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.extensions;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.util.ClassLoaderResource;
import net.sf.jasperreports.engine.util.ClassUtils;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import net.sf.jasperreports.extensions.ExtensionsRegistryFactory;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExtensionsRegistry
implements ExtensionsRegistry {
    private final Log log = LogFactory.getLog(DefaultExtensionsRegistry.class);
    public static final String EXTENSION_RESOURCE_NAME = "jasperreports_extension.properties";
    public static final String PROPERTY_REGISTRY_FACTORY_PREFIX = "net.sf.jasperreports.extension.registry.factory.";
    public static final String PROPERTY_REGISTRY_PREFIX = "net.sf.jasperreports.extension.";
    private final ReferenceMap registrySetCache = new ReferenceMap(2, 0);
    private final ReferenceMap registryCache = new ReferenceMap(2, 0);

    @Override
    public List getExtensions(Class extensionType) {
        List registries = this.getRegistries();
        ArrayList extensions = new ArrayList(registries.size());
        for (ExtensionsRegistry registry : registries) {
            List registryExtensions = registry.getExtensions(extensionType);
            if (registryExtensions == null || registryExtensions.isEmpty()) continue;
            extensions.addAll(registryExtensions);
        }
        return extensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getRegistries() {
        List registries;
        Object cacheKey = ExtensionsEnvironment.getExtensionsCacheKey();
        ReferenceMap referenceMap = this.registrySetCache;
        synchronized (referenceMap) {
            registries = (List)this.registrySetCache.get(cacheKey);
            if (registries == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Loading registries for cache key " + cacheKey);
                }
                registries = this.loadRegistries();
                this.registrySetCache.put(cacheKey, (Object)registries);
            }
        }
        return registries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List loadRegistries() {
        ArrayList allRegistries = new ArrayList();
        List<ClassLoaderResource> extensionResources = this.loadExtensionPropertyResources();
        for (ClassLoaderResource extensionResource : extensionResources) {
            List registries;
            ClassLoader classLoader = extensionResource.getClassLoader();
            Map<URL, List> classLoaderRegistries = this.getClassLoaderRegistries(classLoader);
            URL url = extensionResource.getUrl();
            Map<URL, List> map = classLoaderRegistries;
            synchronized (map) {
                registries = classLoaderRegistries.get(url);
                if (registries == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Loading JasperReports extension properties resource " + url);
                    }
                    JRPropertiesMap props = JRPropertiesMap.loadProperties(url);
                    registries = this.loadRegistries(props);
                    classLoaderRegistries.put(url, registries);
                }
            }
            allRegistries.addAll(registries);
        }
        return allRegistries;
    }

    protected List<ClassLoaderResource> loadExtensionPropertyResources() {
        return JRLoader.getClassLoaderResources(EXTENSION_RESOURCE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<URL, List> getClassLoaderRegistries(ClassLoader classLoader) {
        ReferenceMap referenceMap = this.registryCache;
        synchronized (referenceMap) {
            HashMap<URL, List> registries = (HashMap<URL, List>)this.registryCache.get((Object)classLoader);
            if (registries == null) {
                registries = new HashMap<URL, List>();
                this.registryCache.put((Object)classLoader, registries);
            }
            return registries;
        }
    }

    protected List loadRegistries(JRPropertiesMap properties) {
        ArrayList<ExtensionsRegistry> registries = new ArrayList<ExtensionsRegistry>();
        List factoryProps = JRProperties.getProperties(properties, PROPERTY_REGISTRY_FACTORY_PREFIX);
        for (JRProperties.PropertySuffix factoryProp : factoryProps) {
            String registryId = factoryProp.getSuffix();
            String factoryClass = factoryProp.getValue();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Instantiating registry of type " + factoryClass + " for property " + factoryProp.getKey());
            }
            try {
                ExtensionsRegistry registry = this.instantiateRegistry(properties, registryId, factoryClass);
                registries.add(registry);
            }
            catch (Exception e) {
                this.log.error("Error instantiating extensions registry for " + registryId, e);
            }
        }
        return registries;
    }

    protected ExtensionsRegistry instantiateRegistry(JRPropertiesMap props, String registryId, String factoryClass) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Instantiating extensions registry for " + registryId + " using factory class " + factoryClass);
        }
        ExtensionsRegistryFactory factory = (ExtensionsRegistryFactory)ClassUtils.instantiateClass(factoryClass, ExtensionsRegistryFactory.class);
        return factory.createRegistry(registryId, props);
    }
}

