/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRAbstractScriptlet;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRSortableDataSource;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRDistinctCountIncrementerFactory;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillDatasetScriptlet;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactory;
import net.sf.jasperreports.engine.scriptlets.ScriptletFactory;
import net.sf.jasperreports.engine.scriptlets.ScriptletFactoryContext;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import net.sf.jasperreports.engine.type.WhenResourceMissingTypeEnum;
import net.sf.jasperreports.engine.util.JRQueryExecuterUtils;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFillDataset
implements JRDataset {
    private static final Log log = LogFactory.getLog(JRFillDataset.class);
    private final JRBaseFiller filler;
    private final JRDataset parent;
    private final boolean isMain;
    protected JRQuery query = null;
    private boolean useDatasourceParamValue = false;
    private boolean useConnectionParamValue = false;
    protected JRFillParameter[] parameters = null;
    protected Map parametersMap = null;
    protected JRFillField[] fields = null;
    protected Map fieldsMap = null;
    protected JRFillVariable[] variables = null;
    protected Map variablesMap = null;
    protected Set variableCalculationReqs;
    protected JRFillElementDataset[] elementDatasets;
    protected JRFillElementDataset[] origElementDatasets;
    protected JRFillGroup[] groups = null;
    protected String resourceBundleBaseName = null;
    protected WhenResourceMissingTypeEnum whenResourceMissingType;
    protected String scriptletClassName = null;
    protected JRDataSource dataSource = null;
    protected Locale locale = null;
    protected ResourceBundle resourceBundle = null;
    protected TimeZone timeZone = null;
    protected int reportCount = 0;
    protected JRCalculator calculator = null;
    protected List scriptlets = null;
    protected JRAbstractScriptlet delegateScriptlet = new JRFillDatasetScriptlet(this);
    protected Integer reportMaxCount = null;
    private JRQueryExecuter queryExecuter;

    public JRFillDataset(JRBaseFiller filler, JRDataset dataset, JRFillObjectFactory factory) {
        factory.put(dataset, this);
        this.filler = filler;
        this.parent = dataset;
        this.isMain = dataset.isMainDataset();
        this.scriptletClassName = dataset.getScriptletClass();
        this.resourceBundleBaseName = dataset.getResourceBundle();
        this.whenResourceMissingType = dataset.getWhenResourceMissingTypeValue();
        this.query = dataset.getQuery();
        this.setParameters(dataset, factory);
        this.setFields(dataset, factory);
        this.setVariables(dataset, factory);
        this.setGroups(dataset, factory);
    }

    private void setParameters(JRDataset dataset, JRFillObjectFactory factory) {
        JRParameter[] jrParameters = dataset.getParameters();
        if (jrParameters != null && jrParameters.length > 0) {
            this.parameters = new JRFillParameter[jrParameters.length];
            this.parametersMap = new HashMap();
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = factory.getParameter(jrParameters[i]);
                this.parametersMap.put(this.parameters[i].getName(), this.parameters[i]);
            }
        }
    }

    private void setGroups(JRDataset dataset, JRFillObjectFactory factory) {
        JRGroup[] jrGroups = dataset.getGroups();
        if (jrGroups != null && jrGroups.length > 0) {
            this.groups = new JRFillGroup[jrGroups.length];
            for (int i = 0; i < this.groups.length; ++i) {
                this.groups[i] = factory.getGroup(jrGroups[i]);
            }
        }
    }

    private void setVariables(JRDataset dataset, JRFillObjectFactory factory) {
        JRVariable[] jrVariables = dataset.getVariables();
        if (jrVariables != null && jrVariables.length > 0) {
            ArrayList variableList = new ArrayList(jrVariables.length * 3);
            this.variablesMap = new HashMap();
            for (int i = 0; i < jrVariables.length; ++i) {
                this.addVariable(jrVariables[i], variableList, factory);
            }
            this.setVariables(variableList);
        }
    }

    private JRFillVariable addVariable(JRVariable parentVariable, List variableList, JRFillObjectFactory factory) {
        JRFillVariable variable = factory.getVariable(parentVariable);
        CalculationEnum calculation = variable.getCalculationValue();
        switch (calculation) {
            case AVERAGE: 
            case VARIANCE: {
                JRVariable countVar = this.createHelperVariable(parentVariable, "_COUNT", CalculationEnum.COUNT);
                JRFillVariable fillCountVar = this.addVariable(countVar, variableList, factory);
                variable.setHelperVariable(fillCountVar, (byte)0);
                JRVariable sumVar = this.createHelperVariable(parentVariable, "_SUM", CalculationEnum.SUM);
                JRFillVariable fillSumVar = this.addVariable(sumVar, variableList, factory);
                variable.setHelperVariable(fillSumVar, (byte)1);
                break;
            }
            case STANDARD_DEVIATION: {
                JRVariable varianceVar = this.createHelperVariable(parentVariable, "_VARIANCE", CalculationEnum.VARIANCE);
                JRFillVariable fillVarianceVar = this.addVariable(varianceVar, variableList, factory);
                variable.setHelperVariable(fillVarianceVar, (byte)2);
                break;
            }
            case DISTINCT_COUNT: {
                JRVariable countVar = this.createDistinctCountHelperVariable(parentVariable);
                JRFillVariable fillCountVar = this.addVariable(countVar, variableList, factory);
                variable.setHelperVariable(fillCountVar, (byte)0);
                break;
            }
        }
        variableList.add(variable);
        return variable;
    }

    private JRVariable createHelperVariable(JRVariable variable, String nameSuffix, CalculationEnum calculation) {
        JRDesignVariable helper = new JRDesignVariable();
        helper.setName(variable.getName() + nameSuffix);
        helper.setValueClassName(variable.getValueClassName());
        helper.setIncrementerFactoryClassName(variable.getIncrementerFactoryClassName());
        helper.setResetType(variable.getResetTypeValue());
        helper.setResetGroup(variable.getResetGroup());
        helper.setIncrementType(variable.getIncrementTypeValue());
        helper.setIncrementGroup(variable.getIncrementGroup());
        helper.setCalculation(calculation);
        helper.setSystemDefined(true);
        helper.setExpression(variable.getExpression());
        return helper;
    }

    private JRVariable createDistinctCountHelperVariable(JRVariable variable) {
        JRDesignVariable helper = new JRDesignVariable();
        helper.setName(variable.getName() + "_DISTINCT_COUNT");
        helper.setValueClassName(variable.getValueClassName());
        helper.setIncrementerFactoryClassName(JRDistinctCountIncrementerFactory.class.getName());
        helper.setResetType(ResetTypeEnum.REPORT);
        if (variable.getIncrementTypeValue() != IncrementTypeEnum.NONE) {
            helper.setResetType(ResetTypeEnum.getByValue(variable.getIncrementTypeValue().getValue()));
        }
        helper.setResetGroup(variable.getIncrementGroup());
        helper.setCalculation(CalculationEnum.NOTHING);
        helper.setSystemDefined(true);
        helper.setExpression(variable.getExpression());
        return helper;
    }

    private void setVariables(List variableList) {
        this.variables = new JRFillVariable[variableList.size()];
        this.variables = variableList.toArray(this.variables);
        for (int i = 0; i < this.variables.length; ++i) {
            this.variablesMap.put(this.variables[i].getName(), this.variables[i]);
        }
    }

    private void setFields(JRDataset dataset, JRFillObjectFactory factory) {
        JRField[] jrFields = dataset.getFields();
        if (jrFields != null && jrFields.length > 0) {
            this.fields = new JRFillField[jrFields.length];
            this.fieldsMap = new HashMap();
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = factory.getField(jrFields[i]);
                this.fieldsMap.put(this.fields[i].getName(), this.fields[i]);
            }
        }
    }

    public void createCalculator(JasperReport jasperReport) throws JRException {
        this.setCalculator(JRFillDataset.createCalculator(jasperReport, this));
    }

    protected void setCalculator(JRCalculator calculator) {
        this.calculator = calculator;
    }

    protected static JRCalculator createCalculator(JasperReport jasperReport, JRDataset dataset) throws JRException {
        JREvaluator evaluator = JasperCompileManager.loadEvaluator(jasperReport, dataset);
        return new JRCalculator(evaluator);
    }

    public void initCalculator() throws JRException {
        this.calculator.init(this);
    }

    protected void inheritFromMain() {
        if (this.resourceBundleBaseName == null && !this.isMain) {
            this.resourceBundleBaseName = this.filler.mainDataset.resourceBundleBaseName;
            this.whenResourceMissingType = this.filler.mainDataset.whenResourceMissingType;
        }
    }

    protected List createScriptlets(Map parameterValues) throws JRException {
        ScriptletFactoryContext context = new ScriptletFactoryContext(parameterValues, this);
        this.scriptlets = new ArrayList();
        List factories = ExtensionsEnvironment.getExtensionsRegistry().getExtensions(ScriptletFactory.class);
        for (ScriptletFactory factory : factories) {
            List tmpScriptlets = factory.getScriplets(context);
            if (tmpScriptlets == null) continue;
            this.scriptlets.addAll(tmpScriptlets);
        }
        if (this.scriptlets.size() == 0) {
            this.scriptlets.add(0, new JRDefaultScriptlet());
        }
        return this.scriptlets;
    }

    protected void initElementDatasets(JRFillObjectFactory factory) {
        this.elementDatasets = factory.getElementDatasets(this);
    }

    protected void filterElementDatasets(JRFillElementDataset elementDataset) {
        this.origElementDatasets = this.elementDatasets;
        this.elementDatasets = new JRFillElementDataset[]{elementDataset};
    }

    protected void restoreElementDatasets() {
        if (this.origElementDatasets != null) {
            this.elementDatasets = this.origElementDatasets;
            this.origElementDatasets = null;
        }
    }

    protected ResourceBundle loadResourceBundle() {
        ResourceBundle loadedBundle = this.resourceBundleBaseName == null ? null : JRResourcesUtil.loadResourceBundle(this.resourceBundleBaseName, this.locale);
        return loadedBundle;
    }

    public void setParameterValues(Map parameterValues) throws JRException {
        parameterValues.put("REPORT_PARAMETERS_MAP", parameterValues);
        if (this.filler != null) {
            parameterValues.put("JASPER_REPORT", this.filler.getJasperReport());
        }
        this.reportMaxCount = (Integer)parameterValues.get("REPORT_MAX_COUNT");
        this.locale = (Locale)parameterValues.get("REPORT_LOCALE");
        if (this.locale == null) {
            this.locale = Locale.getDefault();
            parameterValues.put("REPORT_LOCALE", this.locale);
        }
        this.resourceBundle = (ResourceBundle)parameterValues.get("REPORT_RESOURCE_BUNDLE");
        if (this.resourceBundle == null) {
            this.resourceBundle = this.loadResourceBundle();
            if (this.resourceBundle != null) {
                parameterValues.put("REPORT_RESOURCE_BUNDLE", this.resourceBundle);
            }
        }
        this.timeZone = (TimeZone)parameterValues.get("REPORT_TIME_ZONE");
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
            parameterValues.put("REPORT_TIME_ZONE", this.timeZone);
        }
        this.scriptlets = this.createScriptlets(parameterValues);
        this.delegateScriptlet.setData(this.parametersMap, this.fieldsMap, this.variablesMap, this.groups);
        this.setFillParameterValues(parameterValues);
    }

    public void initDatasource() throws JRException {
        JRSortField[] sortFields;
        this.queryExecuter = null;
        this.dataSource = (JRDataSource)this.getParameterValue("REPORT_DATA_SOURCE");
        if (!this.useDatasourceParamValue && (this.useConnectionParamValue || this.dataSource == null)) {
            this.dataSource = this.createQueryDatasource();
            this.setParameter("REPORT_DATA_SOURCE", (Object)this.dataSource);
        }
        if ((sortFields = this.getSortFields()) != null && sortFields.length > 0) {
            this.dataSource = new JRSortableDataSource(this.dataSource, this.fields, sortFields, this.locale);
            this.setParameter("REPORT_DATA_SOURCE", (Object)this.dataSource);
        }
    }

    private void setFillParameterValues(Map parameterValues) throws JRException {
        if (this.parameters != null && this.parameters.length > 0) {
            for (int i = 0; i < this.parameters.length; ++i) {
                Object value = null;
                if (parameterValues.containsKey(this.parameters[i].getName())) {
                    value = parameterValues.get(this.parameters[i].getName());
                } else if (!this.parameters[i].isSystemDefined() && (value = this.calculator.evaluate(this.parameters[i].getDefaultValueExpression(), (byte)3)) != null) {
                    parameterValues.put(this.parameters[i].getName(), value);
                }
                this.setParameter(this.parameters[i], value);
            }
        }
    }

    protected Map getParameterValuesMap() {
        JRFillParameter paramValuesParameter = (JRFillParameter)this.parametersMap.get("REPORT_PARAMETERS_MAP");
        return (Map)paramValuesParameter.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JRDataSource createQueryDatasource() throws JRException {
        if (this.query == null) {
            return null;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Fill " + this.filler.fillerId + ": Creating " + this.query.getLanguage() + " query executer");
            }
            JRQueryExecuterFactory queryExecuterFactory = JRQueryExecuterUtils.getQueryExecuterFactory(this.query.getLanguage());
            this.queryExecuter = queryExecuterFactory.createQueryExecuter(this.parent, this.parametersMap);
            this.filler.fillContext.setRunningQueryExecuter(this.queryExecuter);
            JRDataSource jRDataSource = this.queryExecuter.createDatasource();
            return jRDataSource;
        }
        finally {
            this.filler.fillContext.clearRunningQueryExecuter();
        }
    }

    protected void reset() {
        this.useDatasourceParamValue = false;
        this.useConnectionParamValue = false;
    }

    public void setDatasourceParameterValue(Map parameterValues, JRDataSource ds) {
        this.useDatasourceParamValue = true;
        if (ds != null) {
            parameterValues.put("REPORT_DATA_SOURCE", ds);
        }
    }

    public void setConnectionParameterValue(Map parameterValues, Connection conn) {
        this.useConnectionParamValue = true;
        if (conn != null) {
            parameterValues.put("REPORT_CONNECTION", conn);
        }
    }

    public void closeDatasource() {
        if (this.queryExecuter != null) {
            if (log.isDebugEnabled()) {
                log.debug("Fill " + this.filler.fillerId + ": closing query executer");
            }
            this.queryExecuter.close();
            this.queryExecuter = null;
        }
        this.reset();
    }

    public void start() {
        this.reportCount = 0;
    }

    public boolean next() throws JRException {
        boolean hasNext = false;
        if (this.dataSource != null) {
            boolean includeRow = true;
            JRExpression filterExpression = this.getFilterExpression();
            do {
                if (!(hasNext = this.advanceDataSource())) continue;
                this.setOldValues();
                this.calculator.estimateVariables();
                if (filterExpression != null) {
                    Boolean filterExprResult = (Boolean)this.calculator.evaluate(filterExpression, (byte)2);
                    boolean bl = includeRow = filterExprResult != null && filterExprResult != false;
                }
                if (includeRow) continue;
                this.revertToOldValues();
            } while (hasNext && !includeRow);
            if (hasNext) {
                ++this.reportCount;
            }
        }
        return hasNext;
    }

    protected void setOldValues() throws JRException {
        int i;
        if (this.fields != null && this.fields.length > 0) {
            for (i = 0; i < this.fields.length; ++i) {
                JRFillField field = this.fields[i];
                field.setPreviousOldValue(field.getOldValue());
                field.setOldValue(field.getValue());
                field.setValue(this.dataSource.getFieldValue(field));
            }
        }
        if (this.variables != null && this.variables.length > 0) {
            for (i = 0; i < this.variables.length; ++i) {
                JRFillVariable variable = this.variables[i];
                variable.setPreviousOldValue(variable.getOldValue());
                variable.setOldValue(variable.getValue());
            }
        }
    }

    protected void revertToOldValues() {
        int i;
        if (this.fields != null && this.fields.length > 0) {
            for (i = 0; i < this.fields.length; ++i) {
                JRFillField field = this.fields[i];
                field.setValue(field.getOldValue());
                field.setOldValue(field.getPreviousOldValue());
            }
        }
        if (this.variables != null && this.variables.length > 0) {
            for (i = 0; i < this.variables.length; ++i) {
                JRFillVariable variable = this.variables[i];
                variable.setValue(variable.getOldValue());
                variable.setOldValue(variable.getPreviousOldValue());
            }
        }
    }

    protected boolean advanceDataSource() throws JRException {
        boolean hasNext = (this.reportMaxCount == null || this.reportMaxCount > this.reportCount) && this.dataSource.next();
        return hasNext;
    }

    protected void setParameter(String parameterName, Object value) throws JRException {
        JRFillParameter parameter = (JRFillParameter)this.parametersMap.get(parameterName);
        if (parameter != null) {
            this.setParameter(parameter, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setParameter(JRFillParameter parameter, Object value) throws JRException {
        if (value != null) {
            if (!parameter.getValueClass().isInstance(value)) throw new JRException("Incompatible " + value.getClass().getName() + " value assigned to parameter " + parameter.getName() + " in the " + this.getName() + " dataset.");
            parameter.setValue(value);
            return;
        } else {
            parameter.setValue(value);
        }
    }

    public Object getVariableValue(String variableName) {
        JRFillVariable var = (JRFillVariable)this.variablesMap.get(variableName);
        if (var == null) {
            throw new JRRuntimeException("No such variable " + variableName);
        }
        return var.getValue();
    }

    public Object getParameterValue(String parameterName) {
        return this.getParameterValue(parameterName, false);
    }

    public Object getParameterValue(String parameterName, boolean ignoreMissing) {
        Object value;
        JRFillParameter param = (JRFillParameter)this.parametersMap.get(parameterName);
        if (param == null) {
            if (!ignoreMissing) {
                throw new JRRuntimeException("No such parameter " + parameterName);
            }
            value = null;
        } else {
            value = param.getValue();
        }
        return value;
    }

    public Object getFieldValue(String fieldName) {
        JRFillField var = (JRFillField)this.fieldsMap.get(fieldName);
        if (var == null) {
            throw new JRRuntimeException("No such field " + fieldName);
        }
        return var.getValue();
    }

    protected void addVariableCalculationReq(String variableName, CalculationEnum calculation) {
        if (this.variableCalculationReqs == null) {
            this.variableCalculationReqs = new HashSet();
        }
        this.variableCalculationReqs.add(new VariableCalculationReq(variableName, calculation));
    }

    protected void checkVariableCalculationReqs(JRFillObjectFactory factory) {
        if (this.variableCalculationReqs != null && !this.variableCalculationReqs.isEmpty()) {
            ArrayList variableList = new ArrayList(this.variables.length * 2);
            for (int i = 0; i < this.variables.length; ++i) {
                JRFillVariable variable = this.variables[i];
                this.checkVariableCalculationReq(variable, variableList, factory);
            }
            this.setVariables(variableList);
        }
    }

    private void checkVariableCalculationReq(JRFillVariable variable, List variableList, JRFillObjectFactory factory) {
        JRFillVariable fillCountVar;
        JRVariable countVar;
        if (this.hasVariableCalculationReq(variable, CalculationEnum.AVERAGE) || this.hasVariableCalculationReq(variable, CalculationEnum.VARIANCE)) {
            if (variable.getHelperVariable((byte)0) == null) {
                countVar = this.createHelperVariable(variable, "_COUNT", CalculationEnum.COUNT);
                fillCountVar = factory.getVariable(countVar);
                this.checkVariableCalculationReq(fillCountVar, variableList, factory);
                variable.setHelperVariable(fillCountVar, (byte)0);
            }
            if (variable.getHelperVariable((byte)1) == null) {
                JRVariable sumVar = this.createHelperVariable(variable, "_SUM", CalculationEnum.SUM);
                JRFillVariable fillSumVar = factory.getVariable(sumVar);
                this.checkVariableCalculationReq(fillSumVar, variableList, factory);
                variable.setHelperVariable(fillSumVar, (byte)1);
            }
        }
        if (this.hasVariableCalculationReq(variable, CalculationEnum.STANDARD_DEVIATION) && variable.getHelperVariable((byte)2) == null) {
            JRVariable varianceVar = this.createHelperVariable(variable, "_VARIANCE", CalculationEnum.VARIANCE);
            JRFillVariable fillVarianceVar = factory.getVariable(varianceVar);
            this.checkVariableCalculationReq(fillVarianceVar, variableList, factory);
            variable.setHelperVariable(fillVarianceVar, (byte)2);
        }
        if (this.hasVariableCalculationReq(variable, CalculationEnum.DISTINCT_COUNT) && variable.getHelperVariable((byte)0) == null) {
            countVar = this.createDistinctCountHelperVariable(variable);
            fillCountVar = factory.getVariable(countVar);
            this.checkVariableCalculationReq(fillCountVar, variableList, factory);
            variable.setHelperVariable(fillCountVar, (byte)0);
        }
        variableList.add(variable);
    }

    private boolean hasVariableCalculationReq(JRVariable var, CalculationEnum calculation) {
        return this.variableCalculationReqs.contains(new VariableCalculationReq(var.getName(), calculation));
    }

    public String getName() {
        return this.parent.getName();
    }

    public String getScriptletClass() {
        return this.parent.getScriptletClass();
    }

    public JRScriptlet[] getScriptlets() {
        return this.parent.getScriptlets();
    }

    public JRParameter[] getParameters() {
        return this.parameters;
    }

    public Map getParametersMap() {
        return this.parametersMap;
    }

    public JRQuery getQuery() {
        return this.query;
    }

    public JRField[] getFields() {
        return this.fields;
    }

    public JRSortField[] getSortFields() {
        return this.parent.getSortFields();
    }

    public JRVariable[] getVariables() {
        return this.variables;
    }

    public JRGroup[] getGroups() {
        return this.groups;
    }

    public boolean isMainDataset() {
        return this.isMain;
    }

    public String getResourceBundle() {
        return this.parent.getResourceBundle();
    }

    public byte getWhenResourceMissingType() {
        return this.getWhenResourceMissingTypeValue().getValue();
    }

    public WhenResourceMissingTypeEnum getWhenResourceMissingTypeValue() {
        return this.whenResourceMissingType;
    }

    public void setWhenResourceMissingType(byte whenResourceMissingType) {
        this.setWhenResourceMissingType(WhenResourceMissingTypeEnum.getByValue(whenResourceMissingType));
    }

    public void setWhenResourceMissingType(WhenResourceMissingTypeEnum whenResourceMissingType) {
        this.whenResourceMissingType = whenResourceMissingType;
    }

    public boolean hasProperties() {
        return this.parent.hasProperties();
    }

    public JRPropertiesMap getPropertiesMap() {
        return this.parent.getPropertiesMap();
    }

    public JRPropertiesHolder getParentProperties() {
        return this.isMain ? null : this.filler.getJasperReport();
    }

    public JRExpression getFilterExpression() {
        return this.parent.getFilterExpression();
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }

    public Object evaluateExpression(JRExpression expression, byte evaluation) throws JRException {
        return this.calculator.evaluate(expression, evaluation);
    }

    protected static class VariableCalculationReq {
        String variableName;
        CalculationEnum calculation;

        VariableCalculationReq(String variableName, CalculationEnum calculation) {
            this.variableName = variableName;
            this.calculation = calculation;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof VariableCalculationReq)) {
                return false;
            }
            VariableCalculationReq r = (VariableCalculationReq)o;
            return this.variableName.equals(r.variableName) && this.calculation == r.calculation;
        }

        public int hashCode() {
            return 31 * this.calculation.getValue() + this.variableName.hashCode();
        }
    }
}

