/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.xmlss;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class XmlssTableBuilder {
    private Writer bodyWriter = null;

    protected XmlssTableBuilder(String name, Writer bodyWriter, Writer styleWriter) {
        this.bodyWriter = bodyWriter;
    }

    protected XmlssTableBuilder(int reportIndex, int pageIndex, Writer bodyWriter, Writer styleWriter) {
        this.bodyWriter = bodyWriter;
    }

    public void buildTableHeader() throws IOException {
        this.bodyWriter.write("<Table>\n");
    }

    public void buildTableFooter() throws IOException {
        this.bodyWriter.write("</Table>\n");
    }

    public void buildRowHeader(int rowIndex, int rowHeight) throws IOException {
        this.bodyWriter.write("<Row");
        this.bodyWriter.write(" ss:AutoFitHeight=\"0\"");
        this.bodyWriter.write(" ss:Height=\"" + rowHeight + "\"");
        this.bodyWriter.write(">\n");
    }

    public void buildRowFooter() throws IOException {
        this.bodyWriter.write("</Row>\n");
    }

    public void buildColumnTag(int colIndex, int colWidth) throws IOException {
        this.bodyWriter.write("<Column");
        this.bodyWriter.write(" ss:AutoFitWidth=\"0\"");
        this.bodyWriter.write(" ss:Width=\"" + colWidth + "\"");
        this.bodyWriter.write("/>\n");
    }

    public void buildCellHeader(String cellStyleID, int colSpan, int rowSpan, String hyperlinkURL, String tooltip, String formula) throws IOException {
        this.bodyWriter.write("<Cell");
        if (cellStyleID != null) {
            this.bodyWriter.write(" ss:StyleID=\"" + cellStyleID + "\"");
        }
        if (colSpan > 1) {
            this.bodyWriter.write(" ss:MergeAcross=\"" + colSpan + "\"");
        }
        if (rowSpan > 1) {
            this.bodyWriter.write(" ss:MergeDown=\"" + rowSpan + "\"");
        }
        if (formula != null) {
            this.bodyWriter.write(" ss:Formula=\"" + formula + "\"");
        }
        if (hyperlinkURL != null) {
            this.bodyWriter.write(" ss:HRef=\"" + hyperlinkURL + "\"");
            if (tooltip != null) {
                this.bodyWriter.write(" x:HRefScreenTip=\"" + JRStringUtil.xmlEncode(tooltip) + "\"");
            }
        }
        this.bodyWriter.write(">\n");
    }

    public void buildCellFooter() throws IOException {
        this.bodyWriter.write("</Cell>\n");
    }

    public void buildEmptyCell(int emptyCellColSpan, int emptyCellRowSpan) throws IOException {
        this.bodyWriter.write("<Cell");
        if (emptyCellColSpan > 1) {
            this.bodyWriter.write(" ss:MergeAcross=\"" + (emptyCellColSpan - 1) + "\"");
        }
        if (emptyCellRowSpan > 1) {
            this.bodyWriter.write(" ss:MergeDown=\"" + (emptyCellRowSpan - 1) + "\"");
        }
        this.bodyWriter.write("/>\n");
    }
}

